/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.order.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlprogress.order.bean.DeliveryEntity;
import com.ejianc.business.jlprogress.order.mapper.DeliveryMapper;
import com.ejianc.business.jlprogress.order.service.IDeliveryService;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="deliveryService")
public class DeliveryServiceImpl
extends BaseServiceImpl<DeliveryMapper, DeliveryEntity>
implements IDeliveryService {
    @Autowired
    private DeliveryMapper deliveryMapper;

    @Override
    public Integer selectCount(Long Id, Long contractId) {
        LambdaQueryWrapper Wrapper2 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)Wrapper2.eq(contractId != null, DeliveryEntity::getContractId, (Object)contractId)).eq(BaseEntity::getDr, (Object)0);
        if (Id != null) {
            Wrapper2.ne(BaseEntity::getId, (Object)Id);
        }
        Integer count = ((DeliveryMapper)this.baseMapper).selectCount((Wrapper)Wrapper2);
        return count;
    }

    @Override
    public DeliveryEntity selectNotActivated(Long Id, Long contractId) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        list.add(3);
        LambdaQueryWrapper Wrapper2 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrapper2.eq(contractId != null, DeliveryEntity::getContractId, (Object)contractId)).eq(BaseEntity::getDr, (Object)0)).ne(BaseEntity::getId, (Object)Id)).notIn(DeliveryEntity::getBillState, list);
        DeliveryEntity one = (DeliveryEntity)((Object)this.getOne((Wrapper)Wrapper2));
        return one;
    }

    @Override
    public List<DeliveryEntity> queryListWithCheckCount(QueryParam param) {
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = DeliveryServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<DeliveryEntity> list = this.deliveryMapper.queryListWithCheckCount(page, wrapper);
        return list;
    }

    @Override
    public Map<Long, JSONObject> getDeliveryDataByContractIdList(List<Long> ids) {
        HashMap<Long, JSONObject> collectMap = new HashMap<Long, JSONObject>();
        List list = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(DeliveryEntity::getBillState, Arrays.asList(1, 3))).in(DeliveryEntity::getContractId, ids));
        if (CollectionUtils.isNotEmpty((Collection)list) && list.size() > 0) {
            Map<Long, List<DeliveryEntity>> deliveryDataMap = list.stream().collect(Collectors.groupingBy(DeliveryEntity::getContractId));
            for (Long contractId : deliveryDataMap.keySet()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("deliveryNoticeList", deliveryDataMap.get(contractId));
                collectMap.put(contractId, jsonObject);
            }
        }
        return collectMap;
    }
}

