/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.order.service.impl;

import com.ejianc.business.jlprogress.order.bean.SalesEntity;
import com.ejianc.business.jlprogress.order.mapper.SalesMapper;
import com.ejianc.business.jlprogress.order.service.ISalesService;
import com.ejianc.business.jlprogress.order.vo.SalesListVO;
import com.ejianc.business.jlprogress.order.vo.SalesVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="salesService")
public class SalesServiceImpl
extends BaseServiceImpl<SalesMapper, SalesEntity>
implements ISalesService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String CODE = "P-NzM5iT0016";
    @Autowired
    private SalesMapper mapper;

    @Override
    public SalesListVO getContractSales(Long contractId) {
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        ArrayList<Integer> billStates = new ArrayList<Integer>();
        billStates.add(1);
        billStates.add(3);
        param.getParams().put("billState", new Parameter("in", billStates));
        param.getOrderMap().put("orderDate", "asc");
        List salesList = super.queryList(param);
        List list = BeanMapper.mapList((Iterable)salesList, SalesVO.class);
        BigDecimal countMny = list.size() > 0 ? list.stream().filter(e -> null != e.getOrderMny()).map(SalesVO::getOrderMny).reduce(BigDecimal.ZERO, BigDecimal::add) : BigDecimal.ZERO;
        SalesListVO salesListVO = new SalesListVO();
        salesListVO.setFirstOrderDate(CollectionUtils.isNotEmpty((Collection)salesList) && salesList.size() > 0 ? ((SalesEntity)((Object)salesList.get(0))).getOrderDate() : null);
        salesListVO.setCountMny(countMny);
        salesListVO.setSalesList(list);
        return salesListVO;
    }

    @Override
    public Map<Long, SalesListVO> getContractSalesByContractIdList(List<Long> contractIdList) {
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("in", contractIdList));
        ArrayList<Integer> billStates = new ArrayList<Integer>();
        billStates.add(1);
        billStates.add(3);
        param.getParams().put("billState", new Parameter("in", billStates));
        param.getOrderMap().put("orderDate", "asc");
        List salesList = super.queryList(param);
        List list = BeanMapper.mapList((Iterable)salesList, SalesVO.class);
        HashMap<Long, SalesListVO> returnMap = new HashMap<Long, SalesListVO>();
        if (CollectionUtils.isNotEmpty((Collection)list) && list.size() > 0) {
            Map<Long, List<SalesVO>> collectMap = list.stream().collect(Collectors.groupingBy(SalesVO::getContractId));
            for (Long contractId : collectMap.keySet()) {
                List<SalesVO> salesVOList = collectMap.get(contractId);
                BigDecimal countMny = salesVOList.size() > 0 ? salesVOList.stream().filter(e -> null != e.getOrderMny()).map(SalesVO::getOrderMny).reduce(BigDecimal.ZERO, BigDecimal::add) : BigDecimal.ZERO;
                SalesListVO salesListVO = new SalesListVO();
                salesListVO.setFirstOrderDate(CollectionUtils.isNotEmpty(salesVOList) && salesVOList.size() > 0 ? salesVOList.get(0).getOrderDate() : null);
                salesListVO.setCountMny(countMny);
                salesListVO.setSalesList(salesVOList);
                salesListVO.setContractId(contractId);
                returnMap.put(contractId, salesListVO);
            }
        }
        return returnMap;
    }
}

