/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.progress.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jlprogress.progress.bean.ProgressDetailEntity;
import com.ejianc.business.jlprogress.progress.bean.TotalPlanDetailEntity;
import com.ejianc.business.jlprogress.progress.bean.TotalPlanEntity;
import com.ejianc.business.jlprogress.progress.cons.PlanCloumCons;
import com.ejianc.business.jlprogress.progress.cons.PlanConstant;
import com.ejianc.business.jlprogress.progress.handler.CommonHelper;
import com.ejianc.business.jlprogress.progress.mapper.TotalPlanDetailMapper;
import com.ejianc.business.jlprogress.progress.mapper.TotalPlanMapper;
import com.ejianc.business.jlprogress.progress.service.IExecPlanService;
import com.ejianc.business.jlprogress.progress.service.ITotalPlanDetailService;
import com.ejianc.business.jlprogress.progress.service.ITotalPlanService;
import com.ejianc.business.jlprogress.progress.utils.Export;
import com.ejianc.business.jlprogress.progress.utils.OrgUtil;
import com.ejianc.business.jlprogress.progress.utils.PlusUtil;
import com.ejianc.business.jlprogress.progress.utils.TreeHelper2;
import com.ejianc.business.jlprogress.progress.vo.TotalPlanDetailVO;
import com.ejianc.business.jlprogress.progress.vo.TotalPlanVO;
import com.ejianc.business.jlprogress.progress.vo.XmlVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="totalPlanService")
public class TotalPlanServiceImpl
extends BaseServiceImpl<TotalPlanMapper, TotalPlanEntity>
implements ITotalPlanService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "ZJKJ_TOTAL_PLAN";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private TotalPlanMapper progressMapper;
    @Autowired
    private TotalPlanDetailMapper progressDetailMapper;
    @Autowired
    private ITotalPlanDetailService detailService;
    @Autowired
    private IExecPlanService execPlanService;
    @Autowired
    private OrgUtil orgUtil;
    @Autowired
    private CommonHelper commonHelper;
    private static final String PC_URL = "/ejc-jlprogress-frontend/#/totalPlan/card?id=";
    private static final String MOBILE_URL = "/ejc-jlprogress-mobile/#/totalPlan/card?id=";
    @Autowired
    private IPushMessageApi pushMessageApi;

    @Override
    public CommonResponse<TotalPlanVO> saveOrUpdate(TotalPlanVO saveOrUpdateVO) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TotalPlanEntity::getProjectId, (Object)saveOrUpdateVO.getProjectId());
        queryWrapper.ne(null != saveOrUpdateVO.getId(), BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BusinessException("\u8be5\u9879\u76ee\u5df2\u5b58\u5728\u603b\u8ba1\u5212");
        }
        this.execPlanService.validateProject(saveOrUpdateVO.getProjectId(), saveOrUpdateVO.getId());
        OrgVO orgVO = this.orgUtil.findById(saveOrUpdateVO.getOrgId());
        saveOrUpdateVO.setCorpId(orgVO.getId());
        saveOrUpdateVO.setCorpCode(orgVO.getCode());
        saveOrUpdateVO.setCorpName(orgVO.getName());
        Long tenantId = InvocationInfoProxy.getTenantid();
        TotalPlanEntity progressEntity = null;
        if (saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() > 0L) {
            progressEntity = (TotalPlanEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, TotalPlanEntity.class));
            this.progressMapper.updateById((Object)progressEntity);
            List progressDetailList = saveOrUpdateVO.getTasks();
            if (progressDetailList.size() > 0) {
                HashMap<String, Long> pkMap = new HashMap<String, Long>();
                ArrayList saveVOList = new ArrayList();
                TreeHelper2.tree2List(pkMap, saveVOList, progressDetailList, saveOrUpdateVO.getImportFlag());
                if (saveOrUpdateVO.getImportFlag().booleanValue()) {
                    this.detailService.deleteByProgressId(progressEntity.getId());
                }
                Iterator iterator = saveVOList.iterator();
                while (iterator.hasNext()) {
                    TotalPlanDetailEntity progressDetailEntity;
                    TotalPlanDetailVO progressDetailVo = (TotalPlanDetailVO)iterator.next();
                    if (saveOrUpdateVO.getImportFlag().booleanValue() || "added".equals(progressDetailVo.get_state())) {
                        progressDetailEntity = TotalPlanDetailEntity.convertVoToEntity(progressDetailVo);
                        progressDetailEntity.setProgressId(progressEntity.getId());
                        this.progressDetailMapper.insert((Object)progressDetailEntity);
                        continue;
                    }
                    if (!"modified".equals(progressDetailVo.get_state())) continue;
                    progressDetailEntity = TotalPlanDetailEntity.convertVoToEntity(progressDetailVo);
                    progressDetailEntity.setProgressId(progressEntity.getId());
                    this.progressDetailMapper.updateById((Object)progressDetailEntity);
                }
            } else {
                throw new BusinessException("\u8ba1\u5212\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
            }
            List delDetailList = saveOrUpdateVO.getRemovedTasks();
            if (delDetailList != null && delDetailList.size() > 0) {
                for (TotalPlanDetailVO progressDetailVo : delDetailList) {
                    this.progressDetailMapper.deleteById((Serializable)((Object)progressDetailVo.getUid()));
                }
            }
        } else {
            Long masterPkId = IdWorker.getId();
            if (StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getBillCode())) {
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, tenantId);
                if (billCode.isSuccess()) {
                    saveOrUpdateVO.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            progressEntity = (TotalPlanEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, TotalPlanEntity.class));
            progressEntity.setId(masterPkId);
            progressEntity.setChangeVersion(1);
            progressEntity.setChangeStatus(PlanConstant.CHANGE_NO);
            this.progressMapper.insert((Object)progressEntity);
            List progressDetailList = saveOrUpdateVO.getTasks();
            if (progressDetailList.size() > 0) {
                HashMap<String, Long> pkMap = new HashMap<String, Long>();
                ArrayList saveVOList = new ArrayList();
                TreeHelper2.tree2List(pkMap, saveVOList, progressDetailList, saveOrUpdateVO.getImportFlag());
                for (TotalPlanDetailVO progressDetailVo : saveVOList) {
                    TotalPlanDetailEntity progressDetailEntity = TotalPlanDetailEntity.convertVoToEntity(progressDetailVo);
                    progressDetailEntity.setProgressId(masterPkId);
                    this.progressDetailMapper.insert((Object)progressDetailEntity);
                }
            } else {
                throw new BusinessException("\u8ba1\u5212\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(saveOrUpdateVO.getBillState()) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(saveOrUpdateVO.getBillState())) {
            this.execPlanService.updateExecPlan(saveOrUpdateVO.getId(), PlanConstant.TOTAL_PLAN);
        }
        return CommonResponse.success((Object)this.queryDetail(progressEntity.getId()));
    }

    @Override
    public TotalPlanVO queryDetail(Long id) {
        TotalPlanEntity progressEntity = (TotalPlanEntity)((Object)((TotalPlanMapper)this.baseMapper).selectById(id));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"progress_id", (Object)id);
        queryWrapper.orderByAsc((Object)"tid");
        List progressDetailList = this.detailService.list((Wrapper)queryWrapper);
        TotalPlanVO progressVo = (TotalPlanVO)BeanMapper.map((Object)((Object)progressEntity), TotalPlanVO.class);
        if (progressDetailList != null && progressDetailList.size() > 0) {
            ArrayList<TotalPlanDetailVO> progressDetailVoList = new ArrayList<TotalPlanDetailVO>();
            for (TotalPlanDetailEntity progressDetailEntity : progressDetailList) {
                progressDetailVoList.add(TotalPlanDetailEntity.convertEntityToVo(progressDetailEntity));
            }
            progressVo.setProgressDetailList(TreeHelper2.list2Tree(progressDetailVoList));
        }
        return progressVo;
    }

    @Override
    public CommonResponse<HashMap> getxml(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile file = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            file = (MultipartFile)entity.getValue();
            String originalFileName = file.getOriginalFilename();
            String extName = null;
            extName = FileUtils.getFileExt((String)(originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_")), (Boolean)false);
            if ("xml".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        HashMap read = PlusUtil.read(file, PlanCloumCons.TOTAL_PLAN_CLOUM);
        Map<String, Map> filed = PlusUtil.getFieldMap((ArrayList)read.get("ExtendedAttributes"), PlanCloumCons.CUSTOMIZE_CLOMN_MAP);
        return CommonResponse.success((String)"\u89e3\u6790\u6570\u636e\u6210\u529f\uff01", (Object)PlusUtil.readMain(read, filed));
    }

    @Override
    public Map getDetail(Long id) {
        TotalPlanVO totalPlanVO = this.queryDetail(id);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DefaultStartTime", null);
        map.put("CreationDate", null);
        map.put("DaysPerMonth", null);
        List detailList = totalPlanVO.getProgressDetailList();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            HashMap<String, Long> pkMap = new HashMap<String, Long>();
            ArrayList saveVOList = new ArrayList();
            TreeHelper2.tree2List(pkMap, saveVOList, detailList);
            String jsonString = "";
            try {
                jsonString = new ObjectMapper().writeValueAsString(saveVOList);
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
            List list = JSONObject.parseArray((String)jsonString, Map.class);
            for (Map m : list) {
                if (m.get("PredecessorLink") == null) continue;
                List link = JSONObject.parseArray((String)JSONObject.toJSONString(m.get("PredecessorLink")), Map.class);
                m.put("PredecessorLink", link);
            }
            this.key2ValueList(list);
            map.put("Tasks", TreeHelper2.listMap2Tree(list));
        } else {
            map.put("Tasks", null);
        }
        map.put("MinutesPerWeek", null);
        String calendars = totalPlanVO.getCalendars();
        if (StringUtils.isNotBlank((CharSequence)calendars)) {
            map.put("Calendars", PlusUtil.dealCalendars(calendars));
        } else {
            map.put("Calendars", null);
        }
        map.put("WeekStartDay", null);
        map.put("DefaultFinishTime", null);
        map.put("FinishDate", totalPlanVO.getPlanEndDate());
        map.put("Name", totalPlanVO.getProjectName());
        map.put("StartDate", totalPlanVO.getPlanBeginDate());
        map.put("CalendarUID", totalPlanVO.getCalendarUid());
        map.put("UID", totalPlanVO.getId());
        map.put("ExtendedAttributes", null);
        map.put("MinutesPerDay", null);
        map.put("Author", null);
        map.put("Resources", null);
        return map;
    }

    @Override
    public void exportxml(HttpServletResponse response, XmlVO vo) {
        Map dataProject = this.getDetail(vo.getId());
        Export.exportExtendedAttributes((HashMap)dataProject);
        PlusUtil.write(response, vo.getFileName(), dataProject, PlanCloumCons.TOTAL_PLAN_CLOUM);
    }

    private List<Map> key2ValueList(List<Map> list) {
        for (Map map : list) {
            this.key2Value(map, "taskLine", PlanConstant.TASK_LINE);
            this.key2Value(map, "nodeLevel", PlanConstant.NODE_LEVEL);
            this.key2Value(map, "unit", PlanConstant.UNIT);
            this.key2Value(map, "type", PlanConstant.RESOURCE_TYPE);
            this.key2Value(map, "typeUnit", PlanConstant.RESOURCE_UNIT);
        }
        return list;
    }

    private Map key2Value(Map map, String filed, Map<Integer, String> planMap) {
        if (map.get(filed) != null) {
            map.put(filed, planMap.get(Integer.parseInt(map.get(filed).toString())));
        }
        return map;
    }

    @Override
    public TotalPlanVO getTotalPlanByProjectId(Long projectId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TotalPlanEntity::getProjectId, (Object)projectId);
        TotalPlanEntity planEntity = (TotalPlanEntity)((Object)super.getOne((Wrapper)queryWrapper));
        TotalPlanVO totalPlanVO = this.queryDetail(planEntity.getId());
        return totalPlanVO;
    }

    @Override
    public List<TotalPlanEntity> getNoTotalPlan() {
        return this.progressMapper.getNoTotalPlan();
    }

    @Override
    public void sendMsgToInstallPerson(TotalPlanEntity totalPlanEntity) {
        this.logger.info("\u8d1f\u8d23\u4eba\u201d\u63a8\u9001\u7cfb\u7edf\u6d88\u606f\uff0cOA\u6d88\u606f\uff08\u9489\u9489\u6d88\u606f\uff09");
        String msg = this.sendMsg(totalPlanEntity, "\u8d1f\u8d23\u4eba\u201d\u63a8\u9001\u7cfb\u7edf\u6d88\u606f\uff0cOA\u6d88\u606f\uff08\u9489\u9489\u6d88\u606f\uff09", totalPlanEntity.getProjectName() + "\u9879\u76ee,\u9879\u76ee\u603b\u8ba1\u5212\u5df2\u5b8c\u6210\uff0c\u8bf7\u8fdb\u884c\u8ba1\u5212\u5206\u89e3");
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            this.logger.error("\u8d1f\u8d23\u4eba\u201d\u63a8\u9001\u7cfb\u7edf\u6d88\u606f\uff0cOA\u6d88\u606f\uff08\u9489\u9489\u6d88\u606f\uff09 \u5f02\u5e38\uff1a" + msg);
        }
        this.logger.info("\u8d1f\u8d23\u4eba\u201d\u63a8\u9001\u7cfb\u7edf\u6d88\u606f\uff0cOA\u6d88\u606f\uff08\u9489\u9489\u6d88\u606f\uff09\u7ed3\u675f\uff01");
    }

    private String sendMsg(TotalPlanEntity entity, String subject, String content) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ProgressDetailEntity::getProgressId, (Object)entity.getId());
        List list = this.detailService.list((Wrapper)wrapper);
        ArrayList<String> idList = new ArrayList<String>();
        for (TotalPlanDetailEntity details : list) {
            String id = details.getEmployeeId();
            idList.add(id);
        }
        Object[] peopleIds = (String[])idList.stream().distinct().toArray(String[]::new);
        this.logger.info("\u6d88\u606f\u63a5\u6536\u4eba: {}", (Object)StringUtils.join((Object[])peopleIds, (String)","));
        PushMsgParameter msgParameter = new PushMsgParameter();
        msgParameter.setReceivers((String[])peopleIds);
        msgParameter.setContent(content);
        msgParameter.setSubject(content);
        msgParameter.setMsgType("bpmpass");
        msgParameter.setTenantId(entity.getTenantId().toString());
        msgParameter.setSaveFlag(true);
        msgParameter.setSendUserId(InvocationInfoProxy.getUserid());
        msgParameter.setChannel(new String[]{"sys", "zhiyuanoa"});
        msgParameter.setPcUrl(PC_URL + entity.getId());
        msgParameter.setMobileUrl(MOBILE_URL + entity.getId());
        CommonResponse msgSendResp = this.pushMessageApi.pushMessage(msgParameter);
        if (!msgSendResp.isSuccess()) {
            return msgSendResp.getMsg();
        }
        return null;
    }
}

