/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.progress.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.jlprogress.progress.utils.DetailListUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class WarnFeignUtil {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IProjectArchiveApi projectApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private DetailListUtil detailListUtil;

    public List<DefdocDetailVO> getDefDocListById(Long id) {
        CommonResponse resp = this.defdocApi.getDefDocByDefId(id);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        return (List)resp.getData();
    }

    public DefdocDetailVO getDefDocDetail(List<DefdocDetailVO> defList, Long id) {
        if (CollectionUtils.isEmpty(defList) || id == null) {
            return new DefdocDetailVO();
        }
        return defList.stream().filter(x -> id.equals(x.getId())).findAny().orElse(new DefdocDetailVO());
    }

    public JSONArray queryList(String url, QueryParam queryParam) {
        JSONObject json = new JSONObject();
        try {
            String resp = HttpTookit.postByJson((String)(this.BaseHost + url), (String)JSONObject.toJSONString((Object)queryParam));
            json = JSONObject.parseObject((String)resp);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        if (json.getInteger("code") != 0) {
            throw new BusinessException(json.getString("msg"));
        }
        JSONObject data = json.getJSONObject("data");
        if (data == null) {
            return new JSONArray();
        }
        return data.getJSONArray("records");
    }
}

