/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.quality.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlprogress.quality.service.IPurchaseFeedbackService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"unqualifiedReport"})
public class UnqualifiedReportController {
    @Autowired
    private IPurchaseFeedbackService service;

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<Object> RecordVOList = new ArrayList();
        if (param.getParams().containsKey("month")) {
            String month = (String)((Parameter)param.getParams().remove("month")).getValue();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            LocalDate currentMonth = LocalDate.parse(month + "-01", formatter);
            LocalDate startDate = currentMonth.minusMonths(1L).withDayOfMonth(26);
            LocalDate endDate = currentMonth.withDayOfMonth(25);
            DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            param.getParams().put("feedbackDate", new Parameter("between", (Object)(startDate.format(outputFormatter) + "," + endDate.format(outputFormatter))));
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            RecordVOList = this.service.queryUnqualifiedReport(page, wrapper);
        }
        JSONObject res = new JSONObject();
        res.put("records", RecordVOList);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelFinancec(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billTypeName");
        List<Object> list = new ArrayList();
        if (param.getParams().containsKey("month")) {
            String month = (String)((Parameter)param.getParams().remove("month")).getValue();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            LocalDate currentMonth = LocalDate.parse(month + "-01", formatter);
            LocalDate startDate = currentMonth.minusMonths(1L).withDayOfMonth(26);
            LocalDate endDate = currentMonth.withDayOfMonth(25);
            DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            param.getParams().put("feedbackDate", new Parameter("between", (Object)(startDate.format(outputFormatter) + "," + endDate.format(outputFormatter))));
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            list = this.service.queryUnqualifiedReport(wrapper);
        }
        list.forEach(unqualifiedReport -> {
            switch (unqualifiedReport.getTechnicalManager()) {
                case 0: {
                    unqualifiedReport.setTechnicalManagerString("\u8ba9\u6b65\u63a5\u6536");
                }
                case 1: {
                    unqualifiedReport.setTechnicalManagerString("\u8fd4\u5de5");
                }
                case 2: {
                    unqualifiedReport.setTechnicalManagerString("\u7ef4\u4fee");
                }
                case 3: {
                    unqualifiedReport.setTechnicalManagerString("\u62a5\u5e9f");
                }
                case 4: {
                    unqualifiedReport.setTechnicalManagerString("\u9000\u8d27");
                }
            }
        });
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("UnqualifiedReport-export.xlsx", beans, response);
    }
}

