package com.ejianc.business.jlprogress.factory.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 制造厂-制造厂设备明细表
 *
 * @author generator
 *
 */
 @TableName("ejc_factory_equipment_detail")
public class FactEquipmentDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="equipment_id")
    private Long equipmentId; // 主表ID
    @TableField(value="code")
    private String code; // 设备编号
    @TableField(value="name")
    private String name; // 设备名称
    @TableField(value="spec")
    private String spec; // 设备型号
    @TableField(value="factory")
    private String factory; // 生产厂家及国别
    @TableField(value="out_code")
    private String outCode; // 出场编号
    @TableField(value="out_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date outDate; // 出场日期
    @TableField(value="buy_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date buyDate; // 购置日期
    @TableField(value="first_mny")
    private BigDecimal firstMny; // 设备原值(万)
    @TableField(value="equip_state")
    private String equipState; // 设备状态
    @TableField(value="precision_levl")
    private String precisionLevl; // 精度等级
    @TableField(value="category")
    private String category; // 设备类别
    @TableField(value="power")
    private BigDecimal power; // 功率(kw)
    @TableField(value="memo")
    private String memo; // 备注




    public Long getEquipmentId() {
        return equipmentId;
    }

    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getFactory() {
        return factory;
    }

    public void setFactory(String factory) {
        this.factory = factory;
    }
    public String getOutCode() {
        return outCode;
    }

    public void setOutCode(String outCode) {
        this.outCode = outCode;
    }
    public Date getOutDate() {
        return outDate;
    }

    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }
    public Date getBuyDate() {
        return buyDate;
    }

    public void setBuyDate(Date buyDate) {
        this.buyDate = buyDate;
    }
    public BigDecimal getFirstMny() {
        return firstMny;
    }

    public void setFirstMny(BigDecimal firstMny) {
        this.firstMny = firstMny;
    }
    public String getEquipState() {
        return equipState;
    }

    public void setEquipState(String equipState) {
        this.equipState = equipState;
    }
    public String getPrecisionLevl() {
        return precisionLevl;
    }

    public void setPrecisionLevl(String precisionLevl) {
        this.precisionLevl = precisionLevl;
    }
    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }
    public BigDecimal getPower() {
        return power;
    }

    public void setPower(BigDecimal power) {
        this.power = power;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

}
