package com.ejianc.business.jlprogress.factory.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 制造厂-金点子汇总明细表
 *
 * @author generator
 *
 */
public class FactGoldDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long goldId; // 主表ID
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM",
            timezone = "GMT+8"
    )
    private Date detailMonth; // 填报月份
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date billDate; // 日期
    private String factory; // 分厂
    private String name; // 提案名称
    private String beforeChange; // 改善前
    private String afterChange; // 改善后
    private String category; // 类别
    private BigDecimal costMny; // 节约成本金额（元）
    private String signer; // 提案人
    private BigDecimal rewardMny; // 奖励金额（元）
    private String memo; // 备注
    private Long projectId; // 项目ID
    private String projectCode; // 项目code
    private String projectName; // 项目名称
    private Long sourceId; // 来源ID
    private String errorMsg; // 导入错误信息
    private String reportMonth;

    public String getReportMonth() {
        return reportMonth;
    }

    public void setReportMonth(String reportMonth) {
        this.reportMonth = reportMonth;
    }
    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public Long getGoldId() {
        return goldId;
    }

    public void setGoldId(Long goldId) {
        this.goldId = goldId;
    }

    public Date getDetailMonth() {
        return detailMonth;
    }

    public void setDetailMonth(Date detailMonth) {
        this.detailMonth = detailMonth;
    }

    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    public String getFactory() {
        return factory;
    }

    public void setFactory(String factory) {
        this.factory = factory;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getBeforeChange() {
        return beforeChange;
    }

    public void setBeforeChange(String beforeChange) {
        this.beforeChange = beforeChange;
    }
    public String getAfterChange() {
        return afterChange;
    }

    public void setAfterChange(String afterChange) {
        this.afterChange = afterChange;
    }
    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }
    public BigDecimal getCostMny() {
        return costMny;
    }

    public void setCostMny(BigDecimal costMny) {
        this.costMny = costMny;
    }
    public String getSigner() {
        return signer;
    }

    public void setSigner(String signer) {
        this.signer = signer;
    }
    public BigDecimal getRewardMny() {
        return rewardMny;
    }

    public void setRewardMny(BigDecimal rewardMny) {
        this.rewardMny = rewardMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

}
