package com.ejianc.business.jlprogress.labor.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlprogress.labor.vo.LaborSubDetailsVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlprogress.labor.mapper.LaborSubMapper;
import com.ejianc.business.jlprogress.labor.bean.LaborSubEntity;
import com.ejianc.business.jlprogress.labor.service.ILaborSubService;

import java.math.BigDecimal;
import java.util.List;

/**
 * 浦江现场-劳务分包用款计划表
 *
 * @author generator
 */
@Service("laborSubService")
public class LaborSubServiceImpl extends BaseServiceImpl<LaborSubMapper, LaborSubEntity> implements ILaborSubService {

    @Autowired
    private LaborSubMapper mapper;

    @Override
    public LaborSubDetailsVO selectTotalRefund(String id) {
        //查询合同金额
        BigDecimal contractMny = mapper.selectTotalContractMny(id);

        //查询累计收款
        BigDecimal totalMny = mapper.selectTotalRefund(id);
        LaborSubDetailsVO detailsVO = new LaborSubDetailsVO();
  /*      if (contractMny != null || contractMny.compareTo(BigDecimal.ZERO) != 0) {
            detailsVO.setContractMny(contractMny);
        }
        if (totalMny != null || totalMny.compareTo(BigDecimal.ZERO) != 0) {
            detailsVO.setContractTotalRefund(totalMny);
        }*/
        detailsVO.setContractMny(contractMny);
        detailsVO.setContractTotalRefund(totalMny);
        return detailsVO;
    }

    @Override
    public LaborSubDetailsVO selectSub(String id) {

        LaborSubDetailsVO detailsVO = new LaborSubDetailsVO();
        //查询 分包合同金额
        BigDecimal contractMny = mapper.selectContractMny(id);
        //分包累计回款
        BigDecimal totalMny = mapper.selectSubRefund(id);

    /*    if (contractMny != null || contractMny.compareTo(BigDecimal.ZERO) != 0) {
            detailsVO.setSubMny(contractMny);
        }
        if (totalMny != null || totalMny.compareTo(BigDecimal.ZERO) != 0) {
            detailsVO.setSubTotalPay(totalMny);
        }*/
        detailsVO.setSubMny(contractMny);
        detailsVO.setSubTotalPay(totalMny);
        return detailsVO;
    }

    @Override
    public List<LaborSubDetailsVO> laborSubReport(Page pages, QueryWrapper wrapper) {
        return baseMapper.laborSubReport(pages, wrapper);
    }
}
