package com.ejianc.business.jlprogress.labor.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.jlprogress.labor.enums.TeamSourceFlagEnum;
import com.ejianc.business.jlprogress.labor.service.IWorkRecordService;
import com.ejianc.business.jlprogress.labor.service.IWorkerEnterService;
import com.ejianc.business.jlprogress.labor.vo.ProjectTeamVO;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlprogress.labor.mapper.ProjectTeamMapper;
import com.ejianc.business.jlprogress.labor.bean.ProjectTeamEntity;
import com.ejianc.business.jlprogress.labor.service.IProjectTeamService;

import java.util.ArrayList;
import java.util.List;

/**
 * 劳务实名制-项目班组
 * 
 * @author generator
 * 
 */
@Service("projectTeamService")
public class ProjectTeamServiceImpl extends BaseServiceImpl<ProjectTeamMapper, ProjectTeamEntity> implements IProjectTeamService{
    private static final String BILL_CODE = "LABOR_PROJECT_TEAM";//此处需要根据实际修改
    @Autowired
    private IProjectArchiveApi projectApi;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IWorkRecordService recordService;
    @Autowired
    private IWorkerEnterService enterService;

    @Override
    public ProjectTeamVO insertOrUpdate(ProjectTeamVO saveOrUpdateVO) {
        ProjectTeamEntity entity = BeanMapper.map(saveOrUpdateVO, ProjectTeamEntity.class);
        boolean updateFlag = false;
        if (entity.getId() == null) {
            entity.setId(IdWorker.getId());
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
        } else {
            ProjectTeamEntity entity1 = super.selectById(entity.getId());
            if (!entity.getName().equals(entity1.getName())) {
                updateFlag = true;
            }
        }
        if (entity.getSourceFlag() == null) {
            entity.setSourceFlag(0);
        }
        //设置是否是末级
        LambdaQueryWrapper<ProjectTeamEntity> wrapperByParentId = new LambdaQueryWrapper<>();
        wrapperByParentId.eq(entity.getId() != null, ProjectTeamEntity::getParentId, entity.getId());
        wrapperByParentId.eq(ProjectTeamEntity::getTenantId, InvocationInfoProxy.getTenantid());
        int count = super.count(wrapperByParentId);
        if (count > 0) {
            entity.setIsLeaf(false);
        } else {
            entity.setIsLeaf(true);
        }
        entity.setInnerCode(entity.getParentId() + "|" + entity.getId());
        super.saveOrUpdate(entity, false);
        Long parentId = entity.getParentId();
        if (parentId != null) {
            LambdaUpdateWrapper<ProjectTeamEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.set(ProjectTeamEntity::getIsLeaf, false);
            wrapper.eq(ProjectTeamEntity::getId, parentId);
            super.update(wrapper);
        }
        if (updateFlag) {
            updateWorkerTeamNameByTeamIdOrWorkerId(entity.getId(), null);
        }
        ProjectTeamVO vo = BeanMapper.map(entity, ProjectTeamVO.class);
        return vo;
    }


    /**
     * 引入班组逻辑
     * 引入班组时，查询公司班组树。根节点不可选中，其他节点都可选。已经引入的班组不可再次引入；
     * 当第一次只引入子级，下次引入父级时，需要按公司班组构造树形；
     *
     * @param voList
     * @return
     */
    @Override
    public List<String> insertBatch(List<ProjectTeamVO> voList) {
        List<String> errorMsg = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(voList)) {
            Long projectId = voList.get(0).getProjectId();
            if (null != projectId) {
                CommonResponse<ProjectArchiveVO> projectDetail = projectApi.getProjectArchiveById(projectId);
                if (!projectDetail.isSuccess()) {
                    throw new BusinessException("网络异常，获取项目信息， 请稍后再试");
                }
                ProjectArchiveVO project = projectDetail.getData();
                //获取 项目根班组
                QueryWrapper<ProjectTeamEntity> queryProject = new QueryWrapper<>();
                queryProject.eq("project_id", project.getId());
                queryProject.isNull("parent_id");
                ProjectTeamEntity projectTeamEntity = super.getOne(queryProject);
                List<ProjectTeamEntity> saveEntity = new ArrayList<>();
                for (ProjectTeamVO vo : voList) {
                    //根据班组去查询是否存在
                    LambdaQueryWrapper<ProjectTeamEntity> lambda = new LambdaQueryWrapper<>();
                    lambda.eq(ProjectTeamEntity::getSourceOrgTeamId, vo.getSourceOrgTeamId());
                    lambda.eq(ProjectTeamEntity::getTenantId, InvocationInfoProxy.getTenantid());
                    lambda.eq(ProjectTeamEntity::getSourceFlag, TeamSourceFlagEnum.公司.getStatus());
                    lambda.eq(ProjectTeamEntity::getProjectId, project.getId());
                    int count = super.count(lambda);
                    if (count > 0) {
                        //提示当前不能插入已存在
                        errorMsg.add("当前" + vo.getName() + "已存在");
                    } else {
                        ProjectTeamEntity entity = BeanMapper.map(vo, ProjectTeamEntity.class);
                        BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), vo);
                        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                        if (!billCode.isSuccess()) {
                            errorMsg.add("网络异常， 编码生成失败， 请稍后再试");
                            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                        }
                        entity.setId(IdWorker.getId());
                        entity.setProjectId(project.getId());
                        entity.setProjectName(project.getName());
                        entity.setOrgId(project.getProjectDepartmentId());
                        entity.setParentOrgId(project.getOrgId());
                        entity.setParentOrgName(project.getOrgName());
                        entity.setCode(billCode.getData());
                        //设置父级 根据当前单据 的sourceParentId 查询是否存在父班组
                        QueryWrapper<ProjectTeamEntity> queryWrapper = new QueryWrapper<>();
                        queryWrapper.eq("source_org_team_id", entity.getSourceParentId());
                        queryWrapper.eq("project_id", project.getId());

                        ProjectTeamEntity one = super.getOne(queryWrapper);
                        if (one != null) {
                            entity.setParentId(one.getId());
                            one.setIsLeaf(false);
                            super.saveOrUpdate(one);
                            entity.setInnerCode(one.getInnerCode() + "|" + entity.getId());
                        } else {
                            // 绑定到根节点
                            entity.setParentId(projectTeamEntity.getId());
                            entity.setInnerCode(projectTeamEntity.getInnerCode() + "|" + entity.getId());
                        }
                        //判断是否存在子级
                        QueryWrapper<ProjectTeamEntity> childQuery = new QueryWrapper<>();
                        childQuery.eq("source_parent_id", entity.getSourceOrgTeamId());
                        childQuery.eq("project_id", project.getId());
                        List<ProjectTeamEntity> list = super.list(childQuery);
                        if (CollectionUtils.isNotEmpty(list)) {
                            for (ProjectTeamEntity upEntity : list) {
                                upEntity.setParentId(entity.getId());
                                upEntity.setInnerCode(entity.getInnerCode() + "|" + upEntity.getId());
                            }
                            super.saveOrUpdateBatch(list);
                            entity.setIsLeaf(false);
                        } else {
                            entity.setIsLeaf(true);
                        }
                        entity.setTenantId(InvocationInfoProxy.getTenantid());
                        super.saveOrUpdate(entity);
                        saveEntity.add(entity);

                    }
                }
            } else {
                errorMsg.add("当前项目为空");

            }
        } else {
            errorMsg.add("当前为空");

        }
        return errorMsg;

    }

    /**
     * 修改班组名称
     */
    Integer updateWorkerTeamNameByTeamIdOrWorkerId(Long teamId, Long workerId) {
        Integer integer = recordService.updateWorkerTeamNameByTeamIdOrWorkerId(teamId, null);
        Integer integer1 = enterService.updateWorkerTeamNameByTeamIdOrWorkerId(teamId, null);
        return integer + integer1;
    }
}
