package com.ejianc.business.jlprogress.order.controller;

import java.io.Serializable;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.ejianc.business.jlprogress.order.bean.CheckEntity;
import com.ejianc.business.jlprogress.order.bean.ProductOutEntity;
import com.ejianc.business.jlprogress.order.service.ICheckService;
import com.ejianc.business.jlprogress.order.service.IProductOutService;
import com.ejianc.business.jlprogress.order.service.impl.CheckBpmServiceImpl;
import com.ejianc.business.jlprogress.order.vo.DeliveryDetailVO;
import com.ejianc.business.jlprogress.order.vo.ProductOutVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jlprogress.order.bean.DeliveryEntity;
import com.ejianc.business.jlprogress.order.service.IDeliveryService;
import com.ejianc.business.jlprogress.order.vo.DeliveryVO;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 订单及运单-发货通知单-主表
 *
 * @author generator
 */
@Controller
@RequestMapping("delivery")
public class DeliveryController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "FHTZ_CODE";// 此处需要根据实际修改

    @Autowired
    private IDeliveryService service;

    @Autowired
    private ICheckService checkService;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private CheckBpmServiceImpl check;

    @Autowired
    private IShareMaterialApi iShareMaterialApi;

    @Autowired
    private IProductOutService productOutService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DeliveryVO> saveOrUpdate(@RequestBody DeliveryVO saveOrUpdateVO) {
        // 增加限制条件“一个合同只能有一个未生效的单据”
        DeliveryEntity deliveryEntity = service.selectNotActivated(saveOrUpdateVO.getId(), saveOrUpdateVO.getContractId());
        if (deliveryEntity != null) {
            throw new BusinessException("一个合同只能有一个未生效的单据");
        }

        DeliveryEntity entity = BeanMapper.map(saveOrUpdateVO, DeliveryEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());// 此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        DeliveryVO vo = BeanMapper.map(entity, DeliveryVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DeliveryVO> queryDetail(Long id) {
        DeliveryEntity entity = service.selectById(id);
        DeliveryVO vo = BeanMapper.map(entity, DeliveryVO.class);
        List<Integer> list = new ArrayList<>();
        list.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        list.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        // 复制功能查询   同一合同已生效的单子的数量
        int sum = service.count(new LambdaQueryWrapper<DeliveryEntity>()
                .eq(null != entity.getContractId(), DeliveryEntity::getContractId, entity.getContractId())
                .in(DeliveryEntity::getBillState, list)

        );
        vo.setDeliverySum(sum);

        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DeliveryVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (DeliveryVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(DeliveryVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DeliveryVO>> queryList(@RequestBody QueryParam param) {
        setFuzzyFields(param);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        // IPage<DeliveryEntity> page = service.queryPage(param, false);
        IPage<DeliveryEntity> page = service.queryPage(param, false);
        // 查询check list
        if (null != page.getRecords() && page.getRecords().size() != 0) {
            List<Long> ids = page.getRecords().stream().map(DeliveryEntity::getId).collect(Collectors.toList());
            List<CheckEntity> checkList = checkService.list(new QueryWrapper<CheckEntity>().in("delivery_id", ids));
            Map<Long, Integer> checkNums = checkList.stream().collect(Collectors.toMap(
                    CheckEntity::getDeliveryId, // 获取key（id）
                    e -> 1, // 获取value（整个Entity对象）
                    (e1, e2) -> ++e1
            ));
            page.getRecords().forEach((detail) -> {
                Integer checkNum = checkNums.get(detail.getId());
                detail.setCheckNum(checkNum == null ? 0 : checkNum);
            });
        }

        IPage<DeliveryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DeliveryVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryReportList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DeliveryVO>> queryReportList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("customName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //先找父级  根据分级 分页
        Page<DeliveryVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);

        List<DeliveryVO> resList = service.queryReportPage(page, wrapper);

        IPage<DeliveryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(resList);

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        setFuzzyFields(param);
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
//        List<DeliveryEntity> list = service.queryList(param);
        List<DeliveryEntity> list = service.queryListWithCheckCount(param);
        List<DeliveryVO> voList = BeanMapper.mapList(list, DeliveryVO.class);

        for (DeliveryVO deliveryVO : voList) {
            if (deliveryVO.getBillState() == 0) {
                deliveryVO.setBillStateName("自由态");
            }
            if (deliveryVO.getBillState() == 2 || deliveryVO.getBillState() == 5) {
                deliveryVO.setBillStateName("审批中");
            }
            if (deliveryVO.getBillState() == 1) {
                deliveryVO.setBillStateName("已提交");
            }
            if (deliveryVO.getBillState() == 3) {
                deliveryVO.setBillStateName("审批通过");
            }
            if (deliveryVO.getBillState() == 4) {
                deliveryVO.setBillStateName("审批驳回");
            }
        }
        // todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("Delivery-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelReportExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelReportExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("customName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //先找父级  根据分级 分页
        QueryWrapper wrapper = changeToQueryWrapper(param);

        List<DeliveryVO> resList = service.queryReportList(wrapper);
        //todo:字段翻译等等
        for (DeliveryVO resData : resList) {
            switch (resData.getReceiptStatus()) {
                case 0:
                    resData.setReceiptStatusName("无");
                    break;
                case 1:
                    resData.setReceiptStatusName("有");
                    break;
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", resList);
        ExcelExport.getInstance().export("DeliveryReport-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refDeliveryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DeliveryVO>> refDeliveryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                             String condition,
                                                             String searchObject,
                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("clientName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        ArrayList<Integer> list = new ArrayList();
        list.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        list.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        param.getParams().put("billState", new Parameter(QueryParam.IN, list));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            Long contractId = _con.getLong("contractId");
            param.getParams().put("contractId", new Parameter("eq", contractId));
        }

        IPage<DeliveryEntity> page = service.queryPage(param, false);
        IPage<DeliveryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DeliveryVO.class));
        // List<Long> idsList = pageData.getRecords().stream().map(DeliveryVO::getId).collect(Collectors.toList());
        //查询 未删除 并且 状态 为已提交或者审批通过的 产品出库单
        LambdaQueryWrapper<ProductOutEntity> wrapper = new LambdaQueryWrapper<>();
        List<Integer> billStateList = new ArrayList<>(Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()));
//        wrapper.eq(ProductOutEntity::getDr, 0).in(ProductOutEntity::getBillState, billStateList);

        List<Long> ids = pageData.getRecords().stream().map(DeliveryVO::getId).collect(Collectors.toList());
        wrapper.eq(ProductOutEntity::getDr, 0).in(ProductOutEntity::getBillState, billStateList).in(ProductOutEntity::getDeliveryId, ids);
        Map<Long, ProductOutEntity> map = productOutService.list(wrapper).stream().collect(Collectors.toMap(ProductOutEntity::getDeliveryId, x -> x, (existing, replacement) -> existing));
        for (DeliveryVO vo : pageData.getRecords()) {
            if (map.containsKey(vo.getId())) {
                vo.setIsOut("已发货");
            }
        }

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 统计  合同累计发货次数
     *
     * @param contractId 合同id
     * @return
     */
    @GetMapping("/selectDeliveryCount")
    @ResponseBody
    public CommonResponse selectMoney(Long Id, Long contractId) {
        System.out.println(contractId);
        System.out.println(Id);
        // Map<String, BigDecimal> map = service.selectMoneyAll(id);
        Integer count = service.selectCount(Id, contractId);
        return CommonResponse.success("成功", count);
    }

    private static void setFuzzyFields(QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /**
         * 模糊搜索：单据编号、合同名称、项目名称、区域名称、客户名称、项目类型、产品类型、经办人、业务负责人、接收人
         */
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("clientName");
        fuzzyFields.add("projectTypeName");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("managerName");
        fuzzyFields.add("receiverName");
    }


    /**
     * 通过合同id获取对应发货记录
     *
     * @param contractId
     * @return
     */
    @RequestMapping(value = "/queryDeliveryRecordByContractId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryDeliveryRecordByContractId(@RequestParam Long contractId) {
        JSONObject jsonObject = new JSONObject();
        List<DeliveryEntity> list = service.list(new LambdaQueryWrapper<DeliveryEntity>().in(DeliveryEntity::getBillState, Arrays.asList(1, 3)).eq(DeliveryEntity::getContractId, contractId));
        if (CollectionUtils.isNotEmpty(list) && list.size() > 0) {
            List<DeliveryVO> deliveryVOList = BeanMapper.mapList(list, DeliveryVO.class);
            // 查询check list
            List<Long> ids = deliveryVOList.stream().map(DeliveryVO::getId).collect(Collectors.toList());
            List<CheckEntity> checkList = checkService.list(new QueryWrapper<CheckEntity>().in("delivery_id", ids));
            Map<Long, Integer> checkNums = checkList.stream().collect(Collectors.toMap(
                    CheckEntity::getDeliveryId, // 获取key（id）
                    e -> 1, // 获取value（整个Entity对象）
                    (e1, e2) -> ++e1
            ));
            deliveryVOList.forEach((detail) -> {
                Integer checkNum = checkNums.get(detail.getId());
                detail.setCheckNum(checkNum == null ? 0 : checkNum);
            });
            jsonObject.put("deliveryVOList", deliveryVOList);
        }
        return CommonResponse.success("查询列表数据成功！", jsonObject);
    }


    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadInfo")
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "DeliveryDetail-import.xlsx", "发货通知单-物料明细模板");
    }


    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<DeliveryDetailVO> successList = new ArrayList<>();
        List<DeliveryDetailVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                //获取物资档案数据
                List<String> materialCodeList = new ArrayList<>();
                Map<String, MaterialVO> map = new HashMap<>();
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    materialCodeList.add(datas.get(0));//取材料编码  用来校验
                }
                CommonResponse<List<MaterialVO>> materialRes = iShareMaterialApi.queryMaterialListByCodes(materialCodeList);
                if (!materialRes.isSuccess()) {
                    return CommonResponse.error(materialRes.getMsg());
                }
                map = materialRes.getData().stream().collect(Collectors.toMap(p -> p.getCode(), Function.identity()));


                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    DeliveryDetailVO detailVO = new DeliveryDetailVO();
                    detailVO.setId(com.ejianc.support.idworker.util.IdWorker.getId());
                    String materialCode = StrUtil.trim(datas.get(0));
                    detailVO.setMaterialCode(materialCode);
                    //材料code  材料Id赋值
                    try {

                        if (ObjectUtils.isEmpty(map.get(materialCode))) {
                            throw new Exception("没有此材料！1");
                        }

                        detailVO.setMaterialName(map.get(materialCode).getName());
                        detailVO.setSpec(map.get(materialCode).getSpec());
                        detailVO.setModel(map.get(materialCode).getModel());
                        detailVO.setUnit(datas.get(4));


                    } catch (Exception e) {
                        detailVO.setErrorMsg("没有此材料！2");
                        errorList.add(detailVO);
                        continue;
                    }
                    if (ObjectUtils.isEmpty(datas.get(5))) {
                        detailVO.setNum(null);
                    } else {
                        try {
                            detailVO.setNum(BigDecimal.valueOf(Double.parseDouble(datas.get(5))));
                        } catch (Exception e) {
                            detailVO.setErrorMsg("数量格式错误！");
                            errorList.add(detailVO);
                            continue;
                        }
                    }

                    successList.add(detailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }
}
