package com.ejianc.business.jlprogress.order.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.ejianc.business.jlprogress.order.vo.OutStoreDetailVO;
import com.ejianc.business.jlprogress.order.vo.SalesDetailVO;
import com.ejianc.business.jlprogress.order.vo.SalesListVO;
import com.ejianc.business.jlprogress.quality.vo.WorkTimeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import io.swagger.models.auth.In;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jlprogress.order.bean.SalesEntity;
import com.ejianc.business.jlprogress.order.service.ISalesService;
import com.ejianc.business.jlprogress.order.vo.SalesVO;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 订单及运单-销售订单主表
 *
 * @author generator
 */
@Controller
@RequestMapping("sales")
public class SalesController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IShareMaterialApi iShareMaterialApi;

    @Autowired
    private ISalesService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SalesVO> saveOrUpdate(@RequestBody SalesVO saveOrUpdateVO) {
        SalesEntity entity = BeanMapper.map(saveOrUpdateVO, SalesEntity.class);
        String billCode = entity.getBillCode();
        QueryWrapper<SalesEntity> wrapper = new QueryWrapper<SalesEntity>().eq("bill_code", billCode);
        if (entity.getId() != null) {
            wrapper = wrapper.ne("id", entity.getId());
        }
        List<SalesEntity> list = service.list(wrapper);
        if (list != null && list.size() != 0) {
            return CommonResponse.error("订单编码已存在");
        }
        service.saveOrUpdate(entity, false);
        SalesVO vo = BeanMapper.map(entity, SalesVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SalesVO> queryDetail(Long id) {
        SalesEntity entity = service.selectById(id);
        SalesVO vo = BeanMapper.map(entity, SalesVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SalesVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SalesVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SalesVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SalesVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("salesEmployeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<SalesEntity> page = service.queryPage(param, false);
        IPage<SalesVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SalesVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("salesEmployeeName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SalesEntity> list = service.queryList(param);
        List<SalesVO> resDatas = BeanMapper.mapList(list, SalesVO.class);
        for (SalesVO resData : resDatas) {
            switch (resData.getBillState()) {
                case 0:
                    resData.setBillStateName("自由态");
                    break;
                case 1:
                    resData.setBillStateName("已提交");
                    break;
                case 2:
                case 5:
                    resData.setBillStateName("审批中");
                    break;
                case 3:
                    resData.setBillStateName("审批通过");
                    break;
                case 4:
                    resData.setBillStateName("审批驳回");
                    break;
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", resDatas);
        ExcelExport.getInstance().export("Sales-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSalesData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SalesVO>> refSalesData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SalesEntity> page = service.queryPage(param, false);
        IPage<SalesVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SalesVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadInfo")
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "SalesDetail-import.xlsx", "销售订单-物料明细模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<SalesDetailVO> successList = new ArrayList<>();
        List<SalesDetailVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                //获取物资档案数据
                List<String> materialCodeList = new ArrayList<>();
                Map<String, MaterialVO> map = new HashMap<>();
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    materialCodeList.add(datas.get(0));//取材料编码  用来校验
                }
                CommonResponse<List<MaterialVO>> materialRes = iShareMaterialApi.queryMaterialListByCodes(materialCodeList);
                if (!materialRes.isSuccess()) {
                    return CommonResponse.error(materialRes.getMsg());
                }
                map = materialRes.getData().stream().collect(Collectors.toMap(p -> p.getCode(), Function.identity()));


                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    SalesDetailVO detailVO = new SalesDetailVO();
                    detailVO.setId(com.ejianc.support.idworker.util.IdWorker.getId());
                    String materialCode = datas.get(0);
                    detailVO.setMaterialCode(materialCode);
                    //材料code  材料Id赋值
                    try {

                        if (ObjectUtils.isEmpty(map.get(materialCode))) {
                            throw new Exception("没有此材料！");
                        }

                        detailVO.setMaterialId(map.get(materialCode).getId());
                        detailVO.setMaterialName(map.get(materialCode).getName());
                        detailVO.setSpec(map.get(materialCode).getSpec());
                        detailVO.setModel(map.get(materialCode).getModel());
                        detailVO.setUnit(datas.get(4));
                        detailVO.setMaterialTypeId(map.get(materialCode).getCategoryId());
                        detailVO.setMaterialTypeCode(map.get(materialCode).getCategoryCode());
                        detailVO.setMaterialTypeName(map.get(materialCode).getCategoryName());


                    } catch (Exception e) {
                        detailVO.setErrorMsg("没有此材料！");
                        errorList.add(detailVO);
                        continue;
                    }

                    //数量  校验赋值
                    if (datas.get(5) == null || datas.get(5).equals("")) {
                        detailVO.setErrorMsg("数量未填写！");
                        errorList.add(detailVO);
                        continue;
                    }
                    try {
                        detailVO.setMaterialNum(BigDecimal.valueOf(Double.parseDouble(datas.get(5))));
                    } catch (Exception e) {
                        detailVO.setErrorMsg("数量格式错误！");
                        errorList.add(detailVO);
                        continue;
                    }

                    //单价  校验赋值
                    if (datas.get(6) == null || datas.get(6).equals("")) {
                        detailVO.setErrorMsg("单价未填写！");
                        errorList.add(detailVO);
                        continue;
                    }
                    try {
                        BigDecimal materialPrice = BigDecimal.valueOf(Double.parseDouble(datas.get(6)));
                        detailVO.setMaterialPrice(materialPrice);
                    } catch (Exception e) {
                        detailVO.setErrorMsg("单价格式错误！");
                        errorList.add(detailVO);
                        continue;
                    }
                    detailVO.setMaterialSumPrice(detailVO.getMaterialNum().multiply(detailVO.getMaterialPrice()));

                    //给备注值
                    String memo = datas.get(8);
                    detailVO.setMemo(memo);
                    successList.add(detailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    @RequestMapping(value = "/getContractSales", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SalesListVO> getContractSales(Long contractId) {
        return CommonResponse.success(service.getContractSales(contractId));
    }

}

