package com.ejianc.business.jlprogress.quality.service.impl;

import com.ejianc.business.jlprogress.progress.service.IExecPlanDetailService;
import com.ejianc.business.jlprogress.quality.bean.ProcessCheckEntity;
import com.ejianc.business.jlprogress.quality.service.IProcessCheckService;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.share.api.IShareProjectWbsApi;
import com.ejianc.foundation.share.vo.ProjectWbsVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;

@Service("processCheck")
public class ProcessCheckBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;

	@Autowired
	private IProcessCheckService service;
	@Autowired
	private IUserApi userApi;
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IExecPlanDetailService execPlanDetailService;

	@Autowired
	private IShareProjectWbsApi wbsApi;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ProcessCheckEntity entity = service.selectById(billId);
		CommonResponse<UserVO> response = userApi.findUserByUserId(InvocationInfoProxy.getUserid());

		logger.info("单子的创建人的code："+entity.getCreateUserCode());
		logger.info("当前登录人的code："+response.getData().getUserCode());

		if(!entity.getCreateUserCode().equals(response.getData().getUserCode())){
			return CommonResponse.error("当前登录人与制单人不一致，不允许提交");
		}
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ProcessCheckEntity entity = service.selectById(billId);
		// 回写执行计划明细完成量
		BigDecimal num = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(entity.getTotalNum(), entity.getQualifiedScale()), new BigDecimal("100"));
//		BigDecimal num = entity.getQualifiedNum();
		String wbs = String.valueOf(entity.getProcessId());
//		CommonResponse<List<ProjectWbsVO>> resp = wbsApi.queryByProjectId(entity.getProjectId());
//		if(resp.isSuccess() && null != resp.getData()){
//			for(ProjectWbsVO vo : resp.getData()){
//				if(null != vo.getProcessId() && vo.getProcessId().equals(entity.getProcessId())){
//					// 如果项目wbs存在多个相同工序，则判断上级构件是否相同
//					if(StringUtils.isEmpty(wbs) || entity.getWbsId().equals(vo.getParentId())){
//						wbs = String.valueOf(vo.getId());
//					}
//				}
//			}
//		}
		logger.info("回写执行计划明细{}完成量{}", wbs, num.toPlainString());
		execPlanDetailService.writeBackFinishNum(wbs, num, true);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
		if (!resp.isSuccess()) {
			return CommonResponse.error("无法撤回！" + resp.getMsg());
		}
		ProcessCheckEntity entity = service.selectById(billId);
		CommonResponse<UserVO> response = userApi.findUserByUserId(InvocationInfoProxy.getUserid());
		if(!entity.getCreateUserCode().equals(response.getData().getUserCode())){
			return CommonResponse.error("当前登录人与制单人不一致，禁止撤回");
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		ProcessCheckEntity entity = service.selectById(billId);
		// 回写执行计划明细完成量
		BigDecimal num = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(entity.getTotalNum(), entity.getQualifiedScale()), new BigDecimal("100"));
//		BigDecimal num = entity.getQualifiedNum();
		String wbs = String.valueOf(entity.getProcessId());
//		CommonResponse<List<ProjectWbsVO>> resp = wbsApi.queryByProjectId(entity.getProjectId());
//		if(resp.isSuccess() && null != resp.getData()){
//			for(ProjectWbsVO vo : resp.getData()){
//				if(null != vo.getProcessId() && vo.getProcessId().equals(entity.getProcessId())){
//					// 如果项目wbs存在多个相同工序，则判断上级构件是否相同
//					if(StringUtils.isEmpty(wbs) || entity.getWbsId().equals(vo.getParentId())){
//						wbs = String.valueOf(vo.getId());
//					}
//				}
//			}
//		}
		logger.info("回写执行计划明细{}完成量{}", wbs, num.toPlainString());
		execPlanDetailService.writeBackFinishNum(wbs, num, false);
		return CommonResponse.success();
	}

}
