package com.ejianc.business.jlprogress.quality.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.ejianc.business.jlprogress.progress.bean.ExecPlanDetailEntity;
import com.ejianc.business.jlprogress.progress.mapper.TotalPlanMapper;
import com.ejianc.business.jlprogress.quality.vo.ProcessCheckVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamsCheckDsVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlprogress.quality.mapper.ProcessCheckMapper;
import com.ejianc.business.jlprogress.quality.bean.ProcessCheckEntity;
import com.ejianc.business.jlprogress.quality.service.IProcessCheckService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 质量检测-工序检测记录
 *
 * @author generator
 */
@Service("processCheckService")
public class ProcessCheckServiceImpl extends BaseServiceImpl<ProcessCheckMapper, ProcessCheckEntity> implements IProcessCheckService {
    @Autowired
    private TotalPlanMapper totalPlanMapper;
    @Autowired
    private ProcessCheckMapper processCheckMapper;


    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String CODE = "P-LK1j0Q0018";

    @Override
    public BigDecimal getPlanByWbs(Long wbsId) {
        ExecPlanDetailEntity entity = totalPlanMapper.getPlanByWbs(wbsId);
        if (entity == null) {
            return BigDecimal.ZERO;
        }
        return entity.getPlanNum();
    }

    @Override
    public BigDecimal getFinishByWbs(Long wbsId, Long processId) {
        BigDecimal finishByWbs = processCheckMapper.getFinishByWbs(wbsId, processId);
        return ObjectUtils.isEmpty(finishByWbs) ? BigDecimal.ZERO : finishByWbs;
    }

    @Override
    public ParamsCheckVO checkParams(ProcessCheckVO vo) {
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*添加参数控制区域---*/
        paramsCheckVOS.addAll(this.checkParamsByMny(vo));

        /*添加参数控制区域---*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                } else {
                    map.put(warnType, checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if (map.containsKey(s)) {
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if (CollectionUtils.isEmpty(paramsCheckVO.getDataSource())) {
                    paramsCheckVO.setWarnType("none");
                } else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }

    private List<ParamsCheckVO> checkParamsByMny(ProcessCheckVO vo) {

        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();

        BigDecimal planNum = this.getPlanByWbs(vo.getWbsId());

        BigDecimal finishNum = this.getFinishByWbs(vo.getWbsId(), vo.getProcessId());

        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("工序检测校验，检验数+已完成检验数是否超过计划数：" + JSONObject.toJSONString(data));
            if (CollectionUtils.isNotEmpty(data)) {
                for (BillParamVO datum : data) {
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (vo.getTotalNum().add(finishNum).compareTo(planNum) > 0) {
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("工序检测预警");
                        paramsCheckDsVO.setWarnName("工序检测校验，检验数+已完成检验数是否超过计划数预警");

                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("工程名称为：").append(vo.getProjectName())
                                .append("的计划检验数为").append(planNum.setScale(0, BigDecimal.ROUND_DOWN))
                                .append("个,已检验完成").append(finishNum.setScale(0, BigDecimal.ROUND_DOWN))
                                .append("个。总完成检验数已超过计划数，是否继续保存");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOS;
    }
}
