package com.ejianc.business.jlprogress.asset.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlprogress.asset.bean.AllotDetailEntity;
import com.ejianc.business.jlprogress.asset.bean.RecordEntity;
import com.ejianc.business.jlprogress.asset.enums.RecordTypeEnum;
import com.ejianc.business.jlprogress.asset.mapper.RecordMapper;
import com.ejianc.business.jlprogress.asset.service.IRecordService;
import com.ejianc.business.jlprogress.asset.vo.AllotDetailVO;
import com.ejianc.business.jlprogress.asset.vo.AllotVO;
import com.ejianc.business.jlprogress.asset.vo.RecordVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlprogress.asset.mapper.AllotMapper;
import com.ejianc.business.jlprogress.asset.bean.AllotEntity;
import com.ejianc.business.jlprogress.asset.service.IAllotService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 浦江设备管理-调拨
 *
 * @author generator
 */
@Service("allotService")
public class AllotServiceImpl extends BaseServiceImpl<AllotMapper, AllotEntity> implements IAllotService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private RecordMapper recordMapper;
    @Autowired
    private IRecordService recordService;
    private static final String BILL_CODE = "ALLOT_CODE";//此处需要根据实际修改

    @Override
    public CommonResponse<AllotVO> saveOrupdate(AllotVO saveOrUpdateVO) {
        AllotEntity entity = BeanMapper.map(saveOrUpdateVO, AllotEntity.class);
        if (ListUtil.isEmpty(entity.getAllotDetailList())){
            return CommonResponse.error("调拨明细不能为空");
        }
        List<Long> sourceIds = saveOrUpdateVO.getAllotDetailList().stream().map(AllotDetailVO::getSourceId).collect(Collectors.toList());
        List<RecordVO> useNumList = recordMapper.queryUseNumList(entity.getOrgId(), sourceIds, entity.getId());
        Map<String, BigDecimal> useNumMap = useNumList.stream().collect(Collectors.toMap((recordVO) -> {
            return recordVO.getOrgId().toString() + recordVO.getMaterialId().toString() + recordVO.getSourceBillId().toString();
        }, RecordVO::getUseNum));
        for (AllotDetailEntity detailEntity : entity.getAllotDetailList()) {
            String key = entity.getOrgId().toString() + detailEntity.getMaterialId().toString() + detailEntity.getSourceId();
            if (detailEntity.getAllotNum().compareTo(useNumMap.get(key)) > 0) {
                return CommonResponse.error("物料" + detailEntity.getMaterialName() + "调拨数量超出可用数量");
            }
        }
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        this.saveOrUpdate(entity, false);
        recordMapper.deleteBySourceId(entity.getId());
        // 生成数据
        List<RecordEntity> recordList = new ArrayList<>();
        for (AllotDetailEntity detailEntity : entity.getAllotDetailList()) {
            // 如果删除，则跳出
            if ("del".equals(detailEntity.getRowState())) {
                continue;
            }
            // 否则添加
            RecordEntity record1 = new RecordEntity();
            RecordEntity record2 = new RecordEntity();

            // 相反赋值
            record1.setRecordType(RecordTypeEnum.调拨入.getCode());
            record1.setOrgId(entity.getInOrgId());
            record1.setOrgName(entity.getInOrgName());
            record1.setOrgCode(entity.getInOrgCode());
            record1.setInoutOrgId(entity.getOrgId());
            record1.setInoutOrgName(entity.getOrgName());
            record1.setInoutOrgCode(entity.getOrgCode());
            record1.setNum(detailEntity.getAllotNum());
            record1.setMny(detailEntity.getDetailAllotMny());

            record2.setRecordType(RecordTypeEnum.调拨出.getCode());
            record2.setOrgId(entity.getOrgId());
            record2.setOrgName(entity.getOrgName());
            record2.setOrgCode(entity.getOrgCode());
            record2.setInoutOrgId(entity.getInOrgId());
            record2.setInoutOrgName(entity.getInOrgName());
            record2.setInoutOrgCode(entity.getInOrgCode());
            record2.setNum(detailEntity.getAllotNum().negate());
            record2.setMny(detailEntity.getDetailAllotMny().negate());

            //其他属性赋值
            record1.setSourceId(entity.getId());
            record1.setSourceBillCode(detailEntity.getSourceBillCode());
            record1.setSourceBillId(detailEntity.getSourceId());
            record1.setMaterialId(detailEntity.getMaterialId());
            record1.setMaterialName(detailEntity.getMaterialName());
            record1.setMaterialCode(detailEntity.getMaterialCode());
            record1.setMaterialTypeId(detailEntity.getMaterialTypeId());
            record1.setMaterialTypeName(detailEntity.getMaterialTypeName());
            record1.setMaterialTypeCode(detailEntity.getMaterialTypeCode());
            record1.setSpec(detailEntity.getSpec());
            record1.setModel(detailEntity.getModel());
            record1.setUnit(detailEntity.getUnit());
            record1.setState(0);
            record1.setRecordDate(entity.getAssetDate());
            record1.setEmployeeId(entity.getEmployeeId());
            record1.setEmployeeName(entity.getEmployeeName());
            record1.setPrice(detailEntity.getPrice());
            record1.setAllotBillCode(entity.getBillCode());

            record2.setSourceId(entity.getId());
            record2.setSourceBillCode(detailEntity.getSourceBillCode());
            record2.setSourceBillId(detailEntity.getSourceId());
            record2.setMaterialId(detailEntity.getMaterialId());
            record2.setMaterialName(detailEntity.getMaterialName());
            record2.setMaterialCode(detailEntity.getMaterialCode());
            record2.setMaterialTypeId(detailEntity.getMaterialTypeId());
            record2.setMaterialTypeName(detailEntity.getMaterialTypeName());
            record2.setMaterialTypeCode(detailEntity.getMaterialTypeCode());
            record2.setSpec(detailEntity.getSpec());
            record2.setModel(detailEntity.getModel());
            record2.setUnit(detailEntity.getUnit());
            record2.setState(0);
            record2.setRecordDate(entity.getAssetDate());
            record2.setEmployeeId(entity.getEmployeeId());
            record2.setEmployeeName(entity.getEmployeeName());
            record2.setPrice(detailEntity.getPrice());
            record2.setAllotBillCode(entity.getBillCode());
            recordList.add(record1);
            recordList.add(record2);
        }
        recordService.saveOrUpdateBatch(recordList);
        AllotVO vo = BeanMapper.map(entity, AllotVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }
}
