package com.ejianc.business.jlprogress.factory.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 制造厂-金点子汇总明细表
 *
 * @author generator
 *
 */
 @TableName("ejc_factory_gold_detail")
public class FactGoldDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="gold_id")
    private Long goldId; // 主表ID
    @TableField(value="bill_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date billDate; // 日期
    @TableField(value="factory")
    private String factory; // 分厂
    @TableField(value="name")
    private String name; // 提案名称
    @TableField(value="before_change")
    private String beforeChange; // 改善前
    @TableField(value="after_change")
    private String afterChange; // 改善后
    @TableField(value="category")
    private String category; // 类别
    @TableField(value="cost_mny")
    private BigDecimal costMny; // 节约成本金额（元）
    @TableField(value="signer")
    private String signer; // 提案人
    @TableField(value="reward_mny")
    private BigDecimal rewardMny; // 奖励金额（元）
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="project_code")
    private String projectCode; // 项目code
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="source_id")
    private Long sourceId; // 来源ID




    public Long getGoldId() {
        return goldId;
    }

    public void setGoldId(Long goldId) {
        this.goldId = goldId;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    public String getFactory() {
        return factory;
    }

    public void setFactory(String factory) {
        this.factory = factory;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getBeforeChange() {
        return beforeChange;
    }

    public void setBeforeChange(String beforeChange) {
        this.beforeChange = beforeChange;
    }
    public String getAfterChange() {
        return afterChange;
    }

    public void setAfterChange(String afterChange) {
        this.afterChange = afterChange;
    }
    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }
    public BigDecimal getCostMny() {
        return costMny;
    }

    public void setCostMny(BigDecimal costMny) {
        this.costMny = costMny;
    }
    public String getSigner() {
        return signer;
    }

    public void setSigner(String signer) {
        this.signer = signer;
    }
    public BigDecimal getRewardMny() {
        return rewardMny;
    }

    public void setRewardMny(BigDecimal rewardMny) {
        this.rewardMny = rewardMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

}
