package com.ejianc.business.jlprogress.factory.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 制造厂-制造厂设备明细表
 *
 * @author generator
 *
 */
public class FactEquipmentDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long equipmentId; // 主表ID
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM",
            timezone = "GMT+8"
    )
    private Date detailMonth; // 填报月份
    private String code; // 设备编号
    private String name; // 设备名称
    private String spec; // 设备型号
    private String factory; // 生产厂家及国别
    private String outCode; // 出场编号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date outDate; // 出场日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date buyDate; // 购置日期
    private BigDecimal firstMny; // 设备原值(万)
    private String equipState; // 设备状态
    private String precisionLevl; // 精度等级
    private String category; // 设备类别
    private BigDecimal power; // 功率(kw)
    private String memo; // 备注
    private String errorMsg; // 导入错误信息
    private String reportMonth;

    public String getReportMonth() {
        return reportMonth;
    }

    public void setReportMonth(String reportMonth) {
        this.reportMonth = reportMonth;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public Long getEquipmentId() {
        return equipmentId;
    }

    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }

    public Date getDetailMonth() {
        return detailMonth;
    }

    public void setDetailMonth(Date detailMonth) {
        this.detailMonth = detailMonth;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getFactory() {
        return factory;
    }

    public void setFactory(String factory) {
        this.factory = factory;
    }
    public String getOutCode() {
        return outCode;
    }

    public void setOutCode(String outCode) {
        this.outCode = outCode;
    }
    public Date getOutDate() {
        return outDate;
    }

    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }
    public Date getBuyDate() {
        return buyDate;
    }

    public void setBuyDate(Date buyDate) {
        this.buyDate = buyDate;
    }
    public BigDecimal getFirstMny() {
        return firstMny;
    }

    public void setFirstMny(BigDecimal firstMny) {
        this.firstMny = firstMny;
    }
    public String getEquipState() {
        return equipState;
    }

    public void setEquipState(String equipState) {
        this.equipState = equipState;
    }
    public String getPrecisionLevl() {
        return precisionLevl;
    }

    public void setPrecisionLevl(String precisionLevl) {
        this.precisionLevl = precisionLevl;
    }
    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }
    public BigDecimal getPower() {
        return power;
    }

    public void setPower(BigDecimal power) {
        this.power = power;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

}
