package com.ejianc.business.jlprogress.labor.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jlprogress.labor.service.IMaterialPurchaseDetailsService;
import com.ejianc.business.jlprogress.labor.vo.MaterialPurchaseDetailsVO;
import com.ejianc.business.jlprogress.quality.vo.UnqualifiedReport;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jlprogress.labor.bean.MaterialPurchaseEntity;
import com.ejianc.business.jlprogress.labor.service.IMaterialPurchaseService;
import com.ejianc.business.jlprogress.labor.vo.MaterialPurchaseVO;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 浦江设备管理-大宗物资设备申请表
 *
 * @author generator
 */
@Controller
@RequestMapping("materialPurchase")
public class MaterialPurchaseController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IShareMaterialApi iShareMaterialApi;
    @Autowired
    private IMaterialPurchaseDetailsService detailsService;

    private static final String BILL_CODE = "Material_Purchase";//此处需要根据实际修改

    @Autowired
    private IMaterialPurchaseService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaterialPurchaseVO> saveOrUpdate(@RequestBody MaterialPurchaseVO saveOrUpdateVO) {
        MaterialPurchaseEntity entity = BeanMapper.map(saveOrUpdateVO, MaterialPurchaseEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                //   entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        MaterialPurchaseVO vo = BeanMapper.map(entity, MaterialPurchaseVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialPurchaseVO> queryDetail(Long id) {
        MaterialPurchaseEntity entity = service.selectById(id);
        MaterialPurchaseVO vo = BeanMapper.map(entity, MaterialPurchaseVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialPurchaseVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MaterialPurchaseVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(MaterialPurchaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialPurchaseVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("employeeName");//填报人
        fuzzyFields.add("billCode");//单据编号

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        String startOfMonth = "";
        String endOfMonth = "";
        if (param.getParams().containsKey("month")) {
            //2024-07
            String checkMonth = param.getParams().get("month").getValue().toString();
            // 解析月份
            LocalDate date = LocalDate.parse(checkMonth + "-01", DateTimeFormatter.ISO_LOCAL_DATE);
            //获取到本月的第一天 本月最后一天
            startOfMonth = String.valueOf(date.withDayOfMonth(1));
            endOfMonth = String.valueOf(date.withDayOfMonth(date.lengthOfMonth()));
            param.getParams().remove("month");
            param.getParams().put("fillInDate", new Parameter(QueryParam.BETWEEN, startOfMonth + "," + endOfMonth));
        }

        IPage<MaterialPurchaseEntity> page = service.queryPage(param, false);
        IPage<MaterialPurchaseVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialPurchaseVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        List<MaterialPurchaseEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MaterialPurchase-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refMaterialPurchaseData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialPurchaseVO>> refMaterialPurchaseData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<MaterialPurchaseEntity> page = service.queryPage(param, false);
        IPage<MaterialPurchaseVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialPurchaseVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadInfo")
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "MaterialPurchaseDetails-import.xlsx", "大宗物资设备申请表明细模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<MaterialPurchaseDetailsVO> successList = new ArrayList<>();
        List<MaterialPurchaseDetailsVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {


                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    MaterialPurchaseDetailsVO detailVO = new MaterialPurchaseDetailsVO();
                    detailVO.setId(com.ejianc.support.idworker.util.IdWorker.getId());

                    //name赋值
                    detailVO.setName(datas.get(0));
                    //规格型号赋值
                    detailVO.setSpecModel(datas.get(1));
                    //单位赋值
                    detailVO.setUnit(datas.get(2));
                    //给备注值
                    detailVO.setDetailMemo(datas.get(6));
                    successList.add(detailVO);

                    try {
                        BigDecimal num = BigDecimal.valueOf(Double.parseDouble(datas.get(3)));
                        detailVO.setNum(num);
                    } catch (Exception e) {
                        detailVO.setErrorMsg("需用数量格式错误！");
                        errorList.add(detailVO);
                        continue;
                    }

                    try {
                        BigDecimal referenceMny = BigDecimal.valueOf(Double.parseDouble(datas.get(4)));
                        detailVO.setReferenceMny(referenceMny);
                    } catch (Exception e) {
                        detailVO.setErrorMsg("参考价格格式错误！");
                        errorList.add(detailVO);
                        continue;
                    }
                    try {
                        BigDecimal subtotal = BigDecimal.valueOf(Double.parseDouble(datas.get(5)));
                        detailVO.setSubtotal(subtotal);
                    } catch (Exception e) {
                        detailVO.setErrorMsg("小计格式错误！");
                        errorList.add(detailVO);
                        continue;
                    }

                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }



    @RequestMapping(value = "/reportQueryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> reportQueryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("specModel");
        fuzzyFields.add("unit");
        /** 租户隔离 */
        Page<MaterialPurchaseDetailsVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        List<MaterialPurchaseDetailsVO> list = new ArrayList<>();
        String startOfMonth = "";
        String endOfMonth = "";

        if (param.getParams().containsKey("month")) {
            //2024-07
            String checkMonth = param.getParams().get("month").getValue().toString();
            // 解析月份
            LocalDate date = LocalDate.parse(checkMonth + "-01", DateTimeFormatter.ISO_LOCAL_DATE);
            //获取到本月的第一天 本月最后一天
            startOfMonth = String.valueOf(date.withDayOfMonth(1));
            endOfMonth = String.valueOf(date.withDayOfMonth(date.lengthOfMonth()));
            param.getParams().remove("month");
            param.getParams().put("fillInDate", new Parameter(QueryParam.BETWEEN, startOfMonth + "," + endOfMonth));
        }
        QueryWrapper wrapper = changeToQueryWrapper(param);
        list = detailsService.materialPurchaseReport(page, wrapper);
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());

        return CommonResponse.success("查询列表数据成功！", res);
    }

    /**
     * @param param
     * @Description 报表导出
     * @Return void
     */
    @RequestMapping(value = "/excelReportExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelReportExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");//填报人
        fuzzyFields.add("specModel");
        fuzzyFields.add("unit");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);


        Page<MaterialPurchaseDetailsVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        List<MaterialPurchaseDetailsVO> list = new ArrayList<>();
        String startOfMonth = "";
        String endOfMonth = "";
        if (param.getParams().containsKey("month")) {
            //2024-07
            String checkMonth = param.getParams().get("month").getValue().toString();
            // 解析月份
            LocalDate date = LocalDate.parse(checkMonth + "-01", DateTimeFormatter.ISO_LOCAL_DATE);
            //获取到本月的第一天 本月最后一天
            startOfMonth = String.valueOf(date.withDayOfMonth(1));
            endOfMonth = String.valueOf(date.withDayOfMonth(date.lengthOfMonth()));
            param.getParams().remove("month");
            param.getParams().put("fillInDate", new Parameter(QueryParam.BETWEEN, startOfMonth + "," + endOfMonth));
        }
        QueryWrapper wrapper = changeToQueryWrapper(param);
        list = detailsService.materialPurchaseReport(page, wrapper);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MaterialPurchaseReport-export.xlsx", beans, response);
    }

}
