package com.ejianc.business.jlprogress.progress.handler;

import com.ejianc.business.jlprogress.progress.cons.PlanConstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @author yqls
 * @version 1.0
 * @description: 执行计划公共服务工厂
 * @date 2022/6/16
 */
@Component
public class PlanFactory {

    @Autowired
    private Map<String, IPlanHandler> handlerMap;

    /**
     * 获取计划类型处理器
     * @param planState
     * @return
     */
    public IPlanHandler getHandler(Integer planState) {
        if (PlanConstant.TOTAL_PLAN.equals(planState)) {
            return handlerMap.get("totalHandler");
        } else if (PlanConstant.YEAR_PLAN.equals(planState)) {
            return handlerMap.get("yearHandler");
        } else if (PlanConstant.MONTH_PLAN.equals(planState)) {
            return handlerMap.get("monthHandler");
        } else if (PlanConstant.WEEK_PLAN.equals(planState)) {
            return handlerMap.get("weekHandler");
        } else if (PlanConstant.DAY_FILL.equals(planState)) {
            return handlerMap.get("dayFillHandler");
        }
        return null;
    }

}
