package com.ejianc.business.jlprogress.progress.handler;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.jlprogress.progress.bean.ProgressDetailEntity;
import com.ejianc.business.jlprogress.progress.vo.BaseDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.*;
import java.util.stream.Collectors;

@Component
public class TreeUtils<T> {

	/**
	 * 重置主键和父级主键
	 * @param list
	 * @param <T>
	 * @return
	 */
	public static <T> List<T> restParentId(List<T> list){
		list = listToTree(list);
		list = treeToList(list);
		return list;
	}

	public static <T> T resetProjectClomn(T vo, Map<Long, Long> idMap) {
		Map<String, Long> pkMap = idMap.entrySet().stream().collect(Collectors.toMap(x->String.valueOf(x.getKey()), x->x.getValue()));
		Object preObj = getValue(vo, "predecessorLink");
		if (preObj != null) {
			JSONArray predecessorLink = JSONArray.parseArray(String.valueOf(getValue(vo, "predecessorLink")));
			if(predecessorLink.size() > 0){
				for (int j = 0; j < predecessorLink.size(); j++) {
					JSONObject json = predecessorLink.getJSONObject(j);
					String PredecessorUID = json.getString("PredecessorUID");
					if (pkMap.containsKey(PredecessorUID)) {
						json.put("PredecessorUID", pkMap.get(PredecessorUID));
					}
					String TaskUID = json.getString("TaskUID");
					if (pkMap.containsKey(TaskUID)) {
						json.put("TaskUID", pkMap.get(TaskUID));
					}
				}
			}
			setValue(vo, "predecessorLink", String.valueOf(predecessorLink));
		}
		Object assiObj = getValue(vo, "assignments");
		if (assiObj != null) {
			JSONArray assignments = JSONArray.parseArray(String.valueOf(getValue(vo, "assignments")));
			if(assignments.size() > 0){
				for (int j = 0; j < assignments.size(); j++) {
					JSONObject json = assignments.getJSONObject(j);
					String TaskUID = json.getString("TaskUID");
					if (pkMap.containsKey(TaskUID)) {
						json.put("TaskUID", pkMap.get(TaskUID));
					}
				}
			}
			setValue(vo, "assignments", String.valueOf(assignments));
		}
		return vo;
	}

	public static <T> List<T> getPreLinkList(List<T> list, String structCode) {
		if(CollectionUtils.isEmpty(list)){
			return null;
		}
		Map<String, T> codeMap = list.stream().collect(Collectors.toMap(x->String.valueOf(getValue(x, "structCode")), x->x));
		Map<String, T> idMap = list.stream().collect(Collectors.toMap(x->String.valueOf(getValue(x, "id")), x->x));
		if(!codeMap.containsKey(structCode)){
			return null;
		}
		T vo = codeMap.get(structCode);
		Object preObj = getValue(vo, "predecessorLink");
		if (preObj == null) {
			return null;
		}
		JSONArray predecessorLink = JSONArray.parseArray(String.valueOf(getValue(vo, "predecessorLink")));
		List<T> result = new ArrayList<>();
		if(CollectionUtils.isNotEmpty(predecessorLink)){
			for (int j = 0; j < predecessorLink.size(); j++) {
				JSONObject json = predecessorLink.getJSONObject(j);
				String PredecessorUID = json.getString("PredecessorUID");
				if(idMap.containsKey(PredecessorUID)){
					result.add(idMap.get(PredecessorUID));
				}
			}
		}
		return result;
	}

	/**
	 * 前置任务转成文本
	 * @param result
	 * @param predecessorLink
	 * @return
	 */
	public static <T extends BaseDetailVO> String getPlanPreLink(LinkedList<T> result, JSONArray predecessorLink) {
		List<String> strs = new ArrayList<>();
		if(CollectionUtils.isEmpty(predecessorLink)){
			return null;
		}
		for(Object o : predecessorLink){
			JSONObject obj = (JSONObject)o;
			Integer index = -1;
			for(int i = 0; i < result.size(); i++){
				if(result.get(i).getUid().equals(obj.getString("PredecessorUID"))){
					index = i + 1;
				}
			}
			if(index == -1){
				continue;
			}
			StringBuffer str = new StringBuffer();
			str.append(index);
			// 0FF，1FS，2SF，3SS
			if(obj.getInteger("Type") == 0){
				str.append("FF");
			} else if(obj.getInteger("Type") == 1 && obj.getInteger("LinkLag") != 0){
				str.append("FS");
			} else if(obj.getInteger("Type") == 2){
				str.append("SF");
			} else if(obj.getInteger("Type") == 3){
				str.append("SS");
			}
			if(obj.getInteger("LinkLag") > 0){
				str.append("+" + obj.getInteger("LinkLag"));
			} else if(obj.getInteger("LinkLag") < 0){
//                str.append("1" + obj.getInteger("LinkLag"));
				// 减法应该不需要"1"
				str.append(obj.getInteger("LinkLag"));
			}
			strs.add(str.toString());
		}
		return strs.stream().collect(Collectors.joining(","));
	}

	/**
	 * List转成树，并重置主键和父级主键
	 * @param list
	 * @param <T>
	 * @return
	 */
	public static <T> List<T> listToTree(List<T> list) {
		List<T> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();
		Map<String, T> listMap = new HashMap<>();
		for(T detail : list) {
			listMap.put(String.valueOf(getValue(detail, "id")), detail);
		}
        for(int i = 0; i < list.size(); i++) {
        	T detail = list.get(i);
			String parentId = String.valueOf(getValue(detail, "parentId"));
        	T parent = listMap.get(parentId);
        	if(parent != null) {
        		List<T> children = castList(getValue(parent, "children"), parent.getClass());
				children.add(detail);
				setValue(parent, "children", children);
			} else {
        		rootItems.add(String.valueOf(getValue(detail, "id")));
        	}
        }
        for(String rootId : rootItems) {
        	resp.add(listMap.get(rootId));
        }
		return resp;
	}

	/**
	 * 树转成List
	 * @param tree
	 * @param <T>
	 * @return
	 */
	public static <T> List<T> treeToList(List<T> tree) {
		Map<String, Long> pkMap = new HashMap<>();
		List<T> list = new ArrayList<>();
		getPkMap(pkMap, tree);
		treeToList(pkMap, list, tree);
		return list;
	}

	/**
	 * 循环遍历获取主键Map
	 * @param pkMap
	 * @param tree
	 */
	private static <T> void getPkMap(Map<String,Long> pkMap, List<T> tree) {
		for (int i = 0, len = tree.size(); i < len; i++) {
			T vo = tree.get(i);
			setValue(vo, "sourceBid", getValue(vo, "id"));// sourceBid记录原始单据明细主键
			Long pkId = IdWorker.getId();
			pkMap.put(String.valueOf(getValue(vo, "id")), pkId);
			List<T> children = castList(getValue(vo, "children"), vo.getClass());
			if (children != null && children.size() > 0) {
				getPkMap(pkMap, children);
			}
		}
	}

	public static <T> void treeToList(Map<String,Long> pkMap, List<T> list, List<T> tree) {
		for (int i = 0, len = tree.size(); i < len; i++) {
			T vo = tree.get(i);
			if(pkMap.containsKey(String.valueOf(getValue(vo, "id")))){
				setValue(vo, "id", pkMap.get(String.valueOf(getValue(vo, "id"))));
			}
			String parentId = String.valueOf(getValue(vo, "parentId"));
			if(StringUtils.isNotBlank(parentId)) {
				if(pkMap.containsKey(parentId)) {
					setValue(vo, "parentId", pkMap.get(parentId));
				}
			}
			Object preObj = getValue(vo, "predecessorLink");
			if (preObj != null) {
				JSONArray predecessorLink = JSONArray.parseArray(String.valueOf(getValue(vo, "predecessorLink")));
				if(predecessorLink.size() > 0){
					for (int j = 0; j < predecessorLink.size(); j++) {
						JSONObject json = predecessorLink.getJSONObject(j);
						String PredecessorUID = json.getString("PredecessorUID");
						if (pkMap.containsKey(PredecessorUID)) {
							json.put("PredecessorUID", pkMap.get(PredecessorUID));
						}
						String TaskUID = json.getString("TaskUID");
						if (pkMap.containsKey(TaskUID)) {
							json.put("TaskUID", pkMap.get(TaskUID));
						}
					}
				}
				setValue(vo, "predecessorLink", String.valueOf(predecessorLink));
			}
			Object assiObj = getValue(vo, "assignments");
			if (assiObj != null) {
				JSONArray assignments = JSONArray.parseArray(String.valueOf(getValue(vo, "assignments")));
				if(assignments.size() > 0){
					for (int j = 0; j < assignments.size(); j++) {
						JSONObject json = assignments.getJSONObject(j);
						String TaskUID = json.getString("TaskUID");
						if (pkMap.containsKey(TaskUID)) {
							json.put("TaskUID", pkMap.get(TaskUID));
						}
					}
				}
				setValue(vo, "assignments", String.valueOf(assignments));
			}
			List<T> children = castList(getValue(vo, "children"), vo.getClass());
			if (children != null && children.size() > 0) {
				treeToList(pkMap, list, children);
			}
			setValue(vo, "children", null);
			list.add(vo);
		}
	}

	/**
	 * 重设树形编码
	 * @param tree
	 * @param outlineNumber
	 * @param <T>
	 */
	public static <T extends ProgressDetailEntity> void resetOutlineNumber(List<T> tree, String outlineNumber){
		Integer num = 0;
		for(T item : tree){
			if (StringUtils.isEmpty(outlineNumber)) {
				item.setOutlineNumber(String.valueOf(num + 1));
				num++;
			} else {
				item.setOutlineNumber(outlineNumber + "." + (num + 1));
				num++;
			}
			List<T> child = castList(getValue(item, "children"), item.getClass());
			if (CollectionUtils.isNotEmpty(child)) {
				resetOutlineNumber(child, item.getOutlineNumber());
			}
		}
	}

	/**
	 * get方法
	 * @param t
	 * @param fieldName
	 * @param <T>
	 * @return
	 */
	private static <T> Object getValue(T t, String fieldName) {
		Class<?> clazz = t.getClass() ;
		for(; clazz != Object.class ; clazz = clazz.getSuperclass()) {
			try {
				Method m = clazz.getDeclaredMethod("get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1), (Class[]) null);
				try {
					return m.invoke(t, (Object[]) null);
				} catch (IllegalAccessException e) {
					throw new BusinessException("类【" + clazz + "】的字段【" + fieldName + "】的get方法需要设置成public属性！");
				} catch (InvocationTargetException e) {
					throw new BusinessException("类【" + clazz + "】的字段【" + fieldName + "】的get方法调用失败！");
				}
			} catch (Exception e) {
				//这里甚么都不要做！并且这里的异常必须这样写，不能抛出去。
				//如果这里的异常打印或者往外抛，则就不会执行clazz = clazz.getSuperclass(),最后就不会进入到父类中了
			}
		}
		return null;
	}

	/**
	 * set方法
	 * @param t
	 * @param fieldName
	 * @param obj
	 * @param <T>
	 */
	private static <T> void setValue(T t, String fieldName, Object obj) {
		Class<?> clazz = t.getClass() ;
		for(; clazz != Object.class ; clazz = clazz.getSuperclass()) {
			try {
				Field field = clazz.getDeclaredField(fieldName);
				Method m = clazz.getDeclaredMethod("set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1), field.getType());
				try {
					m.invoke(t, obj);
				} catch (IllegalAccessException e) {
					throw new BusinessException("类【" + clazz + "】的字段【" + fieldName + "】的get方法需要设置成public属性！");
				} catch (InvocationTargetException e) {
					throw new BusinessException("类【" + clazz + "】的字段【" + fieldName + "】的get方法调用失败！");
				}
			} catch (Exception e) {
				//这里甚么都不要做！并且这里的异常必须这样写，不能抛出去。
				//如果这里的异常打印或者往外抛，则就不会执行clazz = clazz.getSuperclass(),最后就不会进入到父类中了
			}
		}
	}

	/**
	 * Object转换成List
	 * @param <T>
	 * @param obj
	 * @param clazz
	 * @return
	 */
	public static <T> List<T> castList(Object obj, Class<?> clazz) {
		List<T> result = new ArrayList<>();
		if(obj instanceof List<?>){
			for(Object o : (List<?>) obj){
				result.add((T) clazz.cast(o));
			}
		}
		return result;
	}

}
