/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.factory.controller;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlprogress.factory.bean.FactBuyEntity;
import com.ejianc.business.jlprogress.factory.service.IFactBuyService;
import com.ejianc.business.jlprogress.factory.vo.FactBuyDetailVO;
import com.ejianc.business.jlprogress.factory.vo.FactBuyVO;
import com.ejianc.business.jlprogress.progress.utils.DateUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"factBuy"})
public class FactBuyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "FACT_BUY_CODE";
    @Autowired
    private IFactBuyService service;
    @Autowired
    private IDefdocApi defdocApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<FactBuyVO> saveOrUpdate(@RequestBody FactBuyVO saveOrUpdateVO) {
        FactBuyEntity entity = (FactBuyEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), FactBuyEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        FactBuyVO vo = (FactBuyVO)((Object)BeanMapper.map((Object)((Object)entity), FactBuyVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FactBuyVO> queryDetail(Long id) {
        FactBuyEntity entity = (FactBuyEntity)((Object)this.service.selectById(id));
        FactBuyVO vo = (FactBuyVO)((Object)BeanMapper.map((Object)((Object)entity), FactBuyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FactBuyVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (FactBuyVO factBuyVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<FactBuyVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FactBuyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("FactBuy-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refFactBuyData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<FactBuyVO>> refFactBuyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FactBuyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"fact-buy-import.xlsx", (String)"\u5bfc\u5165\u6a21\u677f");
    }

    @PostMapping(value={"/excelImport"})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        ArrayList<FactBuyDetailVO> successList = new ArrayList<FactBuyDetailVO>();
        ArrayList processList = new ArrayList();
        ArrayList<FactBuyDetailVO> errorList = new ArrayList<FactBuyDetailVO>();
        CommonResponse defDocByDefCodeStatus = this.defdocApi.getDefDocByDefCode("tech-status");
        if (!defDocByDefCodeStatus.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u6863\u6848\u4fe1\u606f\u5931\u8d25!");
        }
        List defDocByDefCodeDataStataus = (List)defDocByDefCodeStatus.getData();
        Map defdocDetailVOStatusMap = defDocByDefCodeDataStataus.stream().collect(Collectors.toMap(DefdocDetailVO::getName, Function.identity(), (key1, key2) -> key2));
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            HashMap codeMapCache = new HashMap();
            FactBuyDetailVO importVo = null;
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                importVo = new FactBuyDetailVO();
                importVo.setId(IdWorker.getId());
                importVo.setProjectName((String)datas.get(1));
                importVo.setProductName((String)datas.get(2));
                importVo.setSpec((String)datas.get(3));
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    if (defdocDetailVOStatusMap.containsKey(datas.get(0))) {
                        DefdocDetailVO defdocDetailVO = (DefdocDetailVO)defdocDetailVOStatusMap.get(datas.get(0));
                        importVo.setStateId(defdocDetailVO.getId());
                        importVo.setStateName(defdocDetailVO.getName());
                    } else {
                        importVo.setErrorMsg("\u72b6\u6001\u4e0d\u5728\u81ea\u5b9a\u4e49\u6863\u6848\u5e93\uff01");
                        errorList.add(importVo);
                        continue;
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4)))) {
                    if (!TextUtils.isEmpty((CharSequence)((CharSequence)datas.get(4))) && !NumberUtil.isNumber((String)((String)datas.get(4)))) {
                        importVo.setErrorMsg("\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorList.add(importVo);
                        continue;
                    }
                    importVo.setSignNum(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5))) ? new BigDecimal((String)datas.get(4)) : null);
                }
                importVo.setOutFactory((String)datas.get(5));
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6)))) {
                    if (DateUtil.grepDate((String)datas.get(6))) {
                        importVo.setSignDate(DateUtil.Date((String)datas.get(6)));
                    } else {
                        importVo.setErrorMsg("\u62a5\u5355\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorList.add(importVo);
                        continue;
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7)))) {
                    if (DateUtil.grepDate((String)datas.get(7))) {
                        importVo.setGiveDate(DateUtil.Date((String)datas.get(7)));
                    } else {
                        importVo.setErrorMsg("\u4ea4\u4ed8\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorList.add(importVo);
                        continue;
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8)))) {
                    if (DateUtil.grepDate((String)datas.get(8))) {
                        importVo.setGetDate(DateUtil.Date((String)datas.get(8)));
                    } else {
                        importVo.setErrorMsg("\u91c7\u8d2d\u63a5\u5355\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorList.add(importVo);
                        continue;
                    }
                }
                importVo.setBuyCompany((String)datas.get(9));
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(10)))) {
                    if (DateUtil.grepDate((String)datas.get(10))) {
                        importVo.setReturnDate(DateUtil.Date((String)datas.get(10)));
                    } else {
                        importVo.setErrorMsg("\u5b9e\u9645\u56de\u5382\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorList.add(importVo);
                        continue;
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(11)))) {
                    if (!TextUtils.isEmpty((CharSequence)((CharSequence)datas.get(11))) && !NumberUtil.isNumber((String)((String)datas.get(11)))) {
                        importVo.setErrorMsg("\u5b9e\u9645\u56de\u5382\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorList.add(importVo);
                        continue;
                    }
                    importVo.setReturnNum(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(11))) ? new BigDecimal((String)datas.get(11)) : null);
                }
                importVo.setBuyer((String)datas.get(12));
                importVo.setMemo((String)datas.get(13));
                successList.add(importVo);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }
}

