/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.factory.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlprogress.factory.bean.FactConsDetailEntity;
import com.ejianc.business.jlprogress.factory.bean.FactConsEntity;
import com.ejianc.business.jlprogress.factory.service.IFactConsDetailService;
import com.ejianc.business.jlprogress.factory.service.IFactConsService;
import com.ejianc.business.jlprogress.factory.vo.FactConsDetailVO;
import com.ejianc.business.jlprogress.factory.vo.FactConsVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"factCons"})
public class FactConsController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "FACT_CONS_CODE";
    @Autowired
    private IFactConsService service;
    @Autowired
    private IFactConsDetailService factConsDetailService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<FactConsVO> saveOrUpdate(@RequestBody FactConsVO saveOrUpdateVO) {
        int curCount;
        QueryWrapper curQuery = new QueryWrapper();
        curQuery.eq((Object)"DATE_FORMAT(sign_month, '%Y-%m' )", (Object)new SimpleDateFormat("yyyy-MM").format(saveOrUpdateVO.getSignMonth()));
        if (saveOrUpdateVO.getId() != null) {
            curQuery.ne((Object)"id", (Object)saveOrUpdateVO.getId());
        }
        if ((curCount = this.service.count((Wrapper)curQuery)) > 0) {
            throw new BusinessException("\u4e00\u4e2a\u6708\u53ea\u80fd\u505a\u4e00\u6761\u6570\u636e\uff01");
        }
        FactConsEntity entity = (FactConsEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), FactConsEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        FactConsVO vo = (FactConsVO)((Object)BeanMapper.map((Object)((Object)entity), FactConsVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FactConsVO> queryDetail(Long id) {
        FactConsEntity entity = (FactConsEntity)((Object)this.service.selectById(id));
        FactConsVO vo = (FactConsVO)((Object)BeanMapper.map((Object)((Object)entity), FactConsVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FactConsVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (FactConsVO factConsVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<FactConsVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FactConsVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("FactCons-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refFactConsData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<FactConsVO>> refFactConsData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FactConsVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/selectLastDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<FactConsDetailVO>> queryDetail(String month) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Date date = format.parse(month);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, -1);
        Date time = calendar.getTime();
        String lastDate = format.format(time);
        QueryWrapper curQuery = new QueryWrapper();
        curQuery.eq((Object)"DATE_FORMAT(sign_month, '%Y-%m' )", (Object)lastDate);
        curQuery.in((Object)"bill_state", new Object[]{1, 3});
        FactConsEntity consEntity = (FactConsEntity)((Object)this.service.getOne((Wrapper)curQuery));
        List detailVOS = new ArrayList();
        if (consEntity != null) {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(FactConsDetailEntity::getConsId, (Object)consEntity.getId());
            lambdaQueryWrapper.eq(FactConsDetailEntity::getPropertyCode, (Object)"1");
            List list = this.factConsDetailService.list((Wrapper)lambdaQueryWrapper);
            detailVOS = BeanMapper.mapList((Iterable)list, FactConsDetailVO.class);
            for (FactConsDetailVO detailVO : detailVOS) {
                detailVO.setConsId(null);
                detailVO.setId(IdWorker.getId());
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", detailVOS);
    }
}

