/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.order.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlprogress.order.bean.PlanEntity;
import com.ejianc.business.jlprogress.order.service.IPlanService;
import com.ejianc.business.jlprogress.order.vo.PlanDetailVO;
import com.ejianc.business.jlprogress.order.vo.PlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"plan"})
public class PlanController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IShareMaterialApi iShareMaterialApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IPlanService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PlanVO> saveOrUpdate(@RequestBody PlanVO saveOrUpdateVO) {
        List list;
        PlanEntity entity = (PlanEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PlanEntity.class));
        String billCode = entity.getBillCode();
        QueryWrapper wrapper = (QueryWrapper)new QueryWrapper().eq((Object)"bill_code", (Object)billCode);
        if (entity.getId() != null) {
            wrapper = (QueryWrapper)wrapper.ne((Object)"id", (Object)entity.getId());
        }
        if ((list = this.service.list((Wrapper)wrapper)) != null && list.size() != 0) {
            return CommonResponse.error((String)"\u8ba1\u5212\u5355\u53f7\u5df2\u5b58\u5728");
        }
        this.service.saveOrUpdate((Object)entity, false);
        PlanVO vo = (PlanVO)BeanMapper.map((Object)((Object)entity), PlanVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PlanVO> queryDetail(Long id) {
        PlanEntity entity = (PlanEntity)((Object)this.service.selectById(id));
        PlanVO vo = (PlanVO)BeanMapper.map((Object)((Object)entity), PlanVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PlanVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PlanVO planVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PlanVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("customName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("customName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List resDatas = BeanMapper.mapList((Iterable)list, PlanVO.class);
        for (PlanVO resData : resDatas) {
            switch (resData.getBillState()) {
                case 0: {
                    resData.setBillStateName("\u81ea\u7531\u6001");
                    break;
                }
                case 1: {
                    resData.setBillStateName("\u5df2\u63d0\u4ea4");
                    break;
                }
                case 2: 
                case 5: {
                    resData.setBillStateName("\u5ba1\u6279\u4e2d");
                    break;
                }
                case 3: {
                    resData.setBillStateName("\u5ba1\u6279\u901a\u8fc7");
                    break;
                }
                case 4: {
                    resData.setBillStateName("\u5ba1\u6279\u9a73\u56de");
                }
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", resDatas);
        ExcelExport.getInstance().export("Plan-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPlanData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PlanVO>> refPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        Long contractId;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        list.add(3);
        param.getParams().put("billState", new Parameter("in", list));
        LinkedHashMap<String, String> hashMap = new LinkedHashMap<String, String>();
        hashMap.put("createTime", "desc");
        param.setOrderMap(hashMap);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && null != (contractId = (_con = JSONObject.parseObject((String)condition)).getLong("contractId"))) {
            param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        }
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("customName");
        fuzzyFields.add("productOrgName");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/downloadInfo"})
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"PlanDetail-import.xlsx", (String)"\u8ba1\u5212\u901a\u77e5-\u7269\u6599\u660e\u7ec6\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<PlanDetailVO> successList = new ArrayList<PlanDetailVO>();
        ArrayList<PlanDetailVO> errorList = new ArrayList<PlanDetailVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            ArrayList materialCodeList = new ArrayList();
            Map<Object, Object> map = new HashMap();
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                materialCodeList.add(datas.get(0));
            }
            CommonResponse materialRes = this.iShareMaterialApi.queryMaterialListByCodes(materialCodeList);
            if (!materialRes.isSuccess()) {
                return CommonResponse.error((String)materialRes.getMsg());
            }
            map = ((List)materialRes.getData()).stream().collect(Collectors.toMap(p -> p.getCode(), Function.identity()));
            for (int i = 1; i < result.size(); ++i) {
                Boolean flag;
                List datas = (List)result.get(i);
                PlanDetailVO detailVO = new PlanDetailVO();
                detailVO.setId(Long.valueOf(IdWorker.getId()));
                String materialCode = (String)datas.get(0);
                detailVO.setMaterialCode(materialCode);
                try {
                    if (ObjectUtils.isEmpty((Object)map.get(materialCode))) {
                        throw new Exception("\u6ca1\u6709\u6b64\u6750\u6599\uff01");
                    }
                    detailVO.setMaterialId(((MaterialVO)map.get(materialCode)).getId());
                    detailVO.setMaterialName(((MaterialVO)map.get(materialCode)).getName());
                    detailVO.setSpec(((MaterialVO)map.get(materialCode)).getSpec());
                    detailVO.setModel(((MaterialVO)map.get(materialCode)).getModel());
                    detailVO.setUnit((String)datas.get(5));
                    detailVO.setMaterialTypeId(((MaterialVO)map.get(materialCode)).getCategoryId());
                    detailVO.setMaterialTypeCode(((MaterialVO)map.get(materialCode)).getCategoryCode());
                    detailVO.setMaterialTypeName(((MaterialVO)map.get(materialCode)).getCategoryName());
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u6ca1\u6709\u6b64\u6750\u6599\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    detailVO.setMaterialNum(BigDecimal.valueOf(Double.parseDouble((String)datas.get(4))));
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u6216\u6570\u91cf\u683c\u5f0f\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    Date detailDeliveryDate = new SimpleDateFormat("yyyy-MM-dd").parse((String)datas.get(6));
                    detailVO.setDetailDeliveryDate(detailDeliveryDate);
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u4ea4\u8d27\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u6216\u4ea4\u8d27\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                detailVO.setMemo((String)datas.get(7));
                if (((String)datas.get(8)).equals("\u662f")) {
                    flag = true;
                    detailVO.setIsStop(flag);
                } else if (((String)datas.get(8)).equals("\u5426")) {
                    flag = false;
                    detailVO.setIsStop(flag);
                } else if ("".equals(datas.get(8)) || datas.get(8) == null) {
                    detailVO.setIsStop(null);
                } else {
                    detailVO.setErrorMsg("\u662f\u5426\u505c\u4ea7\u683c\u5f0f\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                if (datas.get(9) == null || datas.get(9) == "") {
                    detailVO.setMaterialProduceNum(null);
                } else if (datas.get(9) != null) {
                    try {
                        detailVO.setMaterialProduceNum(BigDecimal.valueOf(Double.parseDouble((String)datas.get(9))));
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("\u5df2\u751f\u4ea7\u6570\u91cf\u683c\u5f0f\u9519\u8bef\uff01");
                        errorList.add(detailVO);
                        continue;
                    }
                }
                successList.add(detailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/refPlanList"}, method={RequestMethod.GET})
    @ResponseBody
    public List<PlanVO> refPlanList(@RequestParam(required=false) String condition, @RequestParam(required=false) String searchText) {
        JSONObject _con;
        Long contractId;
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        list.add(3);
        param.getParams().put("billState", new Parameter("in", list));
        LinkedHashMap<String, String> hashMap = new LinkedHashMap<String, String>();
        hashMap.put("createTime", "desc");
        param.setOrderMap(hashMap);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && null != (contractId = (_con = JSONObject.parseObject((String)condition)).getLong("contractId"))) {
            param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        }
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("customName");
        fuzzyFields.add("productOrgName");
        List result = this.service.queryList(param, false);
        List planVOS = BeanMapper.mapList((Iterable)result, PlanVO.class);
        for (PlanVO vo : planVOS) {
            vo.setCode(vo.getBillCode());
            vo.setName(vo.getBillCode());
        }
        return planVOS;
    }
}

