/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.order.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.jlprogress.factory.service.IFactBuyService;
import com.ejianc.business.jlprogress.factory.service.IFactConsService;
import com.ejianc.business.jlprogress.factory.service.IFactEquipmentService;
import com.ejianc.business.jlprogress.factory.service.IFactGoldService;
import com.ejianc.business.jlprogress.factory.service.IFactJigaiService;
import com.ejianc.business.jlprogress.factory.service.IFactPlanService;
import com.ejianc.business.jlprogress.factory.service.IFactProgressService;
import com.ejianc.business.jlprogress.factory.service.IFactShareService;
import com.ejianc.business.jlprogress.labor.service.IAdditionalService;
import com.ejianc.business.jlprogress.labor.service.ILaborSubService;
import com.ejianc.business.jlprogress.labor.service.IMaterialPurchaseService;
import com.ejianc.business.jlprogress.order.mapper.SalesMapper;
import com.ejianc.business.jlprogress.order.service.ISalesService;
import com.ejianc.business.jlprogress.order.vo.IncomeContractVO;
import com.ejianc.business.jlprogress.progress.bean.TotalPlanEntity;
import com.ejianc.business.jlprogress.progress.mapper.TotalPlanMapper;
import com.ejianc.business.jlprogress.progress.service.IExecPlanService;
import com.ejianc.business.jlprogress.progress.service.ITotalPlanService;
import com.ejianc.business.jlprogress.progress.vo.ExecPlanDetailVO;
import com.ejianc.business.jlprogress.tech.service.ITechOrderService;
import com.ejianc.business.jlprogress.tech.service.ITechSchemeService;
import com.ejianc.business.jlprogress.tech.service.ITechSituationService;
import com.ejianc.business.jlprogress.tech.service.ITechTestService;
import com.ejianc.business.warn.vo.WarningReceiveVO;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.api.IShareProjectWbsApi;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/warn/"})
public class WarnController {
    private static final Long TEST_ORG_ID = 1247777316689256450L;
    private static final Long FORMAL_ORG_ID = 2405220001L;
    private static final Long TEST_PUJIANG_ORG_ID = 1247777316689256450L;
    private static final Long FORMAL_PUJIANG_ORG_ID = 2405220190L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String SALES_WARN_NAME = "\u9500\u552e\u8ba2\u5355\u672a\u5236\u5355";
    private static final String PLAN_WARN_NAME = "\u8ba1\u5212\u901a\u77e5\u5355\u672a\u5236\u5355";
    private static final String YEAR_PLAN_WARN_NAME = "\u8ba1\u5212\u5206\u89e3\u672a\u5236\u5355";
    private static final String SUPPLIES_WARN_NAME = "\u5927\u5b97\u7269\u8d44\u8bbe\u5907\u7533\u8bf7\u8868 \u672a\u5236\u5355";
    private static final String LABOR_WARN_NAME = "\u52b3\u52a1\u5206\u5305\u7528\u6b3e\u8ba1\u5212\u8868 \u672a\u5236\u5355";
    private static final String ADDITION_WARN_NAME = "\u8ba2\u5355\u8ffd\u52a0\u8d39\u7528\u7edf\u8ba1\u8868 \u672a\u5236\u5355";
    private static final String FACTCONS_WARN_NAME = "\u65bd\u5de5\u9879\u76ee\u6708\u8fdb\u5ea6\u4e00\u89c8\u8868 \u672a\u5236\u5355";
    private static final String FACTEQUIPMENT_WARN_NAME = "\u5236\u9020\u5382\u8bbe\u5907\u53f0\u8d26 \u672a\u5236\u5355";
    private static final String FACTGOLD_WARN_NAME = "\u5236\u9020\u5382\u91d1\u70b9\u5b50\u6c47\u603b\u8868 \u672a\u5236\u5355";
    private static final String FACTJIGAI_WARN_NAME = "\u6280\u6539\u9879\u76ee\u8fdb\u5ea6\u8868 \u672a\u5236\u5355";
    private static final String FACTBUY_WARN_NAME = "\u4e3b\u6750\u91c7\u8d2d\u8fdb\u5ea6\u8868 \u672a\u5236\u5355";
    private static final String FACTSHARE_WARN_NAME = "\u5185\u90e8\u534f\u4f5c\u8fdb\u5ea6\u8868 \u672a\u5236\u5355";
    private static final String FACTPROGRESS_WARN_NAME = "\u5236\u9020\u5382\u5916\u534f/\u5916\u8d2d\u4ea7\u54c1\u8fdb\u5ea6\u660e\u7ec6\u8868 \u672a\u5236\u5355";
    private static final String FACTPLAN_WARN_NAME = "\u5236\u9020\u5382\u8ba1\u5212\u5355\u53f0\u8d26 \u672a\u5236\u5355";
    private static final String TECHTEST_WARN_NAME = "\u578b\u5f0f\u8bd5\u9a8c\u60c5\u51b5 \u672a\u5236\u5355";
    private static final String TECHSITUATION_WARN_NAME = "\u79d1\u6280\u6210\u679c\u5956\u9879\u7533\u62a5\u60c5\u51b5 \u672a\u5236\u5355";
    private static final String TECHSCHEME_WARN_NAME = "\u65b9\u6848\u56fe\u4e00\u89c8\u8868 \u672a\u5236\u5355";
    private static final String TECHORDER_WARN_NAME = "\u5728\u6267\u884c\u8ba2\u5355 \u672a\u5236\u5355";
    private static final String SALES_REPORT_URL = "/ejc-jlprogress-frontend/#/sales";
    private static final String PLAN_REPORT_URL = "/ejc-jlprogress-frontend/#/plan";
    private static final String TOTAL_PLAN_URL = "/ejc-jlprogress-frontend/#/totalPlan";
    private static final String YEAR_PLAN_URL = "/ejc-jlprogress-frontend/#/planResolve";
    private static final String SUPPLIES_URL = "/ejc-jlprogress-frontend/#/materialPurchase";
    private static final String LABOR_URL = "/ejc-jlprogress-frontend/#/laborSub";
    private static final String ADDITION_URL = "/ejc-jlprogress-frontend/#/additional";
    private static final String FACTCONS_URL = "/ejc-jlprogress-frontend/#/factCons";
    private static final String FACTEQUIPMENT_URL = "/ejc-jlprogress-frontend/#/factEquipment";
    private static final String FACTGOLD_URL = "/ejc-jlprogress-frontend/#/factGold";
    private static final String FACTJIGAI_URL = "/ejc-jlprogress-frontend/#/factJigai";
    private static final String FACTBUY_URL = "/ejc-jlprogress-frontend/#/factBuy";
    private static final String FACTSHARE_URL = "/ejc-jlprogress-frontend/#/factShare";
    private static final String FACTPROGRESS_URL = "/ejc-jlprogress-frontend/#/factProgress";
    private static final String FACTPLAN_URL = "/ejc-jlprogress-frontend/#/factPlan";
    private static final String TECHTEST_URL = "/ejc-jlprogress-frontend/#/techTest";
    private static final String TECHSITUATION_URL = "/ejc-jlprogress-frontend/#/techSituation";
    private static final String TECHSCHEME_URL = "/ejc-jlprogress-frontend/#/techScheme";
    private static final String TECHORDER_URL = "/ejc-jlprogress-frontend/#/techOrder";
    private static final String EXECPLAN_WARN_NAME = "\u5de5\u5e8f\u5ef6\u671f\u9884\u8b66";
    private static final String EXECPLAN_URL = "/ejc-jlprogress-frontend/#/execPlan";
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private ISalesService salesService;
    @Autowired
    private SalesMapper salesMapper;
    @Autowired
    private TotalPlanMapper totalPlanMapper;
    @Autowired
    private ITotalPlanService totalPlanService;
    @Autowired
    private IProjectArchiveApi projectApi;
    @Autowired
    private IShareProjectWbsApi shareProjectWbsApi;
    @Autowired
    private IMaterialPurchaseService materialPurchaseService;
    @Autowired
    private ILaborSubService laborSubService;
    @Autowired
    private IAdditionalService additionalService;
    @Autowired
    private IFactConsService factConsService;
    @Autowired
    private IFactEquipmentService factEquipmentService;
    @Autowired
    private IFactGoldService factGoldService;
    @Autowired
    private IFactJigaiService factJigaiService;
    @Autowired
    private IFactBuyService factBuyService;
    @Autowired
    private IFactShareService factShareService;
    @Autowired
    private IFactProgressService factProgressService;
    @Autowired
    private IFactPlanService factPlanService;
    @Autowired
    private ITechTestService techTestService;
    @Autowired
    private ITechSituationService techSituationService;
    @Autowired
    private ITechSchemeService techSchemeService;
    @Autowired
    private ITechOrderService techOrderService;
    @Autowired
    private IExecPlanService execPlanService;

    @PostMapping(value={"salesWarn"})
    public CommonResponse<String> salesWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        List<IncomeContractVO> recordVOList = this.salesMapper.getNoSales();
        if (CollectionUtils.isEmpty(recordVOList)) {
            this.logger.error("\u6267\u884c\u9500\u552e\u8ba2\u5355\u672a\u5236\u5355\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5355\u636e\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        this.logger.info("\u672a\u505a\u9500\u552e\u8ba2\u5355\u7684\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(recordVOList));
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        DecimalFormat df = new DecimalFormat("###,##0.00");
        for (IncomeContractVO reportVO : recordVOList) {
            String warnLevel = defaultWarnInfo.getString("warnLevel");
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName(reportVO.getProjectName());
            vo.setPcTitle("\u9500\u552e\u8ba2\u5355");
            vo.setPcUrl(SALES_REPORT_URL);
            vo.setOrgId(reportVO.getOrgId());
            vo.setOrgName(reportVO.getOrgName());
            vo.setTenantId(Long.valueOf(999999L));
            vo.setWarnLevel(warnLevel);
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent.replaceAll("#contractName#", reportVO.getContractName()));
            resp.add(vo);
        }
        return this.sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"planWarn"})
    public CommonResponse<String> planWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        List<IncomeContractVO> recordVOList = this.salesMapper.getNoPlan();
        if (CollectionUtils.isEmpty(recordVOList)) {
            this.logger.error("\u6267\u884c\u8ba1\u5212\u901a\u77e5\u5355\u672a\u5236\u5355\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5355\u636e\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        this.logger.info("\u672a\u505a\u8ba1\u5212\u901a\u77e5\u5355\u7684\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(recordVOList));
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        for (IncomeContractVO reportVO : recordVOList) {
            String warnLevel = defaultWarnInfo.getString("warnLevel");
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName(reportVO.getProjectName());
            vo.setPcTitle("\u8ba1\u5212\u901a\u77e5\u5355");
            vo.setPcUrl(PLAN_REPORT_URL);
            vo.setOrgId(reportVO.getOrgId());
            vo.setOrgName(reportVO.getOrgName());
            vo.setTenantId(Long.valueOf(999999L));
            vo.setWarnLevel(warnLevel);
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent.replaceAll("#contractName#", reportVO.getContractName()));
            resp.add(vo);
        }
        return this.sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"totalPlanWarn"})
    public CommonResponse<String> totalPlanWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        List<ProjectArchiveVO> projectList = this.totalPlanMapper.getNoPlan();
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        for (ProjectArchiveVO project : projectList) {
            String warnLevel = defaultWarnInfo.getString("warnLevel");
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName(project.getName());
            vo.setPcTitle("\u9879\u76ee\u603b\u8ba1\u5212");
            vo.setPcUrl(TOTAL_PLAN_URL);
            vo.setOrgId(project.getOrgId());
            vo.setOrgName(project.getOrgName());
            vo.setTenantId(Long.valueOf(999999L));
            vo.setWarnLevel(warnLevel);
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", project.getName()));
            resp.add(vo);
        }
        return this.sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"yearPlanWarn"})
    public CommonResponse<String> yearPlanWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        List<TotalPlanEntity> projectList = this.totalPlanService.getNoTotalPlan();
        if (CollectionUtils.isEmpty(projectList)) {
            this.logger.error("\u6267\u884c\u8ba1\u5212\u5206\u89e3\u672a\u5236\u5355\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5355\u636e\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        this.logger.info("\u672a\u505a\u8ba1\u5212\u5206\u89e3\u7684\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(projectList));
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        for (TotalPlanEntity totalPlanEntity : projectList) {
            String warnLevel = defaultWarnInfo.getString("warnLevel");
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName(totalPlanEntity.getProjectName());
            vo.setPcTitle("\u8ba1\u5212\u5206\u89e3");
            vo.setPcUrl(YEAR_PLAN_URL);
            vo.setOrgId(totalPlanEntity.getParentOrgId());
            vo.setOrgName(totalPlanEntity.getParentOrgName());
            vo.setTenantId(Long.valueOf(999999L));
            vo.setWarnLevel(warnLevel);
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", totalPlanEntity.getProjectName()));
            resp.add(vo);
        }
        return this.sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"suppliesWarn"})
    public CommonResponse<String> suppliesWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        Integer count = this.materialPurchaseService.isHaveDone();
        if (count > 0) {
            this.logger.error("\u6267\u884c\u5927\u5b97\u7269\u8d44\u8bbe\u5907\u7533\u8bf7\u8868 \u672a\u5236\u5355\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5355\u636e\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        String warnLevel = defaultWarnInfo.getString("warnLevel");
        EarlyWarnTransVO vo = new EarlyWarnTransVO();
        vo.setBillName("\u5927\u5b97\u7269\u8d44\u8bbe\u5907\u7533\u8bf7\u8868");
        vo.setOrgId(FORMAL_PUJIANG_ORG_ID);
        vo.setOrgName("\u5de8\u529b\u7d22\u5177\u80a1\u4efd\u6709\u9650\u516c\u53f8");
        vo.setPcTitle("\u5927\u5b97\u7269\u8d44\u8bbe\u5907\u7533\u8bf7\u8868");
        vo.setPcUrl(SUPPLIES_URL);
        vo.setTenantId(Long.valueOf(999999L));
        vo.setWarnLevel(warnLevel);
        vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
        vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
        tmpContent = defaultWarnInfo.getString("earlywarnContent");
        vo.setEarlywarnContent(tmpContent.replaceAll("#name#", "\u5927\u5b97\u7269\u8d44\u8bbe\u5907\u7533\u8bf7\u8868"));
        resp.add(vo);
        return this.sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"laborWarn"})
    public CommonResponse<String> laborWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        Integer count = this.laborSubService.isHaveDone();
        if (count > 0) {
            this.logger.error("\u6267\u884c\u52b3\u52a1\u5206\u5305\u7528\u6b3e\u8ba1\u5212\u8868 \u672a\u5236\u5355\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5355\u636e\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        String warnLevel = defaultWarnInfo.getString("warnLevel");
        EarlyWarnTransVO vo = new EarlyWarnTransVO();
        vo.setBillName("\u52b3\u52a1\u5206\u5305\u7528\u6b3e\u8ba1\u5212\u8868");
        vo.setOrgId(FORMAL_PUJIANG_ORG_ID);
        vo.setOrgName("\u5de8\u529b\u7d22\u5177\u80a1\u4efd\u6709\u9650\u516c\u53f8");
        vo.setPcTitle("\u52b3\u52a1\u5206\u5305\u7528\u6b3e\u8ba1\u5212\u8868");
        vo.setPcUrl(LABOR_URL);
        vo.setTenantId(Long.valueOf(999999L));
        vo.setWarnLevel(warnLevel);
        vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
        vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
        tmpContent = defaultWarnInfo.getString("earlywarnContent");
        vo.setEarlywarnContent(tmpContent.replaceAll("#name#", "\u52b3\u52a1\u5206\u5305\u7528\u6b3e\u8ba1\u5212\u8868"));
        resp.add(vo);
        return this.sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"additionalWarn"})
    public CommonResponse<String> additionalWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        Integer count = this.additionalService.isHaveDone();
        if (count > 0) {
            this.logger.error("\u6267\u884c\u8ba2\u5355\u8ffd\u52a0\u8d39\u7528\u7edf\u8ba1\u8868 \u672a\u5236\u5355\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5355\u636e\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        String warnLevel = defaultWarnInfo.getString("warnLevel");
        EarlyWarnTransVO vo = new EarlyWarnTransVO();
        vo.setBillName("\u8ba2\u5355\u8ffd\u52a0\u8d39\u7528\u7edf\u8ba1\u8868");
        vo.setOrgId(FORMAL_PUJIANG_ORG_ID);
        vo.setOrgName("\u5de8\u529b\u7d22\u5177\u80a1\u4efd\u6709\u9650\u516c\u53f8");
        vo.setPcTitle("\u8ba2\u5355\u8ffd\u52a0\u8d39\u7528\u7edf\u8ba1\u8868");
        vo.setPcUrl(ADDITION_URL);
        vo.setTenantId(Long.valueOf(999999L));
        vo.setWarnLevel(warnLevel);
        vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
        vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
        tmpContent = defaultWarnInfo.getString("earlywarnContent");
        vo.setEarlywarnContent(tmpContent.replaceAll("#name#", "\u8ba2\u5355\u8ffd\u52a0\u8d39\u7528\u7edf\u8ba1\u8868"));
        resp.add(vo);
        return this.sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"factConsWarn"})
    public CommonResponse<String> factConsWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        Integer count = this.factConsService.isHaveDone();
        if (count > 0) {
            this.logger.error("\u6267\u884c\u65bd\u5de5\u9879\u76ee\u6708\u8fdb\u5ea6\u4e00\u89c8\u8868 \u672a\u5236\u5355\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5355\u636e\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        String warnLevel = defaultWarnInfo.getString("warnLevel");
        EarlyWarnTransVO vo = new EarlyWarnTransVO();
        vo.setBillName("\u65bd\u5de5\u9879\u76ee\u6708\u8fdb\u5ea6\u4e00\u89c8\u8868");
        vo.setOrgId(FORMAL_PUJIANG_ORG_ID);
        vo.setOrgName("\u5de8\u529b\u7d22\u5177\u80a1\u4efd\u6709\u9650\u516c\u53f8");
        vo.setPcTitle("\u65bd\u5de5\u9879\u76ee\u6708\u8fdb\u5ea6\u4e00\u89c8\u8868");
        vo.setPcUrl(FACTCONS_URL);
        vo.setTenantId(Long.valueOf(999999L));
        vo.setWarnLevel(warnLevel);
        vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
        vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
        tmpContent = defaultWarnInfo.getString("earlywarnContent");
        vo.setEarlywarnContent(tmpContent.replaceAll("#name#", "\u65bd\u5de5\u9879\u76ee\u6708\u8fdb\u5ea6\u4e00\u89c8\u8868"));
        resp.add(vo);
        return this.sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"factEquipmentWarn"})
    public CommonResponse<String> factEquipmentWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        Integer count = this.factEquipmentService.isHaveDone();
        if (count > 0) {
            this.logger.error("\u6267\u884c\u5236\u9020\u5382\u8bbe\u5907\u53f0\u8d26 \u672a\u5236\u5355\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5355\u636e\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        String warnLevel = defaultWarnInfo.getString("warnLevel");
        EarlyWarnTransVO vo = new EarlyWarnTransVO();
        vo.setBillName("\u5236\u9020\u5382\u8bbe\u5907\u53f0\u8d26");
        vo.setOrgId(FORMAL_ORG_ID);
        vo.setOrgName("\u5de8\u529b\u7d22\u5177\u80a1\u4efd\u6709\u9650\u516c\u53f8");
        vo.setPcTitle("\u5236\u9020\u5382\u8bbe\u5907\u53f0\u8d26");
        vo.setPcUrl(FACTEQUIPMENT_URL);
        vo.setTenantId(Long.valueOf(999999L));
        vo.setWarnLevel(warnLevel);
        vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
        vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
        tmpContent = defaultWarnInfo.getString("earlywarnContent");
        vo.setEarlywarnContent(tmpContent.replaceAll("#name#", "\u5236\u9020\u5382\u8bbe\u5907\u53f0\u8d26"));
        resp.add(vo);
        return this.sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"factGoldWarn"})
    public CommonResponse<String> factGoldWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        Integer count = this.factGoldService.isHaveDone();
        if (count > 0) {
            this.logger.error("\u6267\u884c\u5236\u9020\u5382\u91d1\u70b9\u5b50\u6c47\u603b\u8868 \u672a\u5236\u5355\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5355\u636e\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        String warnLevel = defaultWarnInfo.getString("warnLevel");
        EarlyWarnTransVO vo = new EarlyWarnTransVO();
        vo.setBillName("\u5236\u9020\u5382\u91d1\u70b9\u5b50\u6c47\u603b\u8868");
        vo.setOrgId(FORMAL_ORG_ID);
        vo.setOrgName("\u5de8\u529b\u7d22\u5177\u80a1\u4efd\u6709\u9650\u516c\u53f8");
        vo.setPcTitle("\u5236\u9020\u5382\u91d1\u70b9\u5b50\u6c47\u603b\u8868");
        vo.setPcUrl(FACTGOLD_URL);
        vo.setTenantId(Long.valueOf(999999L));
        vo.setWarnLevel(warnLevel);
        vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
        vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
        tmpContent = defaultWarnInfo.getString("earlywarnContent");
        vo.setEarlywarnContent(tmpContent.replaceAll("#name#", "\u5236\u9020\u5382\u91d1\u70b9\u5b50\u6c47\u603b\u8868"));
        resp.add(vo);
        return this.sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"factJigaiWarn"})
    public CommonResponse<String> factJigaiWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        Integer count = this.factJigaiService.isHaveDone();
        if (count > 0) {
            this.logger.error("\u6267\u884c\u6280\u6539\u9879\u76ee\u8fdb\u5ea6\u8868 \u672a\u5236\u5355\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5355\u636e\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        String warnLevel = defaultWarnInfo.getString("warnLevel");
        EarlyWarnTransVO vo = new EarlyWarnTransVO();
        vo.setBillName("\u6280\u6539\u9879\u76ee\u8fdb\u5ea6\u8868");
        vo.setOrgId(FORMAL_ORG_ID);
        vo.setOrgName("\u5de8\u529b\u7d22\u5177\u80a1\u4efd\u6709\u9650\u516c\u53f8");
        vo.setPcTitle("\u6280\u6539\u9879\u76ee\u8fdb\u5ea6\u8868");
        vo.setPcUrl(FACTJIGAI_URL);
        vo.setTenantId(Long.valueOf(999999L));
        vo.setWarnLevel(warnLevel);
        vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
        vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
        tmpContent = defaultWarnInfo.getString("earlywarnContent");
        vo.setEarlywarnContent(tmpContent.replaceAll("#name#", "\u6280\u6539\u9879\u76ee\u8fdb\u5ea6\u8868"));
        resp.add(vo);
        return this.sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"factBuyWarn"})
    public CommonResponse<String> factBuyWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        Integer count = this.factBuyService.isHaveDone();
        if (count > 0) {
            this.logger.error("\u6267\u884c\u4e3b\u6750\u91c7\u8d2d\u8fdb\u5ea6\u8868 \u672a\u5236\u5355\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5355\u636e\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        String warnLevel = defaultWarnInfo.getString("warnLevel");
        EarlyWarnTransVO vo = new EarlyWarnTransVO();
        vo.setBillName("\u4e3b\u6750\u91c7\u8d2d\u8fdb\u5ea6\u8868");
        vo.setOrgId(FORMAL_ORG_ID);
        vo.setOrgName("\u5de8\u529b\u7d22\u5177\u80a1\u4efd\u6709\u9650\u516c\u53f8");
        vo.setPcTitle("\u4e3b\u6750\u91c7\u8d2d\u8fdb\u5ea6\u8868");
        vo.setPcUrl(FACTBUY_URL);
        vo.setTenantId(Long.valueOf(999999L));
        vo.setWarnLevel(warnLevel);
        vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
        vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
        tmpContent = defaultWarnInfo.getString("earlywarnContent");
        vo.setEarlywarnContent(tmpContent.replaceAll("#name#", "\u4e3b\u6750\u91c7\u8d2d\u8fdb\u5ea6\u8868"));
        resp.add(vo);
        return this.sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"factShareWarn"})
    public CommonResponse<String> factShareWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        Integer count = this.factShareService.isHaveDone();
        if (count > 0) {
            this.logger.error("\u6267\u884c\u5185\u90e8\u534f\u4f5c\u8fdb\u5ea6\u8868 \u672a\u5236\u5355\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5355\u636e\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        String warnLevel = defaultWarnInfo.getString("warnLevel");
        EarlyWarnTransVO vo = new EarlyWarnTransVO();
        vo.setBillName("\u5185\u90e8\u534f\u4f5c\u8fdb\u5ea6\u8868");
        vo.setOrgId(FORMAL_ORG_ID);
        vo.setOrgName("\u5de8\u529b\u7d22\u5177\u80a1\u4efd\u6709\u9650\u516c\u53f8");
        vo.setPcTitle("\u5185\u90e8\u534f\u4f5c\u8fdb\u5ea6\u8868");
        vo.setPcUrl(FACTSHARE_URL);
        vo.setTenantId(Long.valueOf(999999L));
        vo.setWarnLevel(warnLevel);
        vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
        vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
        tmpContent = defaultWarnInfo.getString("earlywarnContent");
        vo.setEarlywarnContent(tmpContent.replaceAll("#name#", "\u5185\u90e8\u534f\u4f5c\u8fdb\u5ea6\u8868"));
        resp.add(vo);
        return this.sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"factProgressWarn"})
    public CommonResponse<String> factProgressWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        Integer count = this.factProgressService.isHaveDone();
        if (count > 0) {
            this.logger.error("\u6267\u884c\u5236\u9020\u5382\u5916\u534f/\u5916\u8d2d\u4ea7\u54c1\u8fdb\u5ea6\u660e\u7ec6\u8868 \u672a\u5236\u5355\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5355\u636e\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        String warnLevel = defaultWarnInfo.getString("warnLevel");
        EarlyWarnTransVO vo = new EarlyWarnTransVO();
        vo.setBillName("\u5236\u9020\u5382\u5916\u534f/\u5916\u8d2d\u4ea7\u54c1\u8fdb\u5ea6\u660e\u7ec6\u8868");
        vo.setOrgId(FORMAL_ORG_ID);
        vo.setOrgName("\u5de8\u529b\u7d22\u5177\u80a1\u4efd\u6709\u9650\u516c\u53f8");
        vo.setPcTitle("\u5236\u9020\u5382\u5916\u534f/\u5916\u8d2d\u4ea7\u54c1\u8fdb\u5ea6\u660e\u7ec6\u8868");
        vo.setPcUrl(FACTPROGRESS_URL);
        vo.setTenantId(Long.valueOf(999999L));
        vo.setWarnLevel(warnLevel);
        vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
        vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
        tmpContent = defaultWarnInfo.getString("earlywarnContent");
        vo.setEarlywarnContent(tmpContent.replaceAll("#name#", "\u5236\u9020\u5382\u5916\u534f/\u5916\u8d2d\u4ea7\u54c1\u8fdb\u5ea6\u660e\u7ec6\u8868"));
        resp.add(vo);
        return this.sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"factPlanWarn"})
    public CommonResponse<String> factPlanWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        Integer count = this.factPlanService.isHaveDone();
        if (count > 0) {
            this.logger.error("\u6267\u884c\u5236\u9020\u5382\u8ba1\u5212\u5355\u53f0\u8d26 \u672a\u5236\u5355\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5355\u636e\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        String warnLevel = defaultWarnInfo.getString("warnLevel");
        EarlyWarnTransVO vo = new EarlyWarnTransVO();
        vo.setBillName("\u5236\u9020\u5382\u8ba1\u5212\u5355\u53f0\u8d26");
        vo.setOrgId(FORMAL_ORG_ID);
        vo.setOrgName("\u5de8\u529b\u7d22\u5177\u80a1\u4efd\u6709\u9650\u516c\u53f8");
        vo.setPcTitle("\u5236\u9020\u5382\u8ba1\u5212\u5355\u53f0\u8d26");
        vo.setPcUrl(FACTPLAN_URL);
        vo.setTenantId(Long.valueOf(999999L));
        vo.setWarnLevel(warnLevel);
        vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
        vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
        tmpContent = defaultWarnInfo.getString("earlywarnContent");
        vo.setEarlywarnContent(tmpContent.replaceAll("#name#", "\u5236\u9020\u5382\u8ba1\u5212\u5355\u53f0\u8d26"));
        resp.add(vo);
        return this.sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"techTestWarn"})
    public CommonResponse<String> techTestWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        Integer count = this.techTestService.isHaveDone();
        if (count > 0) {
            this.logger.error("\u6267\u884c\u578b\u5f0f\u8bd5\u9a8c\u60c5\u51b5 \u672a\u5236\u5355\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5355\u636e\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        String warnLevel = defaultWarnInfo.getString("warnLevel");
        EarlyWarnTransVO vo = new EarlyWarnTransVO();
        vo.setBillName("\u578b\u5f0f\u8bd5\u9a8c\u60c5\u51b5");
        vo.setOrgId(FORMAL_ORG_ID);
        vo.setOrgName("\u5de8\u529b\u7d22\u5177\u80a1\u4efd\u6709\u9650\u516c\u53f8");
        vo.setPcTitle("\u578b\u5f0f\u8bd5\u9a8c\u60c5\u51b5");
        vo.setPcUrl(TECHTEST_URL);
        vo.setTenantId(Long.valueOf(999999L));
        vo.setWarnLevel(warnLevel);
        vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
        vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
        tmpContent = defaultWarnInfo.getString("earlywarnContent");
        vo.setEarlywarnContent(tmpContent.replaceAll("#name#", "\u578b\u5f0f\u8bd5\u9a8c\u60c5\u51b5"));
        resp.add(vo);
        return this.sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"techSituationWarn"})
    public CommonResponse<String> techSituationWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        Integer count = this.techSituationService.isHaveDone();
        if (count > 0) {
            this.logger.error("\u6267\u884c\u79d1\u6280\u6210\u679c\u5956\u9879\u7533\u62a5\u60c5\u51b5 \u672a\u5236\u5355\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5355\u636e\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        String warnLevel = defaultWarnInfo.getString("warnLevel");
        EarlyWarnTransVO vo = new EarlyWarnTransVO();
        vo.setBillName("\u79d1\u6280\u6210\u679c\u5956\u9879\u7533\u62a5\u60c5\u51b5");
        vo.setOrgId(FORMAL_ORG_ID);
        vo.setOrgName("\u5de8\u529b\u7d22\u5177\u80a1\u4efd\u6709\u9650\u516c\u53f8");
        vo.setPcTitle("\u79d1\u6280\u6210\u679c\u5956\u9879\u7533\u62a5\u60c5\u51b5");
        vo.setPcUrl(TECHSITUATION_URL);
        vo.setTenantId(Long.valueOf(999999L));
        vo.setWarnLevel(warnLevel);
        vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
        vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
        tmpContent = defaultWarnInfo.getString("earlywarnContent");
        vo.setEarlywarnContent(tmpContent.replaceAll("#name#", "\u79d1\u6280\u6210\u679c\u5956\u9879\u7533\u62a5\u60c5\u51b5"));
        resp.add(vo);
        return this.sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"techSchemeWarn"})
    public CommonResponse<String> techSchemeWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        Integer count = this.techSchemeService.isHaveDone();
        if (count > 0) {
            this.logger.error("\u6267\u884c\u65b9\u6848\u56fe\u4e00\u89c8\u8868 \u672a\u5236\u5355\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5355\u636e\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        String warnLevel = defaultWarnInfo.getString("warnLevel");
        EarlyWarnTransVO vo = new EarlyWarnTransVO();
        vo.setBillName("\u65b9\u6848\u56fe\u4e00\u89c8\u8868");
        vo.setOrgId(FORMAL_ORG_ID);
        vo.setOrgName("\u5de8\u529b\u7d22\u5177\u80a1\u4efd\u6709\u9650\u516c\u53f8");
        vo.setPcTitle("\u65b9\u6848\u56fe\u4e00\u89c8\u8868");
        vo.setPcUrl(TECHSCHEME_URL);
        vo.setTenantId(Long.valueOf(999999L));
        vo.setWarnLevel(warnLevel);
        vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
        vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
        tmpContent = defaultWarnInfo.getString("earlywarnContent");
        vo.setEarlywarnContent(tmpContent.replaceAll("#name#", "\u65b9\u6848\u56fe\u4e00\u89c8\u8868"));
        resp.add(vo);
        return this.sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"techOrderWarn"})
    public CommonResponse<String> techOrderWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        Integer count = this.techOrderService.isHaveDone();
        if (count > 0) {
            this.logger.error("\u6267\u884c\u5728\u6267\u884c\u8ba2\u5355 \u672a\u5236\u5355\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5355\u636e\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        String warnLevel = defaultWarnInfo.getString("warnLevel");
        EarlyWarnTransVO vo = new EarlyWarnTransVO();
        vo.setBillName("\u5728\u6267\u884c\u8ba2\u5355");
        vo.setOrgId(FORMAL_ORG_ID);
        vo.setOrgName("\u5de8\u529b\u7d22\u5177\u80a1\u4efd\u6709\u9650\u516c\u53f8");
        vo.setPcTitle("\u5728\u6267\u884c\u8ba2\u5355");
        vo.setPcUrl(TECHORDER_URL);
        vo.setTenantId(Long.valueOf(999999L));
        vo.setWarnLevel(warnLevel);
        vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
        vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
        tmpContent = defaultWarnInfo.getString("earlywarnContent");
        vo.setEarlywarnContent(tmpContent.replaceAll("#name#", "\u5728\u6267\u884c\u8ba2\u5355"));
        resp.add(vo);
        return this.sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"execPlanWarn"})
    public CommonResponse<String> execPlanWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        List<ExecPlanDetailVO> recordVOList = this.execPlanService.getPostponeList();
        if (CollectionUtils.isEmpty(recordVOList)) {
            this.logger.error("\u6267\u884c\u5de5\u5e8f\u5ef6\u671f\u9884\u8b66\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5355\u636e\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        this.logger.info("\u9879\u76ee\u8ba1\u5212\u67e5\u770b-\u5de5\u5e8f\u5ef6\u671f\uff1a{}", (Object)JSONObject.toJSONString(recordVOList));
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        for (ExecPlanDetailVO detailVO : recordVOList) {
            String warnLevel = defaultWarnInfo.getString("warnLevel");
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName(detailVO.getProjectName());
            vo.setPcTitle("\u9879\u76ee\u8ba1\u5212\u67e5\u770b");
            vo.setPcUrl(EXECPLAN_URL);
            vo.setOrgId(detailVO.getOrgId());
            vo.setOrgName(detailVO.getOrgName());
            vo.setTenantId(Long.valueOf(999999L));
            vo.setWarnLevel(warnLevel);
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            ArrayList<WarningReceiveVO> receiveList = new ArrayList<WarningReceiveVO>();
            WarningReceiveVO receiveVO = new WarningReceiveVO();
            receiveVO.setName(detailVO.getEmployeeName());
            receiveVO.setNameId(Long.valueOf(detailVO.getEmployeeId()));
            receiveVO.setType("user");
            receiveList.add(receiveVO);
            vo.setReceiveList(receiveList);
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", detailVO.getProjectName()) + tmpContent.replaceAll("#component#", detailVO.getComponent()) + tmpContent.replaceAll("#name#", detailVO.getName()));
            resp.add(vo);
        }
        return this.sendWarnToTaskWithReceive(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, Long warnId) {
        this.logger.info("\u53d1\u9001\u4efb\u52a1\uff1a{}", (Object)JSONObject.toJSONString(warnList));
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenter(warnList, warnId);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }

    private CommonResponse<String> sendWarnToTaskWithReceive(List<EarlyWarnTransVO> warnList, Long warnId) {
        this.logger.info("\u53d1\u9001\u4efb\u52a1\uff1a{}", (Object)JSONObject.toJSONString(warnList));
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenterWithReceive(warnList, warnId);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }

    private BigDecimal getBigDecimal(Object obj) {
        return null == obj ? BigDecimal.ZERO : new BigDecimal(obj.toString());
    }
}

