/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.order.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.jlprogress.order.bean.ProductOutEntity;
import com.ejianc.business.jlprogress.order.mapper.ProductOutMapper;
import com.ejianc.business.jlprogress.order.service.IProductOutService;
import com.ejianc.business.jlprogress.order.vo.ProductOutRecordVO;
import com.ejianc.business.jlprogress.order.vo.ProductOutVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service(value="productOutService")
public class ProductOutServiceImpl
extends BaseServiceImpl<ProductOutMapper, ProductOutEntity>
implements IProductOutService {
    @Override
    public ProductOutRecordVO queryProductOutRecord(Long contractId) {
        ProductOutRecordVO recordVO = new ProductOutRecordVO();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ProductOutEntity::getContractId, (Object)contractId);
        queryWrapper.in(ProductOutEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List entities = super.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            recordVO.setProductOutVOList(BeanMapper.mapList((Iterable)entities, ProductOutVO.class));
        }
        return recordVO;
    }

    @Override
    public Map<Long, ProductOutRecordVO> queryProductOutRecordByContractIdList(List<Long> ids) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(ProductOutEntity::getContractId, ids);
        queryWrapper.in(ProductOutEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List entities = super.list((Wrapper)queryWrapper);
        HashMap<Long, ProductOutRecordVO> collectMap = new HashMap<Long, ProductOutRecordVO>();
        if (CollectionUtils.isNotEmpty((Collection)entities) && entities.size() > 0) {
            Map<Long, List<ProductOutEntity>> productOutMap = entities.stream().collect(Collectors.groupingBy(ProductOutEntity::getContractId));
            for (Long contractId : productOutMap.keySet()) {
                ProductOutRecordVO productOutRecordVO = new ProductOutRecordVO();
                productOutRecordVO.setProductOutVOList(BeanMapper.mapList((Iterable)productOutMap.get(contractId), ProductOutVO.class));
                collectMap.put(contractId, productOutRecordVO);
            }
        }
        return collectMap;
    }
}

