/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.progress.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlprogress.progress.bean.ExecPlanDetailEntity;
import com.ejianc.business.jlprogress.progress.bean.ExecPlanEntity;
import com.ejianc.business.jlprogress.progress.bean.ProgressDetailEntity;
import com.ejianc.business.jlprogress.progress.cons.PlanConstant;
import com.ejianc.business.jlprogress.progress.handler.TreeUtils;
import com.ejianc.business.jlprogress.progress.service.IExecPlanDetailService;
import com.ejianc.business.jlprogress.progress.service.IExecPlanService;
import com.ejianc.business.jlprogress.progress.utils.DateUtil;
import com.ejianc.business.jlprogress.progress.utils.DetailListUtil;
import com.ejianc.business.jlprogress.progress.utils.PageUtil;
import com.ejianc.business.jlprogress.progress.utils.SeparatorUtil;
import com.ejianc.business.jlprogress.progress.utils.TreeHelper2;
import com.ejianc.business.jlprogress.progress.vo.ExecPlanDetailVO;
import com.ejianc.business.jlprogress.progress.vo.ExecPlanVO;
import com.ejianc.business.jlprogress.progress.vo.XmlVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.api.IShareProjectWbsApi;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.foundation.share.vo.ProjectWbsVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.JsonUtils;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"execPlan"})
public class ExecPlanController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProjectArchiveApi projectApi;
    @Autowired
    private IShareProjectWbsApi wbsApi;
    @Autowired
    private IExecPlanService service;
    @Autowired
    private IExecPlanDetailService detailService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ExecPlanVO> saveOrUpdate(@RequestBody ExecPlanVO saveOrUpdateVO) {
        ExecPlanVO vo = this.service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ExecPlanVO> queryDetail(Long id) {
        ExecPlanVO vo = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ExecPlanVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        this.service.removeByIds(ids, true);
        this.detailService.remove((Wrapper)new QueryWrapper().in((Object)"progress_id", ids));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ExecPlanVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectManagerName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        QueryParam queryParam = new QueryParam();
        Set ids = page.getRecords().stream().map(ExecPlanEntity::getProjectId).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(ids)) {
            queryParam.getParams().put("id", new Parameter("in", ids));
        } else {
            queryParam.getParams().put("id", new Parameter("eq", (Object)-1));
        }
        CommonResponse resp = this.projectApi.queryProjectArchivePage(queryParam);
        if (!resp.isSuccess()) {
            return CommonResponse.error((String)resp.getMsg());
        }
        Map<Long, ProjectArchiveVO> map = ((Page)resp.getData()).getRecords().stream().collect(Collectors.toMap(x -> x.getId(), x -> x));
        List records = BeanMapper.mapList((Iterable)page.getRecords(), ExecPlanVO.class);
        records.forEach(vo -> {
            if (map.containsKey(vo.getProjectId())) {
                vo.setCustomName(((ProjectArchiveVO)map.get(vo.getProjectId())).getCustomName());
            }
        });
        pageData.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectManagerName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ExecPlan-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refExecPlanData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ExecPlanVO>> refExecPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectManagerName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ExecPlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refExecPlanDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ExecPlanVO> refExecPlanDetail(@RequestParam(value="projectId") Long projectId, @RequestParam(value="planState", required=false) Integer planState, @RequestParam(value="startDate", required=false) Date startDate, @RequestParam(value="endDate", required=false) Date endDate) {
        ExecPlanVO vo = this.service.queryRefDetail(projectId, planState, startDate, endDate);
        return CommonResponse.success((String)"\u67e5\u8be2\u6e05\u5355\u53c2\u7167\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/getxml"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<HashMap> getxml(HttpServletRequest request, HttpServletResponse response) {
        return this.service.getxml(request);
    }

    @RequestMapping(value={"/exportxml"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportxml(HttpServletResponse response, @RequestBody XmlVO vo) {
        this.service.exportxml(response, vo);
    }

    @RequestMapping(value={"/pushExecPlan"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ExecPlanEntity> pushExecPlan(@RequestParam(value="id") Long id, @RequestParam(value="planState") Integer planState) {
        ExecPlanEntity vo = this.service.pushExecPlan(id, planState);
        return CommonResponse.success((String)"\u63a8\u9001\u6267\u884c\u8ba1\u5212\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/pushExecPlanRollBack"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ExecPlanEntity> pushExecPlanRollBack(@RequestParam(value="id") Long id, @RequestParam(value="planState") Integer planState) {
        ExecPlanEntity vo = this.service.pushExecPlanRollBack(id, planState);
        return CommonResponse.success((String)"\u63a8\u9001\u6267\u884c\u8ba1\u5212\u56de\u9000\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/validateProject"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> validateProject(@RequestParam(value="projectId") Long projectId, @RequestParam(value="billId", required=false) Long billId) {
        String msg = this.service.validateProject(projectId, billId);
        return CommonResponse.success((String)"\u6821\u9a8c\u6210\u529f\uff01", (Object)msg);
    }

    @RequestMapping(value={"/initTable"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> initTable() {
        String msg = this.service.initTable();
        return CommonResponse.success((String)"\u6821\u9a8c\u6210\u529f\uff01", (Object)msg);
    }

    @RequestMapping(value={"/referExecPlanDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ExecPlanVO> referExecPlanDetail(@RequestParam(value="projectId") Long projectId, @RequestParam(value="fillUserId") Long fillUserId) {
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        ExecPlanEntity entity = this.service.queryList(param).stream().findFirst().orElse(new ExecPlanEntity());
        if (entity.getId() == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6267\u884c\u8ba1\u5212\uff01");
        }
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"progress_id", (Object)entity.getId());
        ew.orderByAsc((Object)"tid");
        List detailList = this.detailService.list((Wrapper)ew);
        List actualList = detailList.stream().filter(x -> x.getActualStart() != null).collect(Collectors.toList());
        HashMap<Long, ExecPlanDetailEntity> preMap = new HashMap<Long, ExecPlanDetailEntity>();
        for (ExecPlanDetailEntity actual : actualList) {
            List preList = TreeUtils.getPreLinkList(detailList, actual.getStructCode());
            if (CollectionUtils.isEmpty(preList)) continue;
            preMap.putAll(preList.stream().collect(Collectors.toMap(x -> x.getId(), x -> x)));
        }
        List leafList = DetailListUtil.getLeafList(detailList);
        leafList = leafList.stream().filter(x -> new Integer(1).equals(x.getFinishState()) && StringUtils.isNotEmpty((CharSequence)x.getEmployeeId()) && x.getEmployeeId().contains(String.valueOf(fillUserId))).collect(Collectors.toList());
        leafList = leafList.stream().filter(x -> !preMap.containsKey(x.getId())).collect(Collectors.toList());
        Set structCodes = leafList.stream().flatMap(x -> SeparatorUtil.substringPre(x.getStructCode()).stream()).collect(Collectors.toSet());
        List result = detailList.stream().filter(x -> structCodes.contains(x.getStructCode())).collect(Collectors.toList());
        ExecPlanVO vo = (ExecPlanVO)BeanMapper.map((Object)((Object)entity), ExecPlanVO.class);
        if (CollectionUtils.isNotEmpty(result)) {
            ArrayList<ExecPlanDetailVO> detailVOList = new ArrayList<ExecPlanDetailVO>();
            for (ExecPlanDetailEntity detail : result) {
                detailVOList.add(ExecPlanDetailEntity.convertEntityToVo(detail));
            }
            vo.setProgressDetailList(TreeHelper2.list2Tree(detailVOList));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"/projectListRefer"})
    @ResponseBody
    public CommonResponse<JSONObject> projectListRefe(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        Set ids;
        QueryParam param = new QueryParam();
        param.setPageIndex(pageNumber.intValue());
        param.setPageSize(pageSize.intValue());
        param.setSearchText(searchText);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("projectTypeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("createTime", "desc");
        List<Object> list = this.service.list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List execIds = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
            QueryParam detailParam = new QueryParam();
            detailParam.getParams().put("progress_id", new Parameter("in", execIds));
            detailParam.getParams().put("employeeId", new Parameter("like", (Object)InvocationInfoProxy.getUserid()));
            List detailList = this.detailService.queryList(detailParam);
            Set ids2 = detailList.stream().map(x -> x.getProgressId()).collect(Collectors.toSet());
            list = CollectionUtils.isNotEmpty(ids2) ? list.stream().filter(x -> ids2.contains(x.getId())).collect(Collectors.toList()) : new ArrayList();
        }
        if (CollectionUtils.isNotEmpty(ids = list.stream().map(ExecPlanEntity::getProjectId).collect(Collectors.toSet()))) {
            param.getParams().put("id", new Parameter("in", ids));
        } else {
            param.getParams().put("id", new Parameter("eq", (Object)-1));
        }
        CommonResponse resp = this.projectApi.queryProjectArchivePage(param);
        if (!resp.isSuccess()) {
            return CommonResponse.error((String)resp.getMsg());
        }
        Page page = (Page)resp.getData();
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(page.getRecords());
        return CommonResponse.success((String)"\u9879\u76ee\u53c2\u7167\u67e5\u8be2\u6210\u529f\uff01", (Object)JSONObject.parseObject((String)JSON.toJSONString((Object)pageData)));
    }

    @RequestMapping(value={"/getWbsListById"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> getWbsListById(@RequestParam(value="projectId") Long projectId, @RequestParam(value="wbsId") Long wbsId) {
        CommonResponse resp = this.wbsApi.queryByProjectId(projectId);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        List wbsList = (List)resp.getData();
        ProjectWbsVO entity = wbsList.stream().filter(x -> wbsId.equals(x.getId())).findFirst().orElse(null);
        if (entity == null) {
            return CommonResponse.success((String)"\u672a\u67e5\u8be2\u5230\u8be5WBS\uff01", new ArrayList());
        }
        List<String> innerCodes = SeparatorUtil.substringPre(entity.getInnerCode(), ",");
        List result = wbsList.stream().filter(x -> innerCodes.contains(x.getInnerCode())).collect(Collectors.toList());
        List map = ResultAsTree.createTreeData((List)BeanMapper.mapList(result, Map.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)map);
    }

    @RequestMapping(value={"/referExecDetailWbs"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ExecPlanVO> referExecDetailWbs(@RequestParam(value="projectId") Long projectId, @RequestParam(value="fillUserId") Long fillUserId) {
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        ExecPlanEntity entity = this.service.queryList(param).stream().findFirst().orElse(new ExecPlanEntity());
        if (entity.getId() == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u603b\u8ba1\u5212\uff01");
        }
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"progress_id", (Object)entity.getId());
        ew.orderByAsc((Object)"tid");
        List detailList = this.detailService.list((Wrapper)ew);
        Map<Long, ExecPlanDetailEntity> detailMap = detailList.stream().filter(x -> StringUtils.isNotEmpty((CharSequence)x.getWbs())).collect(Collectors.toMap(x -> Long.valueOf(x.getWbs()), x -> x));
        List total = detailList.stream().filter(x -> StringUtils.isNotEmpty((CharSequence)x.getEmployeeId()) && x.getEmployeeId().contains(String.valueOf(fillUserId)) && PlanConstant.TOTAL_PLAN.equals(x.getPlanState())).collect(Collectors.toList());
        List wbsIds = total.stream().filter(x -> StringUtils.isNotEmpty((CharSequence)x.getWbs())).map(x -> Long.valueOf(x.getWbs())).collect(Collectors.toList());
        CommonResponse resp = this.wbsApi.queryByProjectId(projectId);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        List wbsList = (List)resp.getData();
        List codes = wbsList.stream().filter(x -> wbsIds.contains(x.getId())).map(x -> x.getInnerCode()).collect(Collectors.toList());
        Set innerCodes = codes.stream().flatMap(x -> SeparatorUtil.substringPre(x, ",").stream()).collect(Collectors.toSet());
        Set vos = wbsList.stream().filter(x -> innerCodes.contains(x.getInnerCode())).collect(Collectors.toSet());
        for (Object detail : wbsList) {
            for (String code : codes) {
                if (!detail.getInnerCode().startsWith(code)) continue;
                vos.add(detail);
            }
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (ProjectWbsVO wbs : vos) {
            Object vo = new ExecPlanDetailEntity();
            ((ProgressDetailEntity)((Object)vo)).setCode(wbs.getCode());
            ((ProgressDetailEntity)((Object)vo)).setDuration(1);
            if (detailMap.containsKey(wbs.getId())) {
                vo = detailMap.get(wbs.getId());
            }
            if (!PlanConstant.TOTAL_PLAN.equals(((ExecPlanDetailEntity)((Object)vo)).getPlanState())) {
                ((ExecPlanDetailEntity)((Object)vo)).setPlanState(null);
                ((ExecPlanDetailEntity)((Object)vo)).setPredictFinish(null);
                ((ProgressDetailEntity)((Object)vo)).setFixedDate(0);
            }
            vo.setId(wbs.getId());
            ((ProgressDetailEntity)((Object)vo)).setParentId(wbs.getParentId());
            ((ProgressDetailEntity)((Object)vo)).setName(wbs.getName());
            ((ExecPlanDetailEntity)((Object)vo)).setNodeLevel(wbs.getWbsType());
            ((ProgressDetailEntity)((Object)vo)).setProgressId(entity.getId());
            ((ProgressDetailEntity)((Object)vo)).setWbs(wbs.getId().toString());
            ((ProgressDetailEntity)((Object)vo)).setWbsParent(null != wbs.getParentId() ? wbs.getParentId().toString() : null);
            ((ProgressDetailEntity)((Object)vo)).setOutlineNumber(null != wbs.getParentId() ? wbs.getCode() : "0");
            if (new Integer(5).equals(wbs.getWbsType()) && detailMap.containsKey(((ProgressDetailEntity)((Object)vo)).getParentId())) {
                ExecPlanDetailEntity execPlanDetailEntity = detailMap.get(((ProgressDetailEntity)((Object)vo)).getParentId());
                ((ProgressDetailEntity)((Object)vo)).setStart(execPlanDetailEntity.getStart());
                ((ProgressDetailEntity)((Object)vo)).setFinish(execPlanDetailEntity.getFinish());
                ((ExecPlanDetailEntity)((Object)vo)).setPlanNum(execPlanDetailEntity.getPlanNum());
                ((ExecPlanDetailEntity)((Object)vo)).setEmployeeId(execPlanDetailEntity.getEmployeeId());
                ((ExecPlanDetailEntity)((Object)vo)).setEmployeeName(execPlanDetailEntity.getEmployeeName());
                ((ProgressDetailEntity)((Object)vo)).setDuration(execPlanDetailEntity.getDuration());
            }
            result.add(vo);
        }
        ExecPlanVO vo = (ExecPlanVO)BeanMapper.map((Object)((Object)entity), ExecPlanVO.class);
        if (CollectionUtils.isNotEmpty(result)) {
            List<ExecPlanDetailVO> detailVOList = new ArrayList();
            for (ExecPlanDetailEntity execPlanDetailEntity : result) {
                detailVOList.add(ExecPlanDetailEntity.convertEntityToVo(execPlanDetailEntity));
            }
            detailVOList = TreeHelper2.entrySort(detailVOList);
            List tree = TreeHelper2.list2Tree(detailVOList);
            TreeHelper2.resetOutlineNumber(tree, null);
            vo.setProgressDetailList(tree);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/referExecDetailWbsFill"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ExecPlanVO> referExecDetailWbsFill(@RequestParam(value="projectId") Long projectId, @RequestParam(value="fillUserId") Long fillUserId) {
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        ExecPlanEntity entity = this.service.queryList(param).stream().findFirst().orElse(new ExecPlanEntity());
        if (entity.getId() == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u603b\u8ba1\u5212\uff01");
        }
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"progress_id", (Object)entity.getId());
        ew.orderByAsc((Object)"tid");
        List detailList = this.detailService.list((Wrapper)ew);
        List leafList = DetailListUtil.getLeafList(detailList);
        leafList = leafList.stream().filter(x -> StringUtils.isNotEmpty((CharSequence)x.getEmployeeId()) && x.getEmployeeId().contains(String.valueOf(fillUserId))).collect(Collectors.toList());
        Set structCodes = leafList.stream().flatMap(x -> SeparatorUtil.substringPre(x.getStructCode()).stream()).collect(Collectors.toSet());
        List result = detailList.stream().filter(x -> structCodes.contains(x.getStructCode())).collect(Collectors.toList());
        CommonResponse resp = this.wbsApi.queryByProjectId(projectId);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        Map<String, ProjectWbsVO> map = ((List)resp.getData()).stream().collect(Collectors.toMap(x -> String.valueOf(x.getId()), x -> x));
        result = result.stream().filter(x -> map.keySet().contains(x.getWbs())).map(x -> {
            x.setName(((ProjectWbsVO)map.get(x.getWbs())).getName());
            return x;
        }).collect(Collectors.toList());
        ExecPlanVO vo = (ExecPlanVO)BeanMapper.map((Object)((Object)entity), ExecPlanVO.class);
        if (CollectionUtils.isNotEmpty(result)) {
            ArrayList<ExecPlanDetailVO> detailVOList = new ArrayList<ExecPlanDetailVO>();
            for (ExecPlanDetailEntity detail : result) {
                detailVOList.add(ExecPlanDetailEntity.convertEntityToVo(detail));
            }
            vo.setProgressDetailList(TreeHelper2.list2Tree(detailVOList));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/excelExportDetail"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportDetail(@RequestBody Long projectId, HttpServletResponse response) {
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"project_id", (Object)projectId);
        ExecPlanEntity entity = (ExecPlanEntity)((Object)this.service.getOne((Wrapper)ew));
        if (entity == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u9879\u76ee\u4e0b\u7684\u603b\u8ba1\u5212\uff01");
        }
        QueryWrapper dw = new QueryWrapper();
        dw.eq((Object)"progress_id", (Object)entity.getId());
        dw.orderByAsc((Object)"tid");
        List list = this.detailService.list((Wrapper)dw);
        List tree = TreeUtils.listToTree(list);
        TreeUtils.resetOutlineNumber(tree, null);
        list = TreeUtils.treeToList(tree);
        list = list.stream().sorted(Comparator.comparing(ProgressDetailEntity::getTid)).collect(Collectors.toList());
        JSONArray records = new JSONArray();
        for (int i = 0; i < list.size(); ++i) {
            ExecPlanDetailEntity vo = (ExecPlanDetailEntity)((Object)list.get(i));
            JSONObject obj = (JSONObject)JSONObject.toJSON((Object)((Object)vo));
            obj.put("index", (Object)(i + 1));
            obj.put("nodeLevel", PlanConstant.NODE_LEVEL.get(vo.getNodeLevel()));
            obj.put("unit", PlanConstant.UNIT.get(vo.getUnit()));
            records.add((Object)obj);
        }
        HashMap<String, JSONArray> beans = new HashMap<String, JSONArray>();
        beans.put("records", records);
        ExcelExport.getInstance().export("ExecPlanDetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryDetailByProject"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ExecPlanVO> queryDetailByProject(@RequestParam(value="projectId") Long projectId) {
        List entities = this.service.list((Wrapper)new LambdaQueryWrapper().eq(ExecPlanEntity::getProjectId, (Object)projectId));
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return CommonResponse.success((String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u6570\u636e\uff01");
        }
        ExecPlanVO vo = this.service.queryDetail(((ExecPlanEntity)((Object)entities.get(0))).getId());
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDeferDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONArray> queryDeferDetail(@RequestParam(value="orgId", required=false) Long orgId, @RequestParam(value="type", required=false) String type) {
        if (null == orgId) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        List orgIds = ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("orgId", new Parameter("in", orgIds));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List execList = this.service.queryList(param);
        if (CollectionUtils.isEmpty((Collection)execList)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a\uff01", (Object)new JSONArray());
        }
        Map<Long, ExecPlanEntity> map = execList.stream().collect(Collectors.toMap(x -> x.getId(), x -> x));
        QueryWrapper dw = new QueryWrapper();
        dw.in((Object)"progress_id", map.keySet());
        dw.eq((Object)"node_level", (Object)3);
        dw.lt((Object)"finish", (Object)DateUtil.formatSeconds(new Date()));
        dw.last(" and ifnull(finish_num, 0) < ifnull(plan_num, 0)");
        List list = this.detailService.list((Wrapper)dw);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a\uff01", (Object)new JSONArray());
        }
        JSONArray result = new JSONArray();
        if ("project".equals(type)) {
            Map<Long, List<ExecPlanDetailEntity>> group = list.stream().collect(Collectors.groupingBy(x -> x.getProgressId()));
            for (Long id : group.keySet()) {
                ExecPlanDetailVO vo = ExecPlanDetailEntity.convertEntityToVo(group.get(id).get(0));
                JSONObject obj = JSONObject.parseObject((String)JsonUtils.object2JsonStr((Object)vo));
                obj.put("projectName", (Object)map.get(id).getProjectName());
                obj.put("num", (Object)group.get(id).size());
                result.add((Object)obj);
            }
        } else {
            for (ExecPlanDetailEntity detail : list) {
                ExecPlanDetailVO vo = ExecPlanDetailEntity.convertEntityToVo(detail);
                vo.setDiffNum(ComputeUtil.safeSub((BigDecimal)vo.getPlanNum(), (BigDecimal)vo.getFinishNum()));
                vo.setDiffValue(ComputeUtil.toBigDecimal((Integer)DateUtil.getSubDay(new Date(), vo.getFinish())));
                JSONObject obj = JSONObject.parseObject((String)JsonUtils.object2JsonStr((Object)vo));
                obj.put("projectName", (Object)map.get(detail.getProgressId()).getProjectName());
                result.add((Object)obj);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)result);
    }

    @RequestMapping(value={"/myTaskReport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> myTaskReport(@RequestBody QueryParam param) {
        List execList;
        JSONObject page = new JSONObject();
        int current = param.getPageIndex();
        int size = param.getPageSize();
        page.put("current", (Object)current);
        page.put("size", (Object)size);
        page.put("records", new ArrayList());
        page.put("total", (Object)0);
        page.put("pages", (Object)0);
        param.getFuzzyFields().add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        boolean isAsc = true;
        if (param.getOrderMap().containsKey("Finish")) {
            if ("desc".equals(param.getOrderMap().get("Finish"))) {
                isAsc = false;
            }
            param.getOrderMap().remove("Finish");
        }
        if (CollectionUtils.isEmpty((Collection)(execList = this.service.queryList(param)))) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a\uff01", (Object)page);
        }
        Map<Long, ExecPlanEntity> map = execList.stream().collect(Collectors.toMap(x -> x.getId(), x -> x));
        QueryWrapper dw = new QueryWrapper();
        dw.in((Object)"progress_id", map.keySet());
        dw.eq((Object)"employee_id", (Object)InvocationInfoProxy.getUserid());
        dw.and(x -> (QueryWrapper)((QueryWrapper)((QueryWrapper)x.ne((Object)"finish_state", (Object)1)).or()).ne((Object)"involve_state", (Object)1));
        dw.orderBy(true, isAsc, (Object[])new String[]{"finish"});
        List list = this.detailService.list((Wrapper)dw);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a\uff01", (Object)page);
        }
        JSONArray array = new JSONArray();
        for (ExecPlanDetailEntity detail : list) {
            ExecPlanDetailVO vo = ExecPlanDetailEntity.convertEntityToVo(detail);
            JSONObject obj = JSONObject.parseObject((String)JsonUtils.object2JsonStr((Object)vo));
            obj.put("projectId", (Object)map.get(detail.getProgressId()).getProjectId());
            obj.put("projectName", (Object)map.get(detail.getProgressId()).getProjectName());
            obj.put("Start", (Object)DateUtil.formatDate(obj.getDate("Start")));
            obj.put("Finish", (Object)DateUtil.formatDate(obj.getDate("Finish")));
            obj.remove((Object)"children");
            array.add((Object)obj);
        }
        int total = array.size();
        JSONArray records = PageUtil.listToPage(array, current, size);
        int pages = PageUtil.getPages(total, size);
        page.put("records", (Object)records);
        page.put("total", (Object)total);
        page.put("pages", (Object)pages);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/progressReport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<ExecPlanDetailVO>> progressReport(@RequestBody QueryParam param) {
        if (!param.getParams().containsKey("projectId")) {
            return CommonResponse.error((String)"\u7f3a\u5c11\u9879\u76ee\u4e3b\u952e\uff01");
        }
        Long projectId = Long.valueOf(String.valueOf(((Parameter)param.getParams().get("projectId")).getValue()));
        List execList = this.service.queryList(param);
        if (CollectionUtils.isEmpty((Collection)execList)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a\uff01", new ArrayList());
        }
        QueryWrapper dw = new QueryWrapper();
        dw.eq((Object)"progress_id", (Object)((ExecPlanEntity)((Object)execList.get(0))).getId());
        dw.in((Object)"node_level", new ArrayList<Integer>(Arrays.asList(3, 4, 5)));
        dw.orderByAsc((Object)"tid");
        List list = this.detailService.list((Wrapper)dw);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a\uff01", new ArrayList());
        }
        CommonResponse resp = this.wbsApi.queryByProjectId(projectId);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        List wbsList = (List)resp.getData();
        Map<String, ProjectWbsVO> wbsMap = wbsList.stream().collect(Collectors.toMap(x -> String.valueOf(x.getId()), x -> x));
        ArrayList<ExecPlanDetailVO> detailList = new ArrayList<ExecPlanDetailVO>();
        for (ExecPlanDetailEntity detail : list) {
            ExecPlanDetailVO vo = ExecPlanDetailEntity.convertEntityToVo(detail);
            if (wbsMap.containsKey(vo.getWbs())) {
                vo.setMaterial(wbsMap.get(vo.getWbs()).getMaterial());
            }
            detailList.add(vo);
        }
        List result = TreeHelper2.list2Tree(detailList);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", result);
    }
}

