/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.progress.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jlprogress.progress.bean.DayFillDetailEntity;
import com.ejianc.business.jlprogress.progress.bean.DayFillEntity;
import com.ejianc.business.jlprogress.progress.bean.ExecPlanDetailEntity;
import com.ejianc.business.jlprogress.progress.bean.ExecPlanEntity;
import com.ejianc.business.jlprogress.progress.bean.ProgressDetailEntity;
import com.ejianc.business.jlprogress.progress.cons.PlanConstant;
import com.ejianc.business.jlprogress.progress.service.IDayFillDetailService;
import com.ejianc.business.jlprogress.progress.service.IDayFillService;
import com.ejianc.business.jlprogress.progress.service.IExecPlanDetailService;
import com.ejianc.business.jlprogress.progress.service.IExecPlanService;
import com.ejianc.business.jlprogress.progress.utils.TreeHelper2;
import com.ejianc.business.jlprogress.progress.vo.BaseDetailVO;
import com.ejianc.business.jlprogress.progress.vo.ExecPlanVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommonHelper {
    @Autowired
    private IExecPlanService execService;
    @Autowired
    private IExecPlanDetailService execDetailService;
    @Autowired
    private IDayFillService fillService;
    @Autowired
    private IDayFillDetailService fillDetailService;

    public static <T extends ProgressDetailEntity> Map<Long, Long> getIdMap(List<T> sourceList, List<ExecPlanDetailEntity> detailList) {
        Map<Long, String> sourceMap = sourceList.stream().collect(Collectors.toMap(x -> x.getId(), x -> x.getStructCode()));
        Map<String, Long> execMap = detailList.stream().collect(Collectors.toMap(x -> x.getStructCode(), x -> x.getId()));
        HashMap<Long, Long> idMap = new HashMap<Long, Long>();
        String task = null;
        for (Long id : sourceMap.keySet()) {
            task = sourceMap.get(id);
            if (execMap.containsKey(task)) {
                idMap.put(id, execMap.get(task));
                continue;
            }
            idMap.put(id, id);
        }
        idMap.put(-1L, -1L);
        return idMap;
    }

    public <T extends ProgressDetailEntity> List<Long> transferDelIds(List<T> sourceList, List<ExecPlanDetailEntity> detailList, Long projectId, Integer planState) {
        return this.transferDelIds(sourceList, detailList, projectId, planState, false);
    }

    public <T extends ProgressDetailEntity> List<Long> transferDelIds(List<T> sourceList, List<ExecPlanDetailEntity> detailList, Long projectId, Integer planState, Boolean isDel) {
        Long sourceId;
        ArrayList<Long> delIds = new ArrayList<Long>();
        Map<String, ProgressDetailEntity> sourceMap = sourceList.stream().collect(Collectors.toMap(ProgressDetailEntity::getStructCode, x -> x));
        Long l = sourceId = CollectionUtils.isNotEmpty(sourceList) ? ((ProgressDetailEntity)((Object)sourceList.get(0))).getProgressId() : null;
        if (CollectionUtils.isEmpty(detailList)) {
            return new ArrayList<Long>();
        }
        ArrayList<String> delTasks = new ArrayList<String>();
        List<ExecPlanDetailEntity> execList = detailList.stream().filter(x -> sourceId == null || x.getSourceId().equals(sourceId)).collect(Collectors.toList());
        execList.forEach(item -> {
            if ((isDel == null || isDel != false) == sourceMap.containsKey(item.getStructCode())) {
                delIds.add(item.getId());
                delTasks.add(item.getStructCode());
            }
        });
        if (CollectionUtils.isEmpty(delTasks)) {
            return new ArrayList<Long>();
        }
        List parentIds = detailList.stream().filter(x -> x.getParentId() != null && !Long.valueOf("-1").equals(x.getParentId()) && !delIds.contains(x.getId())).map(x -> x.getParentId()).collect(Collectors.toList());
        List parentList = detailList.stream().filter(x -> parentIds.contains(x.getId()) && delTasks.contains(x.getStructCode())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(parentList)) {
            StringBuilder msg = new StringBuilder();
            for (ExecPlanDetailEntity detail : parentList) {
                msg.append("\u3010" + detail.getName() + "\u3011\u5728\u6267\u884c\u8ba1\u5212\u4e2d" + detail.getOutlineNumber() + "\u5b58\u5728\u4e0b\u7ea7\u4efb\u52a1\uff01");
            }
            throw new BusinessException(msg.toString());
        }
        this.validateDayFill(projectId, delTasks);
        return delIds;
    }

    public <T extends ProgressDetailEntity> List<Long> transferDelIds(List<T> sourceList, Long projectId, Integer planState, Boolean isDel) {
        ExecPlanEntity data = (ExecPlanEntity)((Object)this.execService.getOne((Wrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectId)));
        if (data == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u9879\u76ee\u4e0b\u6267\u884c\u8ba1\u5212\uff01");
        }
        List detailList = this.execDetailService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"progress_id", (Object)data.getId())).orderByAsc((Object)"tid"));
        ArrayList<Long> delIds = new ArrayList<Long>();
        Map<String, ProgressDetailEntity> sourceMap = sourceList.stream().collect(Collectors.toMap(ProgressDetailEntity::getStructCode, x -> x));
        if (CollectionUtils.isEmpty((Collection)detailList)) {
            return new ArrayList<Long>();
        }
        ArrayList<String> delTasks = new ArrayList<String>();
        detailList.forEach(item -> {
            if (sourceMap.containsKey(item.getStructCode())) {
                delIds.add(item.getId());
                delTasks.add(item.getStructCode());
            }
        });
        if (CollectionUtils.isEmpty(delTasks)) {
            return new ArrayList<Long>();
        }
        List parentIds = detailList.stream().filter(x -> x.getParentId() != null && !Long.valueOf("-1").equals(x.getParentId()) && !delIds.contains(x.getId())).map(x -> x.getParentId()).collect(Collectors.toList());
        List parentList = detailList.stream().filter(x -> parentIds.contains(x.getId()) && delTasks.contains(x.getStructCode())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(parentList)) {
            StringBuilder msg = new StringBuilder();
            for (ExecPlanDetailEntity detail : parentList) {
                msg.append("\u3010" + detail.getName() + "\u3011\u5728\u6267\u884c\u8ba1\u5212\u4e2d" + detail.getOutlineNumber() + "\u5b58\u5728\u4e0b\u7ea7\u4efb\u52a1\uff01");
            }
            throw new BusinessException(msg.toString());
        }
        this.validateDayFill(projectId, delTasks);
        return delIds;
    }

    private void validateDayFill(Long projectId, List<String> delTasks) {
        List list = this.fillService.list((Wrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectId));
        List ids = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("progressId", new Parameter("in", ids));
        ComplexParam c4 = new ComplexParam();
        c4.setLogic("and");
        for (String structCode : delTasks) {
            ComplexParam c5 = new ComplexParam();
            c5.setLogic("or");
            c5.getParams().put("structCode", new Parameter("like_right", (Object)structCode));
            c4.getComplexParams().add(c5);
        }
        queryParam.getComplexParams().add(c4);
        queryParam.getParams().put("showState", new Parameter("eq", (Object)1));
        queryParam.getParams().put("percentComplete", new Parameter("gt", (Object)0));
        List detailList = this.fillDetailService.queryList(queryParam);
        HashSet codeList = new HashSet();
        for (DayFillDetailEntity detail : detailList) {
            codeList.addAll(delTasks.stream().filter(x -> detail.getStructCode().startsWith((String)x)).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isNotEmpty(codeList)) {
            Map<Long, DayFillEntity> map = list.stream().collect(Collectors.toMap(x -> x.getId(), x -> x));
            List dataList = this.fillDetailService.list((Wrapper)new QueryWrapper().in((Object)"progress_id", ids));
            Map<String, DayFillDetailEntity> detailMap = dataList.stream().collect(Collectors.toMap(x -> x.getStructCode(), x -> x, (v1, v2) -> v2));
            StringBuilder msg = new StringBuilder();
            for (String structCode : codeList) {
                if (!detailMap.containsKey(structCode)) continue;
                DayFillDetailEntity detail = detailMap.get(structCode);
                msg.append("\u3010" + detail.getName() + "\u3011\u5df2\u88ab\u65e5\u53cd\u9988\u3010" + map.get(detail.getProgressId()).getBillCode() + "\u3011\u4e2d");
                msg.append(detail.getOutlineNumber() + "\u5f15\u7528\uff01");
            }
            throw new BusinessException(msg.toString());
        }
    }

    public <T extends ProgressDetailEntity> List<String> transferUseIds(List<T> sourceList, Long projectId) {
        List list = this.fillService.list((Wrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectId));
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new ArrayList<String>();
        }
        List ids = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List structCodeList = sourceList.stream().map(ProgressDetailEntity::getStructCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(structCodeList)) {
            return new ArrayList<String>();
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("progressId", new Parameter("in", ids));
        ComplexParam c4 = new ComplexParam();
        c4.setLogic("and");
        for (String structCode : structCodeList) {
            ComplexParam c5 = new ComplexParam();
            c5.setLogic("or");
            c5.getParams().put("structCode", new Parameter("like_right", (Object)structCode));
            c4.getComplexParams().add(c5);
        }
        queryParam.getComplexParams().add(c4);
        queryParam.getParams().put("showState", new Parameter("eq", (Object)1));
        queryParam.getParams().put("actualStart", new Parameter("ne", null));
        List detailList = this.fillDetailService.queryList(queryParam);
        List delTasks = detailList.stream().map(ProgressDetailEntity::getStructCode).distinct().collect(Collectors.toList());
        HashSet codeList = new HashSet();
        for (String task : delTasks) {
            codeList.addAll(structCodeList.stream().filter(task::startsWith).collect(Collectors.toSet()));
        }
        return new ArrayList<String>(codeList);
    }

    public void getExecClandars(HashMap hashMap, Long projectId) {
        ExecPlanVO execPlan = this.execService.queryRefDetail(projectId, null, null, null);
        hashMap.put("Calendars", JSONObject.parseArray((String)execPlan.getCalendars(), Map.class));
        hashMap.put("CalendarUID", execPlan.getCalendarUid());
    }

    public static void main(String[] args) {
        Boolean flag = null;
        System.out.println(flag == false);
        ArrayList<ExecPlanDetailEntity> detailList = new ArrayList<ExecPlanDetailEntity>();
        ExecPlanDetailEntity vo1 = new ExecPlanDetailEntity();
        vo1.setId(1L);
        vo1.setParentId(-1L);
        vo1.setStructCode("1");
        vo1.setOutlineNumber("1");
        detailList.add(vo1);
        ExecPlanDetailEntity vo2 = new ExecPlanDetailEntity();
        vo2.setId(2L);
        vo2.setParentId(1L);
        vo2.setStructCode("1&&2");
        vo2.setOutlineNumber("1.1");
        detailList.add(vo2);
        ExecPlanDetailEntity vo3 = new ExecPlanDetailEntity();
        vo3.setId(3L);
        vo3.setParentId(2L);
        vo3.setStructCode("1&&2&&3");
        vo3.setOutlineNumber("1.1.1");
        detailList.add(vo3);
        ExecPlanDetailEntity vo4 = new ExecPlanDetailEntity();
        vo4.setId(4L);
        vo4.setParentId(3L);
        vo4.setStructCode("1&&2&&3&&4");
        vo4.setOutlineNumber("1.1.1.1");
        detailList.add(vo4);
        ArrayList<Long> delIds = new ArrayList<Long>();
        delIds.add(1L);
        ArrayList<String> delTasks = new ArrayList<String>();
        delTasks.add("1");
        List parentIds = detailList.stream().filter(x -> x.getParentId() != null && !Long.valueOf("-1").equals(x.getParentId()) && !delIds.contains(x.getId())).map(x -> x.getParentId()).collect(Collectors.toList());
        List parentTasks = detailList.stream().filter(x -> parentIds.contains(x.getId()) && delTasks.contains(x.getStructCode())).map(x -> x.getOutlineNumber()).collect(Collectors.toList());
        System.out.println("\u3010" + StringUtils.join(parentTasks, (String)"\uff0c") + "\u3011\u8ba1\u5212\u5df2\u88ab\u4e0b\u6e38\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
    }

    public <T extends BaseDetailVO> void validateEmployee(List<T> planDetailList) {
        List parentIds = planDetailList.stream().filter(e -> null != e.getParentTaskUID()).map(BaseDetailVO::getParentTaskUID).distinct().collect(Collectors.toList());
        List validatePlanDetailList = planDetailList.stream().filter(e -> !parentIds.contains(e.getUid())).collect(Collectors.toList());
        for (BaseDetailVO t : validatePlanDetailList) {
            Class<?> aClass = t.getClass();
            Object invoke = null;
            try {
                Method getEmployeeId = aClass.getDeclaredMethod("getEmployeeId", new Class[0]);
                invoke = getEmployeeId.invoke((Object)t, new Object[0]);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            if (null != invoke) continue;
            throw new BusinessException("\u60a8\u7684\u8ba1\u5212\u4e2d\u5b58\u5728\u672b\u7ea7\u4efb\u52a1\u672a\u5173\u8054\u8d23\u4efb\u4eba");
        }
    }

    public <T extends ProgressDetailEntity> void validateEmployeeEntity(List<T> planDetailList) {
        List parentIds = planDetailList.stream().filter(e -> null != e.getParentId()).map(ProgressDetailEntity::getParentId).distinct().collect(Collectors.toList());
        List validatePlanDetailList = planDetailList.stream().filter(e -> !parentIds.contains(e.getId())).collect(Collectors.toList());
        for (ProgressDetailEntity t : validatePlanDetailList) {
            Class<?> aClass = ((Object)((Object)t)).getClass();
            Object invoke = null;
            try {
                Method getEmployeeId = aClass.getDeclaredMethod("getEmployeeId", new Class[0]);
                invoke = getEmployeeId.invoke((Object)t, new Object[0]);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            if (null != invoke) continue;
            throw new BusinessException("\u60a8\u7684\u8ba1\u5212\u4e2d\u5b58\u5728\u672b\u7ea7\u4efb\u52a1\u672a\u5173\u8054\u8d23\u4efb\u4eba");
        }
    }

    public <T extends BaseDetailVO> void validatePredecessorLink(List<T> planDetailList, Long projectId) {
        ExecPlanEntity data = (ExecPlanEntity)((Object)this.execService.getOne((Wrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectId)));
        if (data == null) {
            return;
        }
        List detailList = this.execDetailService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"progress_id", (Object)data.getId())).orderByAsc((Object)"tid"));
        Map<String, ExecPlanDetailEntity> detailMap = detailList.stream().collect(Collectors.toMap(x -> x.getStructCode(), x -> x));
        List<T> sourceList = TreeHelper2.tree2List(planDetailList);
        List parentIds = sourceList.stream().filter(e -> null != e.getParentTaskUID()).map(BaseDetailVO::getParentTaskUID).distinct().collect(Collectors.toList());
        List validateList = sourceList.stream().filter(e -> parentIds.contains(e.getUid())).collect(Collectors.toList());
        StringBuilder msg = new StringBuilder();
        HashSet<ExecPlanDetailEntity> errorList = new HashSet<ExecPlanDetailEntity>();
        for (BaseDetailVO t : validateList) {
            ExecPlanDetailEntity detail;
            String structCode = String.valueOf(CommonHelper.getValue(t, "structCode"));
            if (!detailMap.containsKey(structCode) || StringUtils.isEmpty((CharSequence)(detail = detailMap.get(structCode)).getPredecessorLink())) continue;
            JSONArray predecessorLink = JSON.parseArray((String)detail.getPredecessorLink());
            for (Object o : predecessorLink) {
                JSONObject obj = (JSONObject)o;
                if (obj.getInteger("Type") != 0 && obj.getInteger("Type") != 2) continue;
                errorList.add(detail);
            }
        }
        if (CollectionUtils.isNotEmpty(errorList)) {
            for (ExecPlanDetailEntity detail : errorList) {
                msg.append("\u3010" + detail.getName() + "\u3011\u5728\u6267\u884c\u8ba1\u5212\u4e2d" + detail.getOutlineNumber() + "\u524d\u7f6e\u4efb\u52a1\u8bbe\u7f6e\u4e3aFF\u6216\u8005SF\uff0c");
            }
            throw new BusinessException(msg + "\u4e0d\u5141\u8bb8\u5206\u89e3\u4e0b\u7ea7\u4efb\u52a1\uff01");
        }
    }

    public static <T extends BaseDetailVO> Integer tansferChange(List<T> tasks) {
        List<BaseDetailVO> list = TreeHelper2.tree2List(tasks);
        for (BaseDetailVO t : list) {
            Object obj;
            String changeType = String.valueOf(CommonHelper.getValue(t, "changeType"));
            if (!StringUtils.isNotEmpty((CharSequence)changeType) || !changeType.contains("11") && !changeType.contains("12") || (obj = CommonHelper.getValue(t, "nodeLevel")) == null) continue;
            Integer nodeLevel = Integer.valueOf(String.valueOf(obj));
            if (PlanConstant.LEVEL_FIRST.equals(nodeLevel)) {
                return 1;
            }
            if (!PlanConstant.LEVEL_SECOND.equals(nodeLevel)) continue;
            return 2;
        }
        return 0;
    }

    private static <T> Object getValue(T t, String fieldName) {
        for (Class<?> clazz = t.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                Method m = clazz.getDeclaredMethod("get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1), null);
                try {
                    return m.invoke(t, (Object[])null);
                }
                catch (IllegalAccessException e) {
                    throw new BusinessException("\u7c7b\u3010" + clazz + "\u3011\u7684\u5b57\u6bb5\u3010" + fieldName + "\u3011\u7684get\u65b9\u6cd5\u9700\u8981\u8bbe\u7f6e\u6210public\u5c5e\u6027\uff01");
                }
                catch (InvocationTargetException e) {
                    throw new BusinessException("\u7c7b\u3010" + clazz + "\u3011\u7684\u5b57\u6bb5\u3010" + fieldName + "\u3011\u7684get\u65b9\u6cd5\u8c03\u7528\u5931\u8d25\uff01");
                }
            }
            catch (Exception exception) {
                continue;
            }
        }
        return null;
    }

    public static boolean isInteger(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        return pattern.matcher(str).matches();
    }
}

