/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.progress.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.ejianc.business.jlprogress.progress.bean.YearPlanEntity;
import com.ejianc.business.jlprogress.progress.cons.PlanConstant;
import com.ejianc.business.jlprogress.progress.handler.CommonHelper;
import com.ejianc.business.jlprogress.progress.service.IExecPlanService;
import com.ejianc.business.jlprogress.progress.service.IYearPlanDetailService;
import com.ejianc.business.jlprogress.progress.service.IYearPlanService;
import com.ejianc.business.jlprogress.progress.utils.DateUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="yearPlan")
public class YearPlanBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IYearPlanService yearPlanService;
    @Autowired
    private IExecPlanService execPlanService;
    @Autowired
    private CommonHelper commonHelper;
    @Autowired
    private IYearPlanDetailService detailService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        List detailList = this.detailService.list((Wrapper)new QueryWrapper().eq((Object)"progress_id", (Object)billId));
        this.commonHelper.validateEmployeeEntity(detailList);
        LambdaUpdateWrapper lambd = new LambdaUpdateWrapper();
        lambd.set(YearPlanEntity::getCommitTime, (Object)new Date());
        lambd.eq(BaseEntity::getId, (Object)billId);
        this.yearPlanService.update((Wrapper)lambd);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        List detailList = this.detailService.list((Wrapper)new QueryWrapper().eq((Object)"progress_id", (Object)billId));
        this.commonHelper.validateEmployeeEntity(detailList);
        if (BillStateEnum.UNCOMMITED_STATE.getBillStateCode() == state || BillStateEnum.UNAPPROVED.getBillStateCode() == state) {
            LambdaUpdateWrapper lambd = new LambdaUpdateWrapper();
            lambd.set(YearPlanEntity::getCommitTime, (Object)new Date());
            lambd.eq(BaseEntity::getId, (Object)billId);
            this.yearPlanService.update((Wrapper)lambd);
        }
        YearPlanEntity planEntity = (YearPlanEntity)((Object)this.yearPlanService.selectById(billId));
        LambdaUpdateWrapper lambd = new LambdaUpdateWrapper();
        lambd.set(YearPlanEntity::getApprovedTime, (Object)new Date());
        if (planEntity.getStartDate() != null) {
            Integer subDay = DateUtil.getSubDay(new Date(), planEntity.getPlanBeginDate());
            lambd.set(YearPlanEntity::getFinishFlag, (Object)subDay);
        }
        if (state == 1) {
            lambd.set(YearPlanEntity::getCommitTime, (Object)new Date());
        }
        lambd.eq(BaseEntity::getId, (Object)billId);
        this.yearPlanService.update((Wrapper)lambd);
        this.logger.info("\u5e74\u8ba1\u5212\u5f00\u59cb\u63a8\u9001\u6267\u884c\u8ba1\u5212 bill-{}", (Object)billId);
        this.execPlanService.pushExecPlan(billId, PlanConstant.YEAR_PLAN);
        if (ObjectUtils.isNotEmpty((Object)((Object)planEntity))) {
            this.yearPlanService.sendMsgToInstallPerson(planEntity);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        YearPlanEntity planEntity = (YearPlanEntity)((Object)this.yearPlanService.selectById(billId));
        if (planEntity.getChangeStatus() != PlanConstant.CHANGE_NO) {
            return CommonResponse.error((String)"\u8ba1\u5212\u5b58\u5728\u53d8\u66f4\u5355\uff0c\u6682\u4e0d\u652f\u6301\u56de\u9000\u529f\u80fd!");
        }
        this.execPlanService.validateProject(planEntity.getProjectId(), planEntity.getId(), planEntity.getFillUserId());
        LambdaUpdateWrapper lambd = new LambdaUpdateWrapper();
        lambd.set(YearPlanEntity::getCommitTime, null);
        lambd.set(YearPlanEntity::getApprovedTime, null);
        lambd.set(YearPlanEntity::getFinishFlag, null);
        lambd.eq(BaseEntity::getId, (Object)billId);
        this.yearPlanService.update((Wrapper)lambd);
        this.logger.info("\u5e74\u8ba1\u5212\u5f00\u59cb\u64a4\u56de\u63a8\u9001\u6267\u884c\u8ba1\u5212 bill-{}", (Object)billId);
        this.execPlanService.pushExecPlanRollBack(billId, PlanConstant.YEAR_PLAN);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

