/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.factory.controller;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlprogress.factory.bean.FactEquipmentEntity;
import com.ejianc.business.jlprogress.factory.service.IFactEquipmentService;
import com.ejianc.business.jlprogress.factory.vo.FactEquipmentDetailVO;
import com.ejianc.business.jlprogress.factory.vo.FactEquipmentVO;
import com.ejianc.business.jlprogress.progress.utils.DateUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"factEquipment"})
public class FactEquipmentController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "FACT_EQUIP_CODE";
    @Autowired
    private IFactEquipmentService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<FactEquipmentVO> saveOrUpdate(@RequestBody FactEquipmentVO saveOrUpdateVO) {
        FactEquipmentEntity entity = (FactEquipmentEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), FactEquipmentEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        FactEquipmentVO vo = (FactEquipmentVO)((Object)BeanMapper.map((Object)((Object)entity), FactEquipmentVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FactEquipmentVO> queryDetail(Long id) {
        FactEquipmentEntity entity = (FactEquipmentEntity)((Object)this.service.selectById(id));
        FactEquipmentVO vo = (FactEquipmentVO)((Object)BeanMapper.map((Object)((Object)entity), FactEquipmentVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FactEquipmentVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (FactEquipmentVO factEquipmentVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<FactEquipmentVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FactEquipmentVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("FactEquipment-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refFactEquipmentData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<FactEquipmentVO>> refFactEquipmentData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FactEquipmentVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"fact-equipment-import.xlsx", (String)"\u5bfc\u5165\u6a21\u677f");
    }

    @PostMapping(value={"/excelImport"})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        ArrayList<FactEquipmentDetailVO> successList = new ArrayList<FactEquipmentDetailVO>();
        ArrayList<FactEquipmentDetailVO> errorList = new ArrayList<FactEquipmentDetailVO>();
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            HashMap codeMapCache = new HashMap();
            FactEquipmentDetailVO importVo = null;
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                importVo = new FactEquipmentDetailVO();
                importVo.setId(IdWorker.getId());
                importVo.setCode((String)datas.get(0));
                importVo.setName((String)datas.get(1));
                importVo.setSpec((String)datas.get(2));
                importVo.setFactory((String)datas.get(3));
                importVo.setOutCode((String)datas.get(4));
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5)))) {
                    if (DateUtil.grepDate((String)datas.get(5))) {
                        importVo.setOutDate(DateUtil.Date((String)datas.get(5)));
                    } else {
                        importVo.setErrorMsg("\u51fa\u573a\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorList.add(importVo);
                        continue;
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6)))) {
                    if (DateUtil.grepDate((String)datas.get(6))) {
                        importVo.setBuyDate(DateUtil.Date((String)datas.get(6)));
                    } else {
                        importVo.setErrorMsg("\u8d2d\u7f6e\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorList.add(importVo);
                        continue;
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7)))) {
                    if (!TextUtils.isEmpty((CharSequence)((CharSequence)datas.get(7))) && !NumberUtil.isNumber((String)((String)datas.get(7)))) {
                        importVo.setErrorMsg("\u8bbe\u5907\u539f\u503c(\u4e07)\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorList.add(importVo);
                        continue;
                    }
                    importVo.setFirstMny(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7))) ? new BigDecimal((String)datas.get(7)) : null);
                }
                importVo.setEquipState((String)datas.get(8));
                importVo.setPrecisionLevl((String)datas.get(9));
                importVo.setCategory((String)datas.get(10));
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(11)))) {
                    if (!TextUtils.isEmpty((CharSequence)((CharSequence)datas.get(11))) && !NumberUtil.isNumber((String)((String)datas.get(11)))) {
                        importVo.setErrorMsg("\u529f\u7387(kw)\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorList.add(importVo);
                        continue;
                    }
                    importVo.setPower(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(11))) ? new BigDecimal((String)datas.get(11)) : null);
                }
                importVo.setMemo((String)datas.get(12));
                successList.add(importVo);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }
}

