/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.factory.controller;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlprogress.factory.bean.FactGoldEntity;
import com.ejianc.business.jlprogress.factory.service.IFactGoldService;
import com.ejianc.business.jlprogress.factory.vo.FactGoldDetailVO;
import com.ejianc.business.jlprogress.factory.vo.FactGoldVO;
import com.ejianc.business.jlprogress.progress.utils.DateUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"factGold"})
public class FactGoldController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "FACT_GOLD_CODE";
    @Autowired
    private IFactGoldService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<FactGoldVO> saveOrUpdate(@RequestBody FactGoldVO saveOrUpdateVO) {
        FactGoldEntity entity = (FactGoldEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), FactGoldEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        FactGoldVO vo = (FactGoldVO)((Object)BeanMapper.map((Object)((Object)entity), FactGoldVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FactGoldVO> queryDetail(Long id) {
        FactGoldEntity entity = (FactGoldEntity)((Object)this.service.selectById(id));
        FactGoldVO vo = (FactGoldVO)((Object)BeanMapper.map((Object)((Object)entity), FactGoldVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FactGoldVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (FactGoldVO factGoldVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<FactGoldVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FactGoldVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("FactGold-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refFactGoldData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<FactGoldVO>> refFactGoldData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FactGoldVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"fact-gold-import.xlsx", (String)"\u5bfc\u5165\u6a21\u677f");
    }

    @PostMapping(value={"/excelImport"})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        ArrayList<FactGoldDetailVO> successList = new ArrayList<FactGoldDetailVO>();
        ArrayList<FactGoldDetailVO> errorList = new ArrayList<FactGoldDetailVO>();
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            HashMap codeMapCache = new HashMap();
            FactGoldDetailVO importVo = null;
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                importVo = new FactGoldDetailVO();
                importVo.setId(IdWorker.getId());
                importVo.setFactory((String)datas.get(1));
                importVo.setName((String)datas.get(2));
                importVo.setBeforeChange((String)datas.get(3));
                importVo.setAfterChange((String)datas.get(4));
                importVo.setCategory((String)datas.get(5));
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    if (DateUtil.grepDate((String)datas.get(0))) {
                        importVo.setBillDate(DateUtil.Date((String)datas.get(0)));
                    } else {
                        importVo.setErrorMsg("\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorList.add(importVo);
                        continue;
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6)))) {
                    if (!TextUtils.isEmpty((CharSequence)((CharSequence)datas.get(6))) && !NumberUtil.isNumber((String)((String)datas.get(6)))) {
                        importVo.setErrorMsg("\u8282\u7ea6\u6210\u672c\u91d1\u989d\uff08\u5143\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorList.add(importVo);
                        continue;
                    }
                    importVo.setCostMny(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6))) ? new BigDecimal((String)datas.get(6)) : null);
                }
                importVo.setSigner((String)datas.get(7));
                importVo.setMemo((String)datas.get(8));
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9)))) {
                    if (!TextUtils.isEmpty((CharSequence)((CharSequence)datas.get(9))) && !NumberUtil.isNumber((String)((String)datas.get(9)))) {
                        importVo.setErrorMsg("\u5956\u52b1\u91d1\u989d\uff08\u5143\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorList.add(importVo);
                        continue;
                    }
                    importVo.setRewardMny(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9))) ? new BigDecimal((String)datas.get(9)) : null);
                }
                successList.add(importVo);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }
}

