/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.labor.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlprogress.labor.bean.MaterialPurchaseEntity;
import com.ejianc.business.jlprogress.labor.service.IMaterialPurchaseDetailsService;
import com.ejianc.business.jlprogress.labor.service.IMaterialPurchaseService;
import com.ejianc.business.jlprogress.labor.vo.MaterialPurchaseDetailsVO;
import com.ejianc.business.jlprogress.labor.vo.MaterialPurchaseVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"materialPurchase"})
public class MaterialPurchaseController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IShareMaterialApi iShareMaterialApi;
    @Autowired
    private IMaterialPurchaseDetailsService detailsService;
    private static final String BILL_CODE = "Material_Purchase";
    @Autowired
    private IMaterialPurchaseService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MaterialPurchaseVO> saveOrUpdate(@RequestBody MaterialPurchaseVO saveOrUpdateVO) {
        MaterialPurchaseEntity entity = (MaterialPurchaseEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MaterialPurchaseEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        MaterialPurchaseVO vo = (MaterialPurchaseVO)BeanMapper.map((Object)((Object)entity), MaterialPurchaseVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialPurchaseVO> queryDetail(Long id) {
        MaterialPurchaseEntity entity = (MaterialPurchaseEntity)((Object)this.service.selectById(id));
        MaterialPurchaseVO vo = (MaterialPurchaseVO)BeanMapper.map((Object)((Object)entity), MaterialPurchaseVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialPurchaseVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MaterialPurchaseVO materialPurchaseVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MaterialPurchaseVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        String startOfMonth = "";
        String endOfMonth = "";
        if (param.getParams().containsKey("month")) {
            String checkMonth = ((Parameter)param.getParams().get("month")).getValue().toString();
            LocalDate date = LocalDate.parse(checkMonth + "-01", DateTimeFormatter.ISO_LOCAL_DATE);
            startOfMonth = String.valueOf(date.withDayOfMonth(1));
            endOfMonth = String.valueOf(date.withDayOfMonth(date.lengthOfMonth()));
            param.getParams().remove("month");
            param.getParams().put("fillInDate", new Parameter("between", (Object)(startOfMonth + "," + endOfMonth)));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialPurchaseVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MaterialPurchase-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refMaterialPurchaseData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MaterialPurchaseVO>> refMaterialPurchaseData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialPurchaseVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/downloadInfo"})
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"MaterialPurchaseDetails-import.xlsx", (String)"\u5927\u5b97\u7269\u8d44\u8bbe\u5907\u7533\u8bf7\u8868\u660e\u7ec6\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<MaterialPurchaseDetailsVO> successList = new ArrayList<MaterialPurchaseDetailsVO>();
        ArrayList<MaterialPurchaseDetailsVO> errorList = new ArrayList<MaterialPurchaseDetailsVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                MaterialPurchaseDetailsVO detailVO = new MaterialPurchaseDetailsVO();
                detailVO.setId(Long.valueOf(IdWorker.getId()));
                detailVO.setName((String)datas.get(0));
                detailVO.setSpecModel((String)datas.get(1));
                detailVO.setUnit((String)datas.get(2));
                detailVO.setDetailMemo((String)datas.get(6));
                successList.add(detailVO);
                try {
                    BigDecimal num = BigDecimal.valueOf(Double.parseDouble((String)datas.get(3)));
                    detailVO.setNum(num);
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u9700\u7528\u6570\u91cf\u683c\u5f0f\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    BigDecimal referenceMny = BigDecimal.valueOf(Double.parseDouble((String)datas.get(4)));
                    detailVO.setReferenceMny(referenceMny);
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u53c2\u8003\u4ef7\u683c\u683c\u5f0f\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    BigDecimal subtotal = BigDecimal.valueOf(Double.parseDouble((String)datas.get(5)));
                    detailVO.setSubtotal(subtotal);
                    continue;
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u5c0f\u8ba1\u683c\u5f0f\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/reportQueryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> reportQueryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("specModel");
        fuzzyFields.add("unit");
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<Object> list = new ArrayList();
        String startOfMonth = "";
        String endOfMonth = "";
        if (param.getParams().containsKey("month")) {
            String checkMonth = ((Parameter)param.getParams().get("month")).getValue().toString();
            LocalDate date = LocalDate.parse(checkMonth + "-01", DateTimeFormatter.ISO_LOCAL_DATE);
            startOfMonth = String.valueOf(date.withDayOfMonth(1));
            endOfMonth = String.valueOf(date.withDayOfMonth(date.lengthOfMonth()));
            param.getParams().remove("month");
            param.getParams().put("fillInDate", new Parameter("between", (Object)(startOfMonth + "," + endOfMonth)));
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        list = this.detailsService.materialPurchaseReport(page, wrapper);
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/excelReportExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelReportExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("specModel");
        fuzzyFields.add("unit");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<Object> list = new ArrayList();
        String startOfMonth = "";
        String endOfMonth = "";
        if (param.getParams().containsKey("month")) {
            String checkMonth = ((Parameter)param.getParams().get("month")).getValue().toString();
            LocalDate date = LocalDate.parse(checkMonth + "-01", DateTimeFormatter.ISO_LOCAL_DATE);
            startOfMonth = String.valueOf(date.withDayOfMonth(1));
            endOfMonth = String.valueOf(date.withDayOfMonth(date.lengthOfMonth()));
            param.getParams().remove("month");
            param.getParams().put("fillInDate", new Parameter("between", (Object)(startOfMonth + "," + endOfMonth)));
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        list = this.detailsService.materialPurchaseReport(page, wrapper);
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("MaterialPurchaseReport-export.xlsx", beans, response);
    }
}

