/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.labor.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlprogress.labor.bean.ProjectTeamEntity;
import com.ejianc.business.jlprogress.labor.bean.WorkRecordEntity;
import com.ejianc.business.jlprogress.labor.enums.CheckPhotoFlagEnum;
import com.ejianc.business.jlprogress.labor.enums.LastFlagEnum;
import com.ejianc.business.jlprogress.labor.service.IProjectTeamService;
import com.ejianc.business.jlprogress.labor.service.IWorkRecordService;
import com.ejianc.business.jlprogress.labor.vo.ProjectRecordVO;
import com.ejianc.business.jlprogress.labor.vo.WorkRecordVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.consts.ArchiveProjectStatusEnum;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"workRecord"})
public class WorkRecordController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String WORK_RECORD_CONTRACT_SOURCE_TYPE = "workRecord001";
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IWorkRecordService service;
    @Autowired
    private IProjectTeamService projectTeamService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProjectArchiveApi projectApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IProjectArchiveApi projectArchiveApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<WorkRecordVO> saveOrUpdate(@RequestBody WorkRecordVO saveOrUpdateVO) {
        WorkRecordVO recordVO = this.service.updateWorkRecord(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)recordVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WorkRecordVO> queryDetail(Long id) {
        WorkRecordEntity entity = (WorkRecordEntity)((Object)this.service.selectById(id));
        WorkRecordVO vo = (WorkRecordVO)BeanMapper.map((Object)((Object)entity), WorkRecordVO.class);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        if (entity.getPhone() != null) {
            queryWrapper.eq((Object)"phone", (Object)entity.getPhone());
        }
        if (entity.getIdCard() != null) {
            queryWrapper.eq((Object)"id_card", (Object)entity.getIdCard());
        }
        queryWrapper.orderByDesc((Object)"enter_date");
        List list = this.service.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List recordVOS = BeanMapper.mapList((Iterable)list, WorkRecordVO.class);
            JSONObject fileParam = new JSONObject();
            List sourceIds = recordVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
            fileParam.put("sourceIds", sourceIds);
            JSONArray sourceTypeArr = new JSONArray();
            sourceTypeArr.add((Object)WORK_RECORD_CONTRACT_SOURCE_TYPE);
            fileParam.put("sourceTypeList", (Object)JSONObject.toJSONString((Object)sourceTypeArr));
            CommonResponse listCommonResponse = this.attachmentApi.queryAllBySourceIdList(fileParam);
            List fileData = (List)listCommonResponse.getData();
            if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)fileData)) {
                for (WorkRecordVO workRecordVO : recordVOS) {
                    List collect = fileData.stream().filter(u -> u.getSourceId().equals(workRecordVO.getId())).collect(Collectors.toList());
                    this.logger.info(JSONObject.toJSONString(collect));
                    workRecordVO.setSubContractFileList(collect);
                }
            }
            vo.setRecordList(recordVOS);
        }
        vo.setBillState(Integer.valueOf(0));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WorkRecordVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (WorkRecordVO workRecordVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<WorkRecordVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("projectId") && !param.getParams().containsKey("teamId")) {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        if (param.getParams().containsKey("teamId")) {
            fuzzyFields.add("team_id");
            Parameter teamId = (Parameter)param.getParams().get("teamId");
            param.getParams().put("teamId", new Parameter("like", teamId.getValue()));
        }
        param.getOrderMap().putIfAbsent("enter_date", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WorkRecordVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryProjectList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProjectRecordVO>> queryProjectList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        String startDate = "";
        String endDate = "";
        List<Object> RecordVOList = new ArrayList();
        ArrayList resList = new ArrayList();
        if (param.getParams().containsKey("month")) {
            String month = ((Parameter)param.getParams().get("month")).getValue().toString();
            YearMonth yearMonth = YearMonth.of((int)Integer.valueOf(month.substring(0, 4)), Integer.valueOf(month.substring(5, 7)));
            int lastDay = yearMonth.lengthOfMonth();
            startDate = month + "-01";
            endDate = month + "-" + lastDay;
            param.getParams().remove("month");
            RecordVOList = this.service.queryProjectList(startDate, endDate);
        } else {
            Date currentDate = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String formattedDate = dateFormat.format(currentDate);
            startDate = "2010-01-01";
            endDate = formattedDate;
            param.getParams().remove("month");
            RecordVOList = this.service.queryProjectList(startDate, endDate);
        }
        param.getParams().put("projectStatus", new Parameter("not_in", Arrays.asList(1, 2, 3)));
        CommonResponse projectResponse = this.projectArchiveApi.queryProjectArchivePage(param);
        if (!projectResponse.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u83b7\u53d6\u9879\u76ee\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        List records = ((Page)projectResponse.getData()).getRecords();
        HashMap map = new HashMap();
        if (CollectionUtils.isNotEmpty(RecordVOList)) {
            RecordVOList.forEach(e -> map.put(e.getId(), e));
        }
        if (CollectionUtils.isNotEmpty((Collection)records)) {
            records.forEach(e -> {
                ProjectRecordVO projectRecordVO = new ProjectRecordVO();
                projectRecordVO.setId(e.getId());
                projectRecordVO.setProjectStatus(Integer.valueOf(Integer.parseInt(e.getProjectStatus())));
                projectRecordVO.setName(e.getName());
                projectRecordVO.setOrgId(e.getProjectDepartmentId());
                projectRecordVO.setNums(Integer.valueOf(map.get(e.getId()) == null ? 0 : ((ProjectRecordVO)map.get(e.getId())).getNums()));
                projectRecordVO.setZcDay(Integer.valueOf(map.get(e.getId()) == null ? 0 : ((ProjectRecordVO)map.get(e.getId())).getZcDay()));
                resList.add(projectRecordVO);
            });
        }
        Page pageData = new Page(((Page)projectResponse.getData()).getCurrent(), ((Page)projectResponse.getData()).getSize(), ((Page)projectResponse.getData()).getTotal());
        pageData.setRecords(resList);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryZcList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<WorkRecordVO>> queryZcList(Long projectId, String month) {
        String startDate = "";
        String endDate = "";
        if (StringUtils.isNotEmpty((CharSequence)month)) {
            YearMonth yearMonth = YearMonth.of((int)Integer.valueOf(month.substring(0, 4)), Integer.valueOf(month.substring(5, 7)));
            int lastDay = yearMonth.lengthOfMonth();
            startDate = month + "-01";
            endDate = month + "-" + lastDay;
        } else {
            Date currentDate = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String formattedDate = dateFormat.format(currentDate);
            startDate = "2010-01-01";
            endDate = formattedDate;
        }
        return CommonResponse.success(this.service.queryZcList(projectId, startDate, endDate));
    }

    @RequestMapping(value={"/zcExcelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void zcExcelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        String startDate = "";
        String endDate = "";
        List<Object> RecordVOList = new ArrayList();
        ArrayList resList = new ArrayList();
        if (param.getParams().containsKey("month")) {
            String month = ((Parameter)param.getParams().get("month")).getValue().toString();
            YearMonth yearMonth = YearMonth.of((int)Integer.valueOf(month.substring(0, 4)), Integer.valueOf(month.substring(5, 7)));
            int lastDay = yearMonth.lengthOfMonth();
            startDate = month + "-01";
            endDate = month + "-" + lastDay;
            param.getParams().remove("month");
            RecordVOList = this.service.queryProjectList(startDate, endDate);
        } else {
            Date currentDate = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String formattedDate = dateFormat.format(currentDate);
            startDate = "2010-01-01";
            endDate = formattedDate;
            param.getParams().remove("month");
            RecordVOList = this.service.queryProjectList(startDate, endDate);
        }
        HashMap map = new HashMap();
        if (CollectionUtils.isNotEmpty(RecordVOList)) {
            RecordVOList.forEach(e -> map.put(e.getId(), e));
        }
        param.getParams().put("projectStatus", new Parameter("not_in", Arrays.asList(1, 2, 3)));
        CommonResponse projectResponse = this.projectArchiveApi.queryProjectArchivePage(param);
        if (!projectResponse.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u83b7\u53d6\u9879\u76ee\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        List records = ((Page)projectResponse.getData()).getRecords();
        if (CollectionUtils.isNotEmpty((Collection)records)) {
            records.forEach(e -> {
                ProjectRecordVO projectRecordVO = new ProjectRecordVO();
                projectRecordVO.setId(e.getId());
                projectRecordVO.setProjectStatus(Integer.valueOf(Integer.parseInt(e.getProjectStatus())));
                projectRecordVO.setProjectStatusName(ArchiveProjectStatusEnum.getByCode((String)e.getProjectStatus().toString()).getName());
                projectRecordVO.setName(e.getName());
                projectRecordVO.setOrgId(e.getProjectDepartmentId());
                projectRecordVO.setNums(Integer.valueOf(map.get(e.getId()) == null ? 0 : ((ProjectRecordVO)map.get(e.getId())).getNums()));
                projectRecordVO.setZcDay(Integer.valueOf(map.get(e.getId()) == null ? 0 : ((ProjectRecordVO)map.get(e.getId())).getZcDay()));
                resList.add(projectRecordVO);
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", resList);
        ExcelExport.getInstance().export("ZcRecord-export.xlsx", beans, response);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<IPage<WorkRecordVO>> iPageCommonResponse = this.queryList(param);
        List records = new ArrayList();
        if (iPageCommonResponse.isSuccess() && iPageCommonResponse.getData() != null) {
            records = ((IPage)iPageCommonResponse.getData()).getRecords();
        }
        HashMap beans = new HashMap();
        for (WorkRecordVO vo : records) {
            if (vo.getSex() != null) {
                vo.setSexName(vo.getSex() == 1 ? "\u7537" : "\u5973");
            }
            vo.setEnterExitStateName(vo.getEnterExitState() == 1 ? "\u5728\u573a" : "\u9000\u573a");
            if (vo.getIdCardFrontPhotoFlag() != null) {
                vo.setIdCardFrontPhotoFlagName(CheckPhotoFlagEnum.getEnumByStateCode((Integer)vo.getIdCardFrontPhotoFlag()).getDescription());
            }
            if (vo.getIdCardBackPhotoFlag() != null) {
                vo.setIdCardBackPhotoFlagName(CheckPhotoFlagEnum.getEnumByStateCode((Integer)vo.getIdCardBackPhotoFlag()).getDescription());
            }
            if (vo.getFacePhotoFlag() == null) continue;
            vo.setFacePhotoFlagName(CheckPhotoFlagEnum.getEnumByStateCode((Integer)vo.getFacePhotoFlag()).getDescription());
        }
        beans.put("records", records);
        ExcelExport.getInstance().export("WorkRecord-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refWorkRecordData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<WorkRecordVO>> refWorkRecordData(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition, @RequestParam(required=false) String searchObject) {
        Long teamId = null;
        if (StringUtils.isNotBlank((CharSequence)relyCondition)) {
            teamId = Long.parseLong(relyCondition.split("=")[1]);
            ProjectTeamEntity team = (ProjectTeamEntity)((Object)this.projectTeamService.getById(teamId));
            if (teamId == null) {
                return CommonResponse.error((String)"\u5f53\u524d\u73ed\u7ec4\u4e0d\u5b58\u5728\u6863\u6848\uff01");
            }
            teamId = team.getParentId() == null ? null : teamId;
        }
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("idCard");
        fuzzyFields.add("workTypeName");
        fuzzyFields.add("teamName");
        fuzzyFields.add("phone");
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("last_flag", new Parameter("eq", (Object)LastFlagEnum.\u662f.getStatus()));
        param.getParams().put("enter_exit_state", new Parameter("eq", (Object)1));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (conditionMap.containsKey("projectId")) {
                param.getParams().put("project_id", new Parameter("eq", conditionMap.get("projectId")));
            } else {
                param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        if (teamId != null) {
            param.getParams().put("team_id", new Parameter("like", (Object)teamId));
        }
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("enter_date", "desc");
        orderMap.put("create_time", "desc");
        param.setOrderMap(orderMap);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WorkRecordVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refWorkRecordDataToLab"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<WorkRecordVO>> refWorkRecordDataToLab(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition, @RequestParam(required=false) String searchObject) throws ParseException {
        return this.service.refWorkRecordDataToLab(pageNumber, pageSize, relyCondition, searchText, condition, searchObject);
    }

    @RequestMapping(value={"/updateBatWorker"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<WorkRecordVO> updateBatWorker(@RequestBody WorkRecordVO updateVO) {
        WorkRecordVO vo = this.service.updateBatWorker(updateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }
}

