/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.order.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlprogress.order.bean.CheckEntity;
import com.ejianc.business.jlprogress.order.bean.DeliveryEntity;
import com.ejianc.business.jlprogress.order.bean.ProductOutEntity;
import com.ejianc.business.jlprogress.order.service.ICheckService;
import com.ejianc.business.jlprogress.order.service.IDeliveryService;
import com.ejianc.business.jlprogress.order.service.IProductOutService;
import com.ejianc.business.jlprogress.order.service.impl.CheckBpmServiceImpl;
import com.ejianc.business.jlprogress.order.vo.DeliveryDetailVO;
import com.ejianc.business.jlprogress.order.vo.DeliveryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"delivery"})
public class DeliveryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "FHTZ_CODE";
    @Autowired
    private IDeliveryService service;
    @Autowired
    private ICheckService checkService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private CheckBpmServiceImpl check;
    @Autowired
    private IShareMaterialApi iShareMaterialApi;
    @Autowired
    private IProductOutService productOutService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DeliveryVO> saveOrUpdate(@RequestBody DeliveryVO saveOrUpdateVO) {
        DeliveryEntity deliveryEntity = this.service.selectNotActivated(saveOrUpdateVO.getId(), saveOrUpdateVO.getContractId());
        if (deliveryEntity != null) {
            throw new BusinessException("\u4e00\u4e2a\u5408\u540c\u53ea\u80fd\u6709\u4e00\u4e2a\u672a\u751f\u6548\u7684\u5355\u636e");
        }
        DeliveryEntity entity = (DeliveryEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, DeliveryEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        DeliveryVO vo = (DeliveryVO)BeanMapper.map((Object)((Object)entity), DeliveryVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DeliveryVO> queryDetail(Long id) {
        DeliveryEntity entity = (DeliveryEntity)((Object)this.service.selectById(id));
        DeliveryVO vo = (DeliveryVO)BeanMapper.map((Object)((Object)entity), DeliveryVO.class);
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        list.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        int sum = this.service.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(null != entity.getContractId(), DeliveryEntity::getContractId, (Object)entity.getContractId())).in(DeliveryEntity::getBillState, list));
        vo.setDeliverySum(Integer.valueOf(sum));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DeliveryVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (DeliveryVO deliveryVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DeliveryVO>> queryList(@RequestBody QueryParam param) {
        DeliveryController.setFuzzyFields(param);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        if (null != page.getRecords() && page.getRecords().size() != 0) {
            List ids = page.getRecords().stream().map(BaseEntity::getId).collect(Collectors.toList());
            List checkList = this.checkService.list((Wrapper)new QueryWrapper().in((Object)"delivery_id", ids));
            Map<Long, Integer> checkNums = checkList.stream().collect(Collectors.toMap(CheckEntity::getDeliveryId, e -> 1, (e1, e2) -> {
                e1 = e1 + 1;
                return e1;
            }));
            page.getRecords().forEach(detail -> {
                Integer checkNum = (Integer)checkNums.get(detail.getId());
                detail.setCheckNum(checkNum == null ? 0 : checkNum);
            });
        }
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DeliveryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryReportList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DeliveryVO>> queryReportList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("customName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<DeliveryVO> resList = this.service.queryReportPage(page, wrapper);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(resList);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        DeliveryController.setFuzzyFields(param);
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List<DeliveryEntity> list = this.service.queryListWithCheckCount(param);
        List voList = BeanMapper.mapList(list, DeliveryVO.class);
        for (DeliveryVO deliveryVO : voList) {
            if (deliveryVO.getBillState() == 0) {
                deliveryVO.setBillStateName("\u81ea\u7531\u6001");
            }
            if (deliveryVO.getBillState() == 2 || deliveryVO.getBillState() == 5) {
                deliveryVO.setBillStateName("\u5ba1\u6279\u4e2d");
            }
            if (deliveryVO.getBillState() == 1) {
                deliveryVO.setBillStateName("\u5df2\u63d0\u4ea4");
            }
            if (deliveryVO.getBillState() == 3) {
                deliveryVO.setBillStateName("\u5ba1\u6279\u901a\u8fc7");
            }
            if (deliveryVO.getBillState() != 4) continue;
            deliveryVO.setBillStateName("\u5ba1\u6279\u9a73\u56de");
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("Delivery-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelReportExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelReportExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("customName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<DeliveryVO> resList = this.service.queryReportList(wrapper);
        for (DeliveryVO resData : resList) {
            switch (resData.getReceiptStatus()) {
                case 0: {
                    resData.setReceiptStatusName("\u65e0");
                    break;
                }
                case 1: {
                    resData.setReceiptStatusName("\u6709");
                }
            }
        }
        HashMap<String, List<DeliveryVO>> beans = new HashMap<String, List<DeliveryVO>>();
        beans.put("records", resList);
        ExcelExport.getInstance().export("DeliveryReport-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refDeliveryData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DeliveryVO>> refDeliveryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("clientName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        list.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        param.getParams().put("billState", new Parameter("in", list));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            Long contractId = _con.getLong("contractId");
            param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DeliveryVO.class));
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ArrayList<Integer> billStateList = new ArrayList<Integer>(Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List ids = pageData.getRecords().stream().map(BaseVO::getId).collect(Collectors.toList());
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BaseEntity::getDr, (Object)0)).in(ProductOutEntity::getBillState, billStateList)).in(ProductOutEntity::getDeliveryId, ids);
        Map<Long, ProductOutEntity> map = this.productOutService.list((Wrapper)wrapper).stream().collect(Collectors.toMap(ProductOutEntity::getDeliveryId, x -> x, (existing, replacement) -> existing));
        for (DeliveryVO vo : pageData.getRecords()) {
            if (!map.containsKey(vo.getId())) continue;
            vo.setIsOut("\u5df2\u53d1\u8d27");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"/selectDeliveryCount"})
    @ResponseBody
    public CommonResponse selectMoney(Long Id, Long contractId) {
        System.out.println(contractId);
        System.out.println(Id);
        Integer count = this.service.selectCount(Id, contractId);
        return CommonResponse.success((String)"\u6210\u529f", (Object)count);
    }

    private static void setFuzzyFields(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("clientName");
        fuzzyFields.add("projectTypeName");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("managerName");
        fuzzyFields.add("receiverName");
    }

    @RequestMapping(value={"/queryDeliveryRecordByContractId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryDeliveryRecordByContractId(@RequestParam Long contractId) {
        JSONObject jsonObject = new JSONObject();
        List list = this.service.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(DeliveryEntity::getBillState, Arrays.asList(1, 3))).eq(DeliveryEntity::getContractId, (Object)contractId));
        if (CollectionUtils.isNotEmpty((Collection)list) && list.size() > 0) {
            List deliveryVOList = BeanMapper.mapList((Iterable)list, DeliveryVO.class);
            List ids = deliveryVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
            List checkList = this.checkService.list((Wrapper)new QueryWrapper().in((Object)"delivery_id", ids));
            Map<Long, Integer> checkNums = checkList.stream().collect(Collectors.toMap(CheckEntity::getDeliveryId, e -> 1, (e1, e2) -> {
                e1 = e1 + 1;
                return e1;
            }));
            deliveryVOList.forEach(detail -> {
                Integer checkNum = (Integer)checkNums.get(detail.getId());
                detail.setCheckNum(Integer.valueOf(checkNum == null ? 0 : checkNum));
            });
            jsonObject.put("deliveryVOList", (Object)deliveryVOList);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    @RequestMapping(value={"/downloadInfo"})
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"DeliveryDetail-import.xlsx", (String)"\u53d1\u8d27\u901a\u77e5\u5355-\u7269\u6599\u660e\u7ec6\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<DeliveryDetailVO> successList = new ArrayList<DeliveryDetailVO>();
        ArrayList<DeliveryDetailVO> errorList = new ArrayList<DeliveryDetailVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            ArrayList materialCodeList = new ArrayList();
            Map<Object, Object> map = new HashMap();
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                materialCodeList.add(datas.get(0));
            }
            CommonResponse materialRes = this.iShareMaterialApi.queryMaterialListByCodes(materialCodeList);
            if (!materialRes.isSuccess()) {
                return CommonResponse.error((String)materialRes.getMsg());
            }
            map = ((List)materialRes.getData()).stream().collect(Collectors.toMap(p -> p.getCode(), Function.identity()));
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                DeliveryDetailVO detailVO = new DeliveryDetailVO();
                detailVO.setId(Long.valueOf(IdWorker.getId()));
                String materialCode = StrUtil.trim((CharSequence)((CharSequence)datas.get(0)));
                detailVO.setMaterialCode(materialCode);
                try {
                    if (ObjectUtils.isEmpty((Object)map.get(materialCode))) {
                        throw new Exception("\u6ca1\u6709\u6b64\u6750\u6599\uff011");
                    }
                    detailVO.setMaterialName(((MaterialVO)map.get(materialCode)).getName());
                    detailVO.setSpec(((MaterialVO)map.get(materialCode)).getSpec());
                    detailVO.setModel(((MaterialVO)map.get(materialCode)).getModel());
                    detailVO.setUnit((String)datas.get(4));
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u6ca1\u6709\u6b64\u6750\u6599\uff012");
                    errorList.add(detailVO);
                    continue;
                }
                if (ObjectUtils.isEmpty(datas.get(5))) {
                    detailVO.setNum(null);
                } else {
                    try {
                        detailVO.setNum(BigDecimal.valueOf(Double.parseDouble((String)datas.get(5))));
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("\u6570\u91cf\u683c\u5f0f\u9519\u8bef\uff01");
                        errorList.add(detailVO);
                        continue;
                    }
                }
                successList.add(detailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }
}

