/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.progress.utils;

import com.ejianc.framework.core.util.ComputeUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.StringUtils;

public class NumberUtil {
    private static final String[] CN_NUM = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    private static final String[] CN_UNIT = new String[]{"", "\u5341", "\u767e", "\u5343", "\u4e07", "\u5341", "\u767e", "\u5343", "\u4ebf", "\u5341", "\u767e", "\u5343"};
    private static final String CN_NEGATIVE = "\u8d1f";
    private static final String CN_POINT = "\u70b9";

    private NumberUtil() {
    }

    public static String int2chineseNum(int intNum) {
        String res;
        if (intNum == 0) {
            return CN_NUM[0];
        }
        StringBuffer sb = new StringBuffer();
        boolean isNegative = false;
        if (intNum < 0) {
            isNegative = true;
            intNum *= -1;
        }
        int count = 0;
        while (intNum > 0) {
            sb.insert(0, CN_NUM[intNum % 10] + CN_UNIT[count]);
            intNum /= 10;
            ++count;
        }
        if (isNegative) {
            sb.insert(0, CN_NEGATIVE);
        }
        if (StringUtils.startsWith((CharSequence)(res = sb.toString().replaceAll("\u96f6[\u5343\u767e\u5341]", "\u96f6").replaceAll("\u96f6+\u4e07", "\u4e07").replaceAll("\u96f6+\u4ebf", "\u4ebf").replaceAll("\u4ebf\u4e07", "\u4ebf\u96f6").replaceAll("\u96f6+", "\u96f6").replaceAll("\u96f6$", "")), (CharSequence)"\u4e00\u5341")) {
            res = res.substring(1);
        }
        if (StringUtils.startsWith((CharSequence)res, (CharSequence)"\u8d1f\u4e00\u5341")) {
            res = CN_NEGATIVE + res.substring(2);
        }
        return res;
    }

    public static String bigDecimal2chineseNum(BigDecimal bigDecimalNum) {
        int signum;
        if (bigDecimalNum == null) {
            return CN_NUM[0];
        }
        StringBuffer sb = new StringBuffer();
        String numStr = bigDecimalNum.abs().stripTrailingZeros().toPlainString();
        String[] split = numStr.split("\\.");
        String integerStr = NumberUtil.int2chineseNum(Integer.parseInt(split[0]));
        sb.append(integerStr);
        if (split.length == 2) {
            sb.append(CN_POINT);
            String decimalStr = split[1];
            char[] chars = decimalStr.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                int index = Integer.parseInt(String.valueOf(chars[i]));
                sb.append(CN_NUM[index]);
            }
        }
        if ((signum = bigDecimalNum.signum()) == -1) {
            sb.insert(0, CN_NEGATIVE);
        }
        return sb.toString();
    }

    public static BigDecimal toBigDecimal(Object x) {
        if (x == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal result = null;
        try {
            result = new BigDecimal(x.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Integer safeSub(Integer num1, Integer num2) {
        if (num1 == null || num2 == null) {
            return 0;
        }
        if (num2.equals(0)) {
            return 0;
        }
        BigDecimal decimal1 = new BigDecimal(num1);
        BigDecimal decimal2 = new BigDecimal(num2);
        return decimal1.subtract(decimal2).intValue();
    }

    public static Integer safeSub(Integer num1, Integer ... subNums) {
        for (Integer temp : subNums) {
            num1 = NumberUtil.safeSub(num1, temp);
        }
        return num1;
    }

    public static BigDecimal bigDecimalPercent(Integer num1, Integer num2, int point) {
        if (num1 == null || num2 == null) {
            return BigDecimal.ZERO;
        }
        if (num2.equals(0)) {
            return BigDecimal.ZERO;
        }
        BigDecimal bigDecimalNum1 = new BigDecimal(num1);
        BigDecimal bigDecimalNum2 = new BigDecimal(num2);
        return NumberUtil.bigDecimalPercent(bigDecimalNum1, bigDecimalNum2, point);
    }

    public static BigDecimal bigDecimalPercent(BigDecimal num1, BigDecimal num2, int point) {
        if (num1 == null || num2 == null) {
            return BigDecimal.ZERO;
        }
        if (ComputeUtil.equals((BigDecimal)BigDecimal.ZERO, (BigDecimal)num2)) {
            return BigDecimal.ZERO;
        }
        BigDecimal percent = num1.divide(num2, point + 2, RoundingMode.HALF_UP);
        BigDecimal percent100 = percent.multiply(new BigDecimal(100)).setScale(point);
        if (ComputeUtil.isGreaterThan((BigDecimal)percent100, (BigDecimal)new BigDecimal("100"))) {
            percent100 = new BigDecimal("100");
        }
        if (ComputeUtil.isLessThan((BigDecimal)percent100, (BigDecimal)new BigDecimal("0"))) {
            percent100 = new BigDecimal("0");
        }
        return percent100;
    }
}

