/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.progress.utils;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.jlprogress.progress.cons.CustomizeCloumVO;
import com.ejianc.business.jlprogress.progress.utils.ArrayListUtil;
import com.ejianc.business.jlprogress.progress.utils.PlusProjectUtil;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.multipart.MultipartFile;

public class PlusUtil {
    public static HashMap read(MultipartFile file, List<String> cloums) {
        HashMap read = null;
        try {
            read = PlusProjectUtil.Read(file, cloums);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165\u6587\u4ef6\uff01");
        }
        return read;
    }

    public static void write(HttpServletResponse response, String fileName, Map dataProject, List<String> cloums) {
        String write = null;
        try {
            write = PlusProjectUtil.Write(dataProject, cloums);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (write != null) {
            OutputStreamWriter out = null;
            try {
                ServletOutputStream os = response.getOutputStream();
                out = new OutputStreamWriter((OutputStream)os, "UTF-8");
                response.setContentType("application/octet-stream; charset=utf-8");
                response.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
                response.setCharacterEncoding("UTF-8");
                out.write(write);
                out.flush();
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new BusinessException("\u4e0b\u8f7d\u5931\u8d25");
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException var11) {
                        var11.printStackTrace();
                    }
                }
            }
        }
    }

    public static HashMap readMain(HashMap map, Map<String, Map> value) {
        if (map != null) {
            map = PlusUtil.read2Date(map, "CreationDate", "FinishDate", "StartDate");
            map = PlusUtil.readCalendar(map);
            List tasks = (List)map.get("Tasks");
            PlusUtil.readTask(tasks, value, "Start", "Finish", "EarlyFinish", "LateStart", "EarlyStart", "LateFinish", "ConstraintDate", "CreateDate");
        }
        return map;
    }

    public static HashMap readMain(HashMap map) {
        if (map != null) {
            map = PlusUtil.read2Date(map, "CreationDate", "FinishDate", "StartDate");
            map = PlusUtil.readCalendar(map);
            List tasks = (List)map.get("Tasks");
            HashMap<String, Map> value = new HashMap<String, Map>();
            PlusUtil.readTask(tasks, value, "Start", "Finish", "EarlyFinish", "LateStart", "EarlyStart", "LateFinish", "ConstraintDate", "CreateDate");
        }
        return map;
    }

    public static HashMap read2Date(HashMap map, String ... key) {
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        for (String k : key) {
            if (map.get(k) != null) {
                map.put(k, sd.format(map.get(k)));
                continue;
            }
            map.put(k, null);
        }
        return map;
    }

    public static HashMap value2Key(HashMap hm, Map<String, Map> value) {
        if (!hm.containsKey("ExtendedAttribute")) {
            return hm;
        }
        ArrayList ExtendedAttributes = (ArrayList)hm.get("ExtendedAttribute");
        for (Object obj : ExtendedAttributes) {
            HashMap vo = (HashMap)obj;
            for (Map cloum : value.values()) {
                if (!vo.get("FieldID").toString().equals(cloum.get("fieldID").toString())) continue;
                Object key = vo.get("Value");
                if (cloum.get("value") != null) {
                    key = PlusUtil.getKey((HashMap)cloum.get("value"), vo.get("Value").toString());
                }
                hm.put(cloum.get("field"), key);
            }
        }
        return hm;
    }

    public static List<HashMap> readTask(List<HashMap> tasks, Map<String, Map> value, String ... key) {
        for (HashMap hm : tasks) {
            PlusUtil.read2Date(hm, key);
            if (value.size() > 0) {
                PlusUtil.value2Key(hm, value);
            }
            hm.remove("employeeName");
            hm.remove("PercentComplete");
            hm.remove("diffValue");
            hm.remove("planNum");
            if (hm.get("children") == null) continue;
            List child = (List)hm.get("children");
            PlusUtil.readTask(child, value, key);
        }
        return tasks;
    }

    public static List<Map> dealCalendars(String calendars) {
        List<Map> list = ArrayListUtil.toArrayList(calendars);
        for (Map m : list) {
            List<Map> weekDays = ArrayListUtil.toArrayList(m.get("WeekDays"));
            m.put("WeekDays", weekDays);
            for (Map workingTimes : weekDays) {
                List<Map> times = ArrayListUtil.toArrayList(workingTimes.get("WorkingTimes"));
                workingTimes.put("WorkingTimes", times);
            }
            List<Map> exceptions = ArrayListUtil.toArrayList(m.get("Exceptions"));
            m.put("Exceptions", exceptions);
            for (Map n : exceptions) {
                if (n.containsKey("WorkingTimes")) {
                    List<Map> times = ArrayListUtil.toArrayList(n.get("WorkingTimes"));
                    n.put("WorkingTimes", times);
                }
                Map timePeriod = (Map)JSONObject.parseObject((String)JSONObject.toJSONString(n.get("TimePeriod")), Map.class);
                String FromDate = (String)timePeriod.get("FromDate");
                String ToDate = (String)timePeriod.get("ToDate");
                if (FromDate.contains(".000Z")) {
                    timePeriod.put("FromDate", FromDate.substring(0, FromDate.lastIndexOf(".000Z")));
                }
                if (ToDate.contains(".000Z")) {
                    timePeriod.put("ToDate", ToDate.substring(0, ToDate.lastIndexOf(".000Z")));
                }
                n.put("TimePeriod", timePeriod);
            }
        }
        return list;
    }

    public static <K, V> K getKey(Map<K, V> map, V value) {
        return map.entrySet().stream().filter(entry -> value.equals(entry.getValue())).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    public static Map<String, Map> getFieldMap(ArrayList list, Map<String, CustomizeCloumVO> cloumMap) {
        String fieldName = null;
        HashMap<String, Map> fieldMap = new HashMap<String, Map>();
        if (list == null) {
            return fieldMap;
        }
        for (Object obj : list) {
            HashMap o = (HashMap)obj;
            if (o.get("Alias") == null) continue;
            fieldName = o.get("Alias").toString();
            for (CustomizeCloumVO cloum : cloumMap.values()) {
                if (!cloum.getFieldName().equals(fieldName)) continue;
                Map field = (Map)BeanMapper.map((Object)cloum, Map.class);
                field.put("fieldID", o.get("FieldID"));
                field.put("value", cloum.getValue());
                fieldMap.put(cloum.getField(), field);
            }
        }
        return fieldMap;
    }

    public static String utc2Local(String time) {
        String res = "";
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        sdf1.setTimeZone(TimeZone.getTimeZone("UTC"));
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        try {
            Date date = sdf1.parse(time);
            res = sdf2.format(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return res;
    }

    private static HashMap readCalendar(HashMap map) {
        ArrayList<HashMap> lst = new ArrayList<HashMap>();
        if (map.get("Calendars") != null) {
            ArrayList Calendars = (ArrayList)map.get("Calendars");
            for (Object obj : Calendars) {
                HashMap calendar = (HashMap)obj;
                calendar = PlusUtil.readExceptions(calendar);
                lst.add(calendar);
            }
            map.put("Calendars", lst);
        }
        return map;
    }

    private static HashMap readExceptions(HashMap map) {
        ArrayList<HashMap> lst = new ArrayList<HashMap>();
        if (map.get("Exceptions") != null) {
            ArrayList Exceptions = (ArrayList)map.get("Exceptions");
            for (Object obj : Exceptions) {
                HashMap exception = (HashMap)obj;
                exception = PlusUtil.readTimePeriod(exception);
                lst.add(exception);
            }
            map.put("Exceptions", lst);
        }
        return map;
    }

    private static HashMap readTimePeriod(HashMap map) {
        if (map.get("TimePeriod") != null) {
            HashMap TimePeriod = (HashMap)map.get("TimePeriod");
            TimePeriod = PlusUtil.read2Date(TimePeriod, "FromDate", "ToDate");
            map.put("TimePeriod", TimePeriod);
        }
        return map;
    }
}

