/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlprogress.quality.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.ejianc.business.jlprogress.progress.bean.ExecPlanDetailEntity;
import com.ejianc.business.jlprogress.progress.mapper.TotalPlanMapper;
import com.ejianc.business.jlprogress.quality.bean.ProcessCheckEntity;
import com.ejianc.business.jlprogress.quality.mapper.ProcessCheckMapper;
import com.ejianc.business.jlprogress.quality.service.IProcessCheckService;
import com.ejianc.business.jlprogress.quality.vo.ProcessCheckVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamsCheckDsVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="processCheckService")
public class ProcessCheckServiceImpl
extends BaseServiceImpl<ProcessCheckMapper, ProcessCheckEntity>
implements IProcessCheckService {
    @Autowired
    private TotalPlanMapper totalPlanMapper;
    @Autowired
    private ProcessCheckMapper processCheckMapper;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String CODE = "P-LK1j0Q0018";

    @Override
    public BigDecimal getPlanByWbs(Long wbsId) {
        ExecPlanDetailEntity entity = this.totalPlanMapper.getPlanByWbs(wbsId);
        if (entity == null) {
            return BigDecimal.ZERO;
        }
        return entity.getPlanNum();
    }

    @Override
    public BigDecimal getFinishByWbs(Long wbsId, Long processId) {
        BigDecimal finishByWbs = this.processCheckMapper.getFinishByWbs(wbsId, processId);
        return ObjectUtils.isEmpty((Object)finishByWbs) ? BigDecimal.ZERO : finishByWbs;
    }

    @Override
    public ParamsCheckVO checkParams(ProcessCheckVO vo) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        paramsCheckVOS.addAll(this.checkParamsByMny(vo));
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    private List<ParamsCheckVO> checkParamsByMny(ProcessCheckVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
        BigDecimal planNum = this.getPlanByWbs(vo.getWbsId());
        BigDecimal finishNum = this.getFinishByWbs(vo.getWbsId(), vo.getProcessId());
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u5de5\u5e8f\u68c0\u6d4b\u6821\u9a8c\uff0c\u68c0\u9a8c\u6570+\u5df2\u5b8c\u6210\u68c0\u9a8c\u6570\u662f\u5426\u8d85\u8fc7\u8ba1\u5212\u6570\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (vo.getTotalNum().add(finishNum).compareTo(planNum) > 0) {
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u5de5\u5e8f\u68c0\u6d4b\u9884\u8b66");
                        paramsCheckDsVO.setWarnName("\u5de5\u5e8f\u68c0\u6d4b\u6821\u9a8c\uff0c\u68c0\u9a8c\u6570+\u5df2\u5b8c\u6210\u68c0\u9a8c\u6570\u662f\u5426\u8d85\u8fc7\u8ba1\u5212\u6570\u9884\u8b66");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u5de5\u7a0b\u540d\u79f0\u4e3a\uff1a").append(vo.getProjectName()).append("\u7684\u8ba1\u5212\u68c0\u9a8c\u6570\u4e3a").append(planNum.setScale(0, 1)).append("\u4e2a,\u5df2\u68c0\u9a8c\u5b8c\u6210").append(finishNum.setScale(0, 1)).append("\u4e2a\u3002\u603b\u5b8c\u6210\u68c0\u9a8c\u6570\u5df2\u8d85\u8fc7\u8ba1\u5212\u6570\uff0c\u662f\u5426\u7ee7\u7eed\u4fdd\u5b58");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOS;
    }
}

