package com.ejianc.business.jlprogress.asset.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlprogress.asset.mapper.CarInfoMapper;
import com.ejianc.business.jlprogress.asset.bean.CarInfoEntity;
import com.ejianc.business.jlprogress.asset.service.ICarInfoService;

/**
 * 浦江设备管理-车辆信息
 *
 * @author generator
 */
@Service("carInfoService")
public class CarInfoServiceImpl extends BaseServiceImpl<CarInfoMapper, CarInfoEntity> implements ICarInfoService {

    @Override
    public Boolean getCarInfoByCarNum(CarInfoEntity carInfo) {
        LambdaQueryWrapper<CarInfoEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(CarInfoEntity::getCarNum, carInfo.getCarNum());
        // 判断id不为空 如果不为空 则是Unpdate 要排除当前记录
        if (carInfo.getId() != null) {
            queryWrapper.ne(CarInfoEntity::getId, carInfo.getId());
        }
        return this.list(queryWrapper).size() > 0;
    }
}
