package com.ejianc.business.jlprogress.factory.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 制造厂-计划单子表
 *
 * @author generator
 *
 */
public class FactPlanDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long planId; // 主表ID
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM",
            timezone = "GMT+8"
    )
    private Date detailMonth; // 填报月份
    private Long makeStateId; // 生产状态ID
    private String makeStateName; // 生产状态名称
    private String planCode; // 计划单号
    private Long customerId; // 客户Id
    private String customerName; // 客户名称
    private Long productId; // 产品ID
    private String productName; // 产品名称
    private String spec; // 材料规格
    private BigDecimal weigh; // 重量
    private BigDecimal num; // 数量
    private BigDecimal price; // 销售价
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date bugDate; // 接单日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date changeDate; // 更改日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date giveDate; // 交货日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date inDate; // 入库日期
    private String manager; // 销售负责人
    private String memo; // 备注
    private Long projectId; // 项目ID
    private String projectCode; // 项目code
    private String projectName; // 项目名称
    private Long sourceId; // 主表ID
    private String reportMonth;
    private String errorMsg; // 导入错误信息
    private Integer factoryCategory; // 生产厂
    private String factoryName; // 生产厂名称

    public String getFactoryName() {
        return factoryName;
    }

    public void setFactoryName(String factoryName) {
        this.factoryName = factoryName;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String getReportMonth() {
        return reportMonth;
    }

    public void setReportMonth(String reportMonth) {
        this.reportMonth = reportMonth;
    }

    public Date getDetailMonth() {
        return detailMonth;
    }

    public void setDetailMonth(Date detailMonth) {
        this.detailMonth = detailMonth;
    }

    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getMakeStateId() {
        return makeStateId;
    }

    @ReferDeserialTransfer
    public void setMakeStateId(Long makeStateId) {
        this.makeStateId = makeStateId;
    }
    public String getMakeStateName() {
        return makeStateName;
    }

    public void setMakeStateName(String makeStateName) {
        this.makeStateName = makeStateName;
    }
    public String getPlanCode() {
        return planCode;
    }

    public void setPlanCode(String planCode) {
        this.planCode = planCode;
    }
    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public Long getProductId() {
        return productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }
    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public BigDecimal getWeigh() {
        return weigh;
    }

    public void setWeigh(BigDecimal weigh) {
        this.weigh = weigh;
    }
    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    public Date getBugDate() {
        return bugDate;
    }

    public void setBugDate(Date bugDate) {
        this.bugDate = bugDate;
    }
    public Date getGiveDate() {
        return giveDate;
    }

    public void setGiveDate(Date giveDate) {
        this.giveDate = giveDate;
    }
    public Date getInDate() {
        return inDate;
    }

    public void setInDate(Date inDate) {
        this.inDate = inDate;
    }
    public String getManager() {
        return manager;
    }

    public void setManager(String manager) {
        this.manager = manager;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Integer getFactoryCategory() {
        return factoryCategory;
    }

    public void setFactoryCategory(Integer factoryCategory) {
        this.factoryCategory = factoryCategory;
    }
}
