package com.ejianc.business.jlprogress.labor.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.jlprogress.labor.bean.AdditionalDetailEntity;
/**
 * 订单追加费用表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_labor_additional")
public class AdditionalEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="report_id")
    private Long reportId; // 填报人id
    @TableField(value="report_name")
    private String reportName; // 填报人名称
    @TableField(value="report_month")
    private Date reportMonth; // 填报月份
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="additionalDetailService",pidName = "pid")
    private List<AdditionalDetailEntity> additionalDetailList = new ArrayList<>(); // 订单追加费用表-详情
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getReportId() {
        return reportId;
    }

    public void setReportId(Long reportId) {
        this.reportId = reportId;
    }
    public String getReportName() {
        return reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }
    public Date getReportMonth() {
        return reportMonth;
    }

    public void setReportMonth(Date reportMonth) {
        this.reportMonth = reportMonth;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    

    public List<AdditionalDetailEntity> getAdditionalDetailList() {
        return additionalDetailList;
    }

    public void setAdditionalDetailList(List<AdditionalDetailEntity> additionalDetailList) {
        this.additionalDetailList = additionalDetailList;
    }
}
