package com.ejianc.business.jlprogress.labor.bean;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 浦江现场-劳务分包用款计划表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_labor_subcontract")
public class LaborSubEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // billcode
    @TableField(value="fill_in_date")
    private Date fillInDate; // 填报日期
    @TableField(value="employee_id")
    private Long employeeId; // 填报人
    @TableField(value="employee_name")
    private String employeeName; // 填报人名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）

    
    
    @TableField(exist=false)
    @SubEntity(serviceName="laborSubDetailsService",pidName = "laborId")
    private List<LaborSubDetailsEntity> laborSubDetailsList = new ArrayList<>(); // 浦江现场-劳务分包用款计划表-子表
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Date getFillInDate() {
        return fillInDate;
    }

    public void setFillInDate(Date fillInDate) {
        this.fillInDate = fillInDate;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    

    public List<LaborSubDetailsEntity> getLaborSubDetailsList() {
        return laborSubDetailsList;
    }

    public void setLaborSubDetailsList(List<LaborSubDetailsEntity> laborSubDetailsList) {
        this.laborSubDetailsList = laborSubDetailsList;
    }
}
