package com.ejianc.business.jlprogress.labor.bean;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 浦江设备管理-大宗物资设备申请表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_material_purchase")
public class MaterialPurchaseEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // billcode
    @TableField(value="fill_in_date")
    private Date fillInDate; // 填报日期
    @TableField(value="employee_id")
    private Long employeeId; // 填报人
    @TableField(value="employee_name")
    private String employeeName; // 填报人名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）


    @TableField(exist=false)
    @SubEntity(serviceName="materialPurchaseDetailsService",pidName = "purchaseId")
    private List<MaterialPurchaseDetailsEntity> detailsList = new ArrayList<>(); // 浦江设备管理-处置详情


    public List<MaterialPurchaseDetailsEntity> getDetailsList() {
        return detailsList;
    }

    public void setDetailsList(List<MaterialPurchaseDetailsEntity> detailsList) {
        this.detailsList = detailsList;
    }


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Date getFillInDate() {
        return fillInDate;
    }

    public void setFillInDate(Date fillInDate) {
        this.fillInDate = fillInDate;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
}
