package com.ejianc.business.jlprogress.labor.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jlprogress.labor.vo.LaborSubDetailsVO;
import com.ejianc.business.jlprogress.labor.vo.MaterialPurchaseDetailsVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jlprogress.labor.bean.LaborSubEntity;
import com.ejianc.business.jlprogress.labor.service.ILaborSubService;
import com.ejianc.business.jlprogress.labor.vo.LaborSubVO;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 浦江现场-劳务分包用款计划表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("laborSub")
public class LaborSubController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Labor_Sub";//此处需要根据实际修改

    @Autowired
    private ILaborSubService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<LaborSubVO> saveOrUpdate(@RequestBody LaborSubVO saveOrUpdateVO) {
    	LaborSubEntity entity = BeanMapper.map(saveOrUpdateVO, LaborSubEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	LaborSubVO vo = BeanMapper.map(entity, LaborSubVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<LaborSubVO> queryDetail(Long id) {
    	LaborSubEntity entity = service.selectById(id);
    	LaborSubVO vo = BeanMapper.map(entity, LaborSubVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<LaborSubVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (LaborSubVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(LaborSubVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<LaborSubVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("employeeName");//填报人
        fuzzyFields.add("billCode");//单据编号
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        String startOfMonth = "";
        String endOfMonth = "";
        if (param.getParams().containsKey("month")) {
            //2024-07
            String checkMonth = param.getParams().get("month").getValue().toString();
            // 解析月份
            LocalDate date = LocalDate.parse(checkMonth + "-01", DateTimeFormatter.ISO_LOCAL_DATE);
            //获取到本月的第一天 本月最后一天
            startOfMonth = String.valueOf(date.withDayOfMonth(1));
            endOfMonth = String.valueOf(date.withDayOfMonth(date.lengthOfMonth()));
            param.getParams().remove("month");
            param.getParams().put("fillInDate", new Parameter(QueryParam.BETWEEN, startOfMonth + "," + endOfMonth));
        }

        IPage<LaborSubEntity> page = service.queryPage(param,false);
        IPage<LaborSubVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), LaborSubVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<LaborSubEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("LaborSub-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refLaborSubData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<LaborSubVO>> refLaborSubData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<LaborSubEntity> page = service.queryPage(param,false);
        IPage<LaborSubVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), LaborSubVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    @GetMapping("/selectTotalRefund")
    @ResponseBody
    public CommonResponse selectMoney(String id) {

        //查询 总包合同 各种金额
        LaborSubDetailsVO total = service.selectTotalRefund(id);

        //查询 分包结算合同 各种金额
        LaborSubDetailsVO sub= service.selectSub(id);

        // 创建Map并封装两个结果
        Map<String, LaborSubDetailsVO> resultMap = new HashMap<>();
        resultMap.put("totalContract", total);  // 总包合同
        resultMap.put("subContract", sub);      // 分包结算合同

        return CommonResponse.success("成功", resultMap);
    }

    @RequestMapping(value = "/reportQueryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> reportQueryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("payWayName");
        /** 租户隔离 */
        Page<LaborSubDetailsVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        List<LaborSubDetailsVO> list = new ArrayList<>();
        String startOfMonth = "";
        String endOfMonth = "";

       if (param.getParams().containsKey("month")) {
            //2024-07
            String checkMonth = param.getParams().get("month").getValue().toString();
            // 解析月份
            LocalDate date = LocalDate.parse(checkMonth + "-01", DateTimeFormatter.ISO_LOCAL_DATE);
            //获取到本月的第一天 本月最后一天
            startOfMonth = String.valueOf(date.withDayOfMonth(1));
            endOfMonth = String.valueOf(date.withDayOfMonth(date.lengthOfMonth()));
            param.getParams().remove("month");
            param.getParams().put("fillInDate", new Parameter(QueryParam.BETWEEN, startOfMonth + "," + endOfMonth));

        }
        QueryWrapper wrapper = changeToQueryWrapper(param);
        list = service.laborSubReport(page, wrapper);
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());

        return CommonResponse.success("查询列表数据成功！", res);
    }
    /**
     * @param param
     * @Description 报表导出
     * @Return void
     */
    @RequestMapping(value = "/excelReportExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelReportExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("payWayName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);

        Page<LaborSubDetailsVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        List<LaborSubDetailsVO> list = new ArrayList<>();
        String startOfMonth = "";
        String endOfMonth = "";

        if (param.getParams().containsKey("month")) {
            //2024-07
            String checkMonth = param.getParams().get("month").getValue().toString();
            // 解析月份
            LocalDate date = LocalDate.parse(checkMonth + "-01", DateTimeFormatter.ISO_LOCAL_DATE);
            //获取到本月的第一天 本月最后一天
            startOfMonth = String.valueOf(date.withDayOfMonth(1));
            endOfMonth = String.valueOf(date.withDayOfMonth(date.lengthOfMonth()));
            param.getParams().remove("month");
            param.getParams().put("fillInDate", new Parameter(QueryParam.BETWEEN, startOfMonth + "," + endOfMonth));
        }
        QueryWrapper wrapper = changeToQueryWrapper(param);
        list = service.laborSubReport(page, wrapper);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("LaborSubReport-export.xlsx", beans, response);
    }

}