package com.ejianc.business.jlprogress.labor.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlprogress.labor.vo.AdditionalDetailVO;
import com.ejianc.business.jlprogress.labor.vo.AdditionalVO;
import org.apache.lucene.document.HalfFloatPoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlprogress.labor.mapper.AdditionalMapper;
import com.ejianc.business.jlprogress.labor.bean.AdditionalEntity;
import com.ejianc.business.jlprogress.labor.service.IAdditionalService;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 订单追加费用表
 *
 * @author generator
 */
@Service("additionalService")
public class AdditionalServiceImpl extends BaseServiceImpl<AdditionalMapper, AdditionalEntity> implements IAdditionalService {

    @Autowired
    private AdditionalMapper mapper;

    @Override
    public BigDecimal selectContarctMny(String projectCode) {
        BigDecimal mny = mapper.selectContarctMny(projectCode);
        return mny;
    }

    @Override
    public List<AdditionalDetailVO> reportQueryList(Page pages, QueryWrapper wrapper) {
        return baseMapper.reportQueryList(pages,wrapper);
    }

    @Override
    public Map<String, BigDecimal> selectMnyByCode(String[] projectCode) {
     List<AdditionalDetailVO> list=  baseMapper.selectMnyByCode(projectCode);
        HashMap<String, BigDecimal> map = new HashMap<>();
        for (AdditionalDetailVO additionalDetailVO : list) {
            if(map.containsKey(additionalDetailVO.getProjectCode())){
                continue;
            }else {
                map.put(additionalDetailVO.getProjectCode(),additionalDetailVO.getUndertakeMny());
            }
        }
        return map;
    }

    @Override
    public Integer isHaveDone() {
        return baseMapper.isHaveDone();
    }
}
