package com.ejianc.business.jlprogress.order.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.jlprogress.factory.service.*;
import com.ejianc.business.jlprogress.labor.service.IAdditionalService;
import com.ejianc.business.jlprogress.labor.service.ILaborSubService;
import com.ejianc.business.jlprogress.labor.service.IMaterialPurchaseService;
import com.ejianc.business.jlprogress.order.mapper.SalesMapper;
import com.ejianc.business.jlprogress.order.service.ISalesService;
import com.ejianc.business.jlprogress.order.vo.IncomeContractVO;
import com.ejianc.business.jlprogress.progress.bean.TotalPlanEntity;
import com.ejianc.business.jlprogress.progress.mapper.TotalPlanMapper;
import com.ejianc.business.jlprogress.progress.service.IExecPlanDetailService;
import com.ejianc.business.jlprogress.progress.service.IExecPlanService;
import com.ejianc.business.jlprogress.progress.service.ITotalPlanService;
import com.ejianc.business.jlprogress.progress.vo.ExecPlanDetailVO;
import com.ejianc.business.jlprogress.progress.vo.ExecPlanWarnDetailVO;
import com.ejianc.business.jlprogress.tech.service.ITechOrderService;
import com.ejianc.business.jlprogress.tech.service.ITechSchemeService;
import com.ejianc.business.jlprogress.tech.service.ITechSituationService;
import com.ejianc.business.jlprogress.tech.service.ITechTestService;
import com.ejianc.business.warn.vo.WarningReceiveVO;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.api.IShareProjectWbsApi;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;


/**
 * @Description: 预警控制类
 */
@RestController
@RequestMapping(value = "/warn/")
public class WarnController {


    //测试环境巨力索具 orgId
    private static final Long TEST_ORG_ID = 1247777316689256450L;

    //正式环境巨力索具股份有限公司 orgId
    private static final Long FORMAL_ORG_ID = 2405220001L;


    //测试环境上海浦江 orgId
    private static final Long TEST_PUJIANG_ORG_ID = 1247777316689256450L;

    //正式环境上海浦江 orgId
    private static final Long FORMAL_PUJIANG_ORG_ID = 2405220190L;


    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String SALES_WARN_NAME = "销售订单未制单";
    private static final String PLAN_WARN_NAME = "计划通知单未制单";
    private static final String YEAR_PLAN_WARN_NAME = "计划分解未制单";
    //浦江现场
    private static final String SUPPLIES_WARN_NAME = "大宗物资设备申请表 未制单";
    private static final String LABOR_WARN_NAME = "劳务分包用款计划表 未制单";
    private static final String ADDITION_WARN_NAME = "订单追加费用统计表 未制单";
    private static final String FACTCONS_WARN_NAME = "施工项目月进度一览表 未制单";

    //生产厂
    private static final String FACTEQUIPMENT_WARN_NAME = "制造厂设备台账 未制单";
    private static final String FACTGOLD_WARN_NAME = "制造厂金点子汇总表 未制单";
    private static final String FACTJIGAI_WARN_NAME = "技改项目进度表 未制单";
    private static final String FACTBUY_WARN_NAME = "主材采购进度表 未制单";
    private static final String FACTSHARE_WARN_NAME = "内部协作进度表 未制单";
    private static final String FACTPROGRESS_WARN_NAME = "制造厂外协/外购产品进度明细表 未制单";
    private static final String FACTPLAN_WARN_NAME = "制造厂计划单台账 未制单";

    //工程技术
    private static final String TECHTEST_WARN_NAME = "型式试验情况 未制单";
    private static final String TECHSITUATION_WARN_NAME = "科技成果奖项申报情况 未制单";
    private static final String TECHSCHEME_WARN_NAME = "方案图一览表 未制单";
    private static final String TECHORDER_WARN_NAME = "在执行订单 未制单";


    private static final String SALES_REPORT_URL = "/ejc-jlprogress-frontend/#/sales";
    private static final String PLAN_REPORT_URL = "/ejc-jlprogress-frontend/#/plan";
    private static final String TOTAL_PLAN_URL = "/ejc-jlprogress-frontend/#/totalPlan";
    private static final String YEAR_PLAN_URL = "/ejc-jlprogress-frontend/#/planResolve";

    //浦江现场
    private static final String SUPPLIES_URL = "/ejc-jlprogress-frontend/#/materialPurchase"; //大宗物资设备申请表
    private static final String LABOR_URL = "/ejc-jlprogress-frontend/#/laborSub"; //劳务分包用款计划表
    private static final String ADDITION_URL = "/ejc-jlprogress-frontend/#/additional"; //订单追加费用统计表
    private static final String FACTCONS_URL = "/ejc-jlprogress-frontend/#/factCons"; //施工项目月进度一览表

    //生产厂
    private static final String FACTEQUIPMENT_URL = "/ejc-jlprogress-frontend/#/factEquipment"; //制造厂设备台账
    private static final String FACTGOLD_URL = "/ejc-jlprogress-frontend/#/factGold"; //制造厂金点子汇总表
    private static final String FACTJIGAI_URL = "/ejc-jlprogress-frontend/#/factJigai"; //技改项目进度表
    private static final String FACTBUY_URL = "/ejc-jlprogress-frontend/#/factBuy"; //主材采购进度表
    private static final String FACTSHARE_URL = "/ejc-jlprogress-frontend/#/factShare"; //内部协作进度表
    private static final String FACTPROGRESS_URL = "/ejc-jlprogress-frontend/#/factProgress"; //制造厂外协/外购产品进度明细表
    private static final String FACTPLAN_URL = "/ejc-jlprogress-frontend/#/factPlan"; //制造厂计划单台账

    //工程技术
    private static final String TECHTEST_URL = "/ejc-jlprogress-frontend/#/techTest"; //型式试验情况
    private static final String TECHSITUATION_URL = "/ejc-jlprogress-frontend/#/techSituation"; //科技成果奖项申报情况
    private static final String TECHSCHEME_URL = "/ejc-jlprogress-frontend/#/programDraw"; //方案图一览表
    private static final String TECHORDER_URL = "/ejc-jlprogress-frontend/#/executeOrder"; //在执行订单


    private static final String EXECPLAN_WARN_NAME = "工序延期预警";
    private static final String EXECPLAN_URL = "/ejc-jlprogress-frontend/#/planView";


    @Autowired
    private IWarnCenterApi warnCenterApi;

    @Autowired
    private ISalesService salesService;

    @Autowired
    private SalesMapper salesMapper;
    @Autowired
    private TotalPlanMapper totalPlanMapper;

    @Autowired
    private ITotalPlanService totalPlanService;

    @Autowired
    private IProjectArchiveApi projectApi;
    @Autowired
    private IShareProjectWbsApi shareProjectWbsApi;

    @Autowired
    private IMaterialPurchaseService materialPurchaseService;

    @Autowired
    private ILaborSubService laborSubService;

    @Autowired
    private IAdditionalService additionalService;

    @Autowired
    private IFactConsService factConsService;

    @Autowired
    private IFactEquipmentService factEquipmentService;

    @Autowired
    private IFactGoldService factGoldService;

    @Autowired
    private IFactJigaiService factJigaiService;

    @Autowired
    private IFactBuyService factBuyService;

    @Autowired
    private IFactShareService factShareService;

    @Autowired
    private IFactProgressService factProgressService;

    @Autowired
    private IFactPlanService factPlanService;

    @Autowired
    private ITechTestService techTestService;

    @Autowired
    private ITechSituationService techSituationService;

    @Autowired
    private ITechSchemeService techSchemeService;

    @Autowired
    private ITechOrderService techOrderService;

    @Autowired
    private IExecPlanService execPlanService;

    /**
     * 已做合同登记 未做销售订单
     * 定时预警
     *
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "salesWarn")
    public CommonResponse<String> salesWarn(@RequestBody JSONObject jsonParam) {
        //1.接收预警参数
        logger.info("接收到Task参数：{}", jsonParam);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);

        //2.已做合同，未做销售订单的数据
        List<IncomeContractVO> recordVOList = salesMapper.getNoSales();

        if (CollectionUtils.isEmpty(recordVOList)) {
            logger.error("执行" + SALES_WARN_NAME + "完成，未发现有匹配预警规则的单据信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        logger.info("未做销售订单的数据：{}", JSONObject.toJSONString(recordVOList));

        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        DecimalFormat df = new DecimalFormat("###,##0.00");

        //3.筛出符合条件的数据发送信息
        for (IncomeContractVO reportVO : recordVOList) {
            String warnLevel = defaultWarnInfo.getString("warnLevel");
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName(reportVO.getProjectName());
            vo.setPcTitle("销售订单");
            vo.setPcUrl(SALES_REPORT_URL);
            vo.setOrgId(reportVO.getOrgId());
            vo.setOrgName(reportVO.getOrgName());
            vo.setTenantId(999999L);
            vo.setWarnLevel(warnLevel);
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));

            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent.replaceAll("#contractName#", reportVO.getContractName()));
            resp.add(vo);
        }
        return sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }


    /**
     * 已做合同登记 未做计划通知单
     * 定时预警
     *
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "planWarn")
    public CommonResponse<String> planWarn(@RequestBody JSONObject jsonParam) {
        //1.接收预警参数
        logger.info("接收到Task参数：{}", jsonParam);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);

        //2.已做合同，未做销售订单的数据
        List<IncomeContractVO> recordVOList = salesMapper.getNoPlan();

        if (CollectionUtils.isEmpty(recordVOList)) {
            logger.error("执行" + PLAN_WARN_NAME + "完成，未发现有匹配预警规则的单据信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        logger.info("未做计划通知单的数据：{}", JSONObject.toJSONString(recordVOList));

        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;

        //3.筛出符合条件的数据发送信息
        for (IncomeContractVO reportVO : recordVOList) {
            String warnLevel = defaultWarnInfo.getString("warnLevel");
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName(reportVO.getProjectName());
            vo.setPcTitle("计划通知单");
            vo.setPcUrl(PLAN_REPORT_URL);
            vo.setOrgId(reportVO.getOrgId());
            vo.setOrgName(reportVO.getOrgName());
            vo.setTenantId(999999L);
            vo.setWarnLevel(warnLevel);
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));


            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent.replaceAll("#contractName#", reportVO.getContractName()));
            resp.add(vo);
        }
        return sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    /**
     * 已做wbs 未做总计划
     * 定时预警
     *
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "totalPlanWarn")
    public CommonResponse<String> totalPlanWarn(@RequestBody JSONObject jsonParam) {
        //1.接收预警参数
        logger.info("接收到Task参数：{}", jsonParam);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);
        //2.已做合同登记，未做总计划
        List<ProjectArchiveVO> projectList = totalPlanMapper.getNoPlan();

        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        //3.筛出符合条件的数据发送信息
        for (ProjectArchiveVO project : projectList) {
            String warnLevel = defaultWarnInfo.getString("warnLevel");
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName(project.getName());
            vo.setPcTitle("项目总计划");
            vo.setPcUrl(TOTAL_PLAN_URL);
            vo.setOrgId(project.getOrgId());
            vo.setOrgName(project.getOrgName());
            vo.setTenantId(999999L);
            vo.setWarnLevel(warnLevel);
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));


            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", project.getName()));
            resp.add(vo);
        }
        return sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    /**
     * 已做项目总计划 未做计划分解
     * 定时预警
     *
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "yearPlanWarn")
    public CommonResponse<String> yearPlanWarn(@RequestBody JSONObject jsonParam) {
        //1.接收预警参数
        logger.info("接收到Task参数：{}", jsonParam);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);
        //2.已做总计划 未作计划分解
        List<TotalPlanEntity> projectList = totalPlanService.getNoTotalPlan();
        if (CollectionUtils.isEmpty(projectList)) {
            logger.error("执行" + YEAR_PLAN_WARN_NAME + "完成，未发现有匹配预警规则的单据信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        logger.info("未做计划分解的数据：{}", JSONObject.toJSONString(projectList));

        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        //3.筛出符合条件的数据发送信息
        for (TotalPlanEntity totalPlanEntity : projectList) {
            String warnLevel = defaultWarnInfo.getString("warnLevel");
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName(totalPlanEntity.getProjectName());
            vo.setPcTitle("计划分解");
            vo.setPcUrl(YEAR_PLAN_URL);
            vo.setOrgId(totalPlanEntity.getParentOrgId());
            vo.setOrgName(totalPlanEntity.getParentOrgName());
            vo.setTenantId(999999L);
            vo.setWarnLevel(warnLevel);
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", totalPlanEntity.getProjectName()));
            resp.add(vo);
        }
        return sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    /**
     * 浦江现场-大宗物资设备申请表 预警
     *
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "suppliesWarn")
    public CommonResponse<String> suppliesWarn(@RequestBody JSONObject jsonParam) {
        //1.接收预警参数
        logger.info("接收到Task参数：{}", jsonParam);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);
        //当前月是否已经做单
        Integer count = materialPurchaseService.isHaveDone();
        if (count > 0) {
            logger.error("执行" + SUPPLIES_WARN_NAME + "完成，未发现有匹配预警规则的单据信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        //3.发送信息
        String warnLevel = defaultWarnInfo.getString("warnLevel");
        EarlyWarnTransVO vo = new EarlyWarnTransVO();
        vo.setBillName("大宗物资设备申请表");
        vo.setOrgId(FORMAL_PUJIANG_ORG_ID);
        vo.setOrgName("巨力索具股份有限公司");
        vo.setPcTitle("大宗物资设备申请表");
        vo.setPcUrl(SUPPLIES_URL);
        vo.setTenantId(999999L);
        vo.setWarnLevel(warnLevel);
        vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
        vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
        tmpContent = defaultWarnInfo.getString("earlywarnContent");
        vo.setEarlywarnContent(tmpContent.replaceAll("#name#", "大宗物资设备申请表"));
        resp.add(vo);
        return sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    /**
     * 浦江现场-劳务分包用款计划表 预警
     *
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "laborWarn")
    public CommonResponse<String> laborWarn(@RequestBody JSONObject jsonParam) {
        //1.接收预警参数
        logger.info("接收到Task参数：{}", jsonParam);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);
        //当前月是否已经做单
        Integer count = laborSubService.isHaveDone();
        if (count > 0) {
            logger.error("执行" + LABOR_WARN_NAME + "完成，未发现有匹配预警规则的单据信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        //3.发送信息
        String warnLevel = defaultWarnInfo.getString("warnLevel");
        EarlyWarnTransVO vo = new EarlyWarnTransVO();
        vo.setBillName("劳务分包用款计划表");
        vo.setOrgId(FORMAL_PUJIANG_ORG_ID);
        vo.setOrgName("巨力索具股份有限公司");
        vo.setPcTitle("劳务分包用款计划表");
        vo.setPcUrl(LABOR_URL);
        vo.setTenantId(999999L);
        vo.setWarnLevel(warnLevel);
        vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
        vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
        tmpContent = defaultWarnInfo.getString("earlywarnContent");
        vo.setEarlywarnContent(tmpContent.replaceAll("#name#", "劳务分包用款计划表"));
        resp.add(vo);
        return sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    /**
     * 浦江现场-订单追加费用统计表 预警
     *
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "additionalWarn")
    public CommonResponse<String> additionalWarn(@RequestBody JSONObject jsonParam) {
        //1.接收预警参数
        logger.info("接收到Task参数：{}", jsonParam);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);
        //当前月是否已经做单
        Integer count = additionalService.isHaveDone();
        if (count > 0) {
            logger.error("执行" + ADDITION_WARN_NAME + "完成，未发现有匹配预警规则的单据信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        //3.发送信息
        String warnLevel = defaultWarnInfo.getString("warnLevel");
        EarlyWarnTransVO vo = new EarlyWarnTransVO();
        vo.setBillName("订单追加费用统计表");
        vo.setOrgId(FORMAL_PUJIANG_ORG_ID);
        vo.setOrgName("巨力索具股份有限公司");
        vo.setPcTitle("订单追加费用统计表");
        vo.setPcUrl(ADDITION_URL);
        vo.setTenantId(999999L);
        vo.setWarnLevel(warnLevel);
        vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
        vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
        tmpContent = defaultWarnInfo.getString("earlywarnContent");
        vo.setEarlywarnContent(tmpContent.replaceAll("#name#", "订单追加费用统计表"));
        resp.add(vo);
        return sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    /**
     * 浦江现场-施工项目月进度一览表 预警
     *
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "factConsWarn")
    public CommonResponse<String> factConsWarn(@RequestBody JSONObject jsonParam) {
        //1.接收预警参数
        logger.info("接收到Task参数：{}", jsonParam);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);
        //当前月是否已经做单
        Integer count = factConsService.isHaveDone();
        if (count > 0) {
            logger.error("执行" + FACTCONS_WARN_NAME + "完成，未发现有匹配预警规则的单据信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        //3.发送信息
        String warnLevel = defaultWarnInfo.getString("warnLevel");
        EarlyWarnTransVO vo = new EarlyWarnTransVO();
        vo.setBillName("施工项目月进度一览表");
        vo.setOrgId(FORMAL_PUJIANG_ORG_ID);
        vo.setOrgName("巨力索具股份有限公司");
        vo.setPcTitle("施工项目月进度一览表");
        vo.setPcUrl(FACTCONS_URL);
        vo.setTenantId(999999L);
        vo.setWarnLevel(warnLevel);
        vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
        vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
        tmpContent = defaultWarnInfo.getString("earlywarnContent");
        vo.setEarlywarnContent(tmpContent.replaceAll("#name#", "施工项目月进度一览表"));
        resp.add(vo);
        return sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    /**
     * 生产厂-制造厂设备台账 预警
     *
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "factEquipmentWarn")
    public CommonResponse<String> factEquipmentWarn(@RequestBody JSONObject jsonParam) {
        //1.接收预警参数
        logger.info("接收到Task参数：{}", jsonParam);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);
        //当前月是否已经做单
        Integer count = factEquipmentService.isHaveDone();
        if (count > 0) {
            logger.error("执行" + FACTEQUIPMENT_WARN_NAME + "完成，未发现有匹配预警规则的单据信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        //3.发送信息
        String warnLevel = defaultWarnInfo.getString("warnLevel");
        EarlyWarnTransVO vo = new EarlyWarnTransVO();
        vo.setBillName("制造厂设备台账");
        vo.setOrgId(FORMAL_ORG_ID);
        vo.setOrgName("巨力索具股份有限公司");
        vo.setPcTitle("制造厂设备台账");
        vo.setPcUrl(FACTEQUIPMENT_URL);
        vo.setTenantId(999999L);
        vo.setWarnLevel(warnLevel);
        vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
        vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
        tmpContent = defaultWarnInfo.getString("earlywarnContent");
        vo.setEarlywarnContent(tmpContent.replaceAll("#name#", "制造厂设备台账"));
        resp.add(vo);
        return sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    /**
     * 生产厂-制造厂金点子汇总表 预警
     *
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "factGoldWarn")
    public CommonResponse<String> factGoldWarn(@RequestBody JSONObject jsonParam) {
        //1.接收预警参数
        logger.info("接收到Task参数：{}", jsonParam);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);
        //当前月是否已经做单
        Integer count = factGoldService.isHaveDone();
        if (count > 0) {
            logger.error("执行" + FACTGOLD_WARN_NAME + "完成，未发现有匹配预警规则的单据信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        //3.发送信息
        String warnLevel = defaultWarnInfo.getString("warnLevel");
        EarlyWarnTransVO vo = new EarlyWarnTransVO();
        vo.setBillName("制造厂金点子汇总表");
        vo.setOrgId(FORMAL_ORG_ID);
        vo.setOrgName("巨力索具股份有限公司");
        vo.setPcTitle("制造厂金点子汇总表");
        vo.setPcUrl(FACTGOLD_URL);
        vo.setTenantId(999999L);
        vo.setWarnLevel(warnLevel);
        vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
        vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
        tmpContent = defaultWarnInfo.getString("earlywarnContent");
        vo.setEarlywarnContent(tmpContent.replaceAll("#name#", "制造厂金点子汇总表"));
        resp.add(vo);
        return sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    /**
     * 生产厂-技改项目进度表 预警
     *
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "factJigaiWarn")
    public CommonResponse<String> factJigaiWarn(@RequestBody JSONObject jsonParam) {
        //1.接收预警参数
        logger.info("接收到Task参数：{}", jsonParam);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);
        //当前月是否已经做单
        Integer count = factJigaiService.isHaveDone();
        if (count > 0) {
            logger.error("执行" + FACTJIGAI_WARN_NAME + "完成，未发现有匹配预警规则的单据信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        //3.发送信息
        String warnLevel = defaultWarnInfo.getString("warnLevel");
        EarlyWarnTransVO vo = new EarlyWarnTransVO();
        vo.setBillName("技改项目进度表");
        vo.setOrgId(FORMAL_ORG_ID);
        vo.setOrgName("巨力索具股份有限公司");
        vo.setPcTitle("技改项目进度表");
        vo.setPcUrl(FACTJIGAI_URL);
        vo.setTenantId(999999L);
        vo.setWarnLevel(warnLevel);
        vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
        vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
        tmpContent = defaultWarnInfo.getString("earlywarnContent");
        vo.setEarlywarnContent(tmpContent.replaceAll("#name#", "技改项目进度表"));
        resp.add(vo);
        return sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    /**
     * 生产厂-主材采购进度表 预警
     *
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "factBuyWarn")
    public CommonResponse<String> factBuyWarn(@RequestBody JSONObject jsonParam) {
        //1.接收预警参数
        logger.info("接收到Task参数：{}", jsonParam);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);
        //当前月是否已经做单
        Integer count = factBuyService.isHaveDone();
        if (count > 0) {
            logger.error("执行" + FACTBUY_WARN_NAME + "完成，未发现有匹配预警规则的单据信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        //3.发送信息
        String warnLevel = defaultWarnInfo.getString("warnLevel");
        EarlyWarnTransVO vo = new EarlyWarnTransVO();
        vo.setBillName("主材采购进度表");
        vo.setOrgId(FORMAL_ORG_ID);
        vo.setOrgName("巨力索具股份有限公司");
        vo.setPcTitle("主材采购进度表");
        vo.setPcUrl(FACTBUY_URL);
        vo.setTenantId(999999L);
        vo.setWarnLevel(warnLevel);
        vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
        vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
        tmpContent = defaultWarnInfo.getString("earlywarnContent");
        vo.setEarlywarnContent(tmpContent.replaceAll("#name#", "主材采购进度表"));
        resp.add(vo);
        return sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    /**
     * 生产厂-内部协作进度表 预警
     *
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "factShareWarn")
    public CommonResponse<String> factShareWarn(@RequestBody JSONObject jsonParam) {
        //1.接收预警参数
        logger.info("接收到Task参数：{}", jsonParam);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);
        //当前月是否已经做单
        Integer count = factShareService.isHaveDone();
        if (count > 0) {
            logger.error("执行" + FACTSHARE_WARN_NAME + "完成，未发现有匹配预警规则的单据信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        //3.发送信息
        String warnLevel = defaultWarnInfo.getString("warnLevel");
        EarlyWarnTransVO vo = new EarlyWarnTransVO();
        vo.setBillName("内部协作进度表");
        vo.setOrgId(FORMAL_ORG_ID);
        vo.setOrgName("巨力索具股份有限公司");
        vo.setPcTitle("内部协作进度表");
        vo.setPcUrl(FACTSHARE_URL);
        vo.setTenantId(999999L);
        vo.setWarnLevel(warnLevel);
        vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
        vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
        tmpContent = defaultWarnInfo.getString("earlywarnContent");
        vo.setEarlywarnContent(tmpContent.replaceAll("#name#", "内部协作进度表"));
        resp.add(vo);
        return sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    /**
     * 生产厂-制造厂外协/外购产品进度明细表 预警
     *
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "factProgressWarn")
    public CommonResponse<String> factProgressWarn(@RequestBody JSONObject jsonParam) {
        //1.接收预警参数
        logger.info("接收到Task参数：{}", jsonParam);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);
        //当前月是否已经做单
        Integer count = factProgressService.isHaveDone();
        if (count > 0) {
            logger.error("执行" + FACTPROGRESS_WARN_NAME + "完成，未发现有匹配预警规则的单据信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        //3.发送信息
        String warnLevel = defaultWarnInfo.getString("warnLevel");
        EarlyWarnTransVO vo = new EarlyWarnTransVO();
        vo.setBillName("制造厂外协/外购产品进度明细表");
        vo.setOrgId(FORMAL_ORG_ID);
        vo.setOrgName("巨力索具股份有限公司");
        vo.setPcTitle("制造厂外协/外购产品进度明细表");
        vo.setPcUrl(FACTPROGRESS_URL);
        vo.setTenantId(999999L);
        vo.setWarnLevel(warnLevel);
        vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
        vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
        tmpContent = defaultWarnInfo.getString("earlywarnContent");
        vo.setEarlywarnContent(tmpContent.replaceAll("#name#", "制造厂外协/外购产品进度明细表"));
        resp.add(vo);
        return sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    /**
     * 生产厂-制造厂计划单台账 预警
     *
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "factPlanWarn")
    public CommonResponse<String> factPlanWarn(@RequestBody JSONObject jsonParam) {
        //1.接收预警参数
        logger.info("接收到Task参数：{}", jsonParam);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);
        //当前月是否已经做单
        Integer count = factPlanService.isHaveDone();
        if (count > 0) {
            logger.error("执行" + FACTPLAN_WARN_NAME + "完成，未发现有匹配预警规则的单据信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        //3.发送信息
        String warnLevel = defaultWarnInfo.getString("warnLevel");
        EarlyWarnTransVO vo = new EarlyWarnTransVO();
        vo.setBillName("制造厂计划单台账");
        vo.setOrgId(FORMAL_ORG_ID);
        vo.setOrgName("巨力索具股份有限公司");
        vo.setPcTitle("制造厂计划单台账");
        vo.setPcUrl(FACTPLAN_URL);
        vo.setTenantId(999999L);
        vo.setWarnLevel(warnLevel);
        vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
        vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
        tmpContent = defaultWarnInfo.getString("earlywarnContent");
        vo.setEarlywarnContent(tmpContent.replaceAll("#name#", "制造厂计划单台账"));
        resp.add(vo);
        return sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    /**
     * 工程技术-型式试验情况 预警
     *
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "techTestWarn")
    public CommonResponse<String> techTestWarn(@RequestBody JSONObject jsonParam) {
        //1.接收预警参数
        logger.info("接收到Task参数：{}", jsonParam);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);
        //当前月是否已经做单
        Integer count = techTestService.isHaveDone();
        if (count > 0) {
            logger.error("执行" + TECHTEST_WARN_NAME + "完成，未发现有匹配预警规则的单据信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        //3.发送信息
        String warnLevel = defaultWarnInfo.getString("warnLevel");
        EarlyWarnTransVO vo = new EarlyWarnTransVO();
        vo.setBillName("型式试验情况");
        vo.setOrgId(FORMAL_ORG_ID);
        vo.setOrgName("巨力索具股份有限公司");
        vo.setPcTitle("型式试验情况");
        vo.setPcUrl(TECHTEST_URL);
        vo.setTenantId(999999L);
        vo.setWarnLevel(warnLevel);
        vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
        vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
        tmpContent = defaultWarnInfo.getString("earlywarnContent");
        vo.setEarlywarnContent(tmpContent.replaceAll("#name#", "型式试验情况"));
        resp.add(vo);
        return sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    /**
     * 工程技术-科技成果奖项申报情况 预警
     *
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "techSituationWarn")
    public CommonResponse<String> techSituationWarn(@RequestBody JSONObject jsonParam) {
        //1.接收预警参数
        logger.info("接收到Task参数：{}", jsonParam);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);
        //当前月是否已经做单
        Integer count = techSituationService.isHaveDone();
        if (count > 0) {
            logger.error("执行" + TECHSITUATION_WARN_NAME + "完成，未发现有匹配预警规则的单据信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        //3.发送信息
        String warnLevel = defaultWarnInfo.getString("warnLevel");
        EarlyWarnTransVO vo = new EarlyWarnTransVO();
        vo.setBillName("科技成果奖项申报情况");
        vo.setOrgId(FORMAL_ORG_ID);
        vo.setOrgName("巨力索具股份有限公司");
        vo.setPcTitle("科技成果奖项申报情况");
        vo.setPcUrl(TECHSITUATION_URL);
        vo.setTenantId(999999L);
        vo.setWarnLevel(warnLevel);
        vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
        vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
        tmpContent = defaultWarnInfo.getString("earlywarnContent");
        vo.setEarlywarnContent(tmpContent.replaceAll("#name#", "科技成果奖项申报情况"));
        resp.add(vo);
        return sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    /**
     * 工程技术-方案图一览表 预警
     *
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "techSchemeWarn")
    public CommonResponse<String> techSchemeWarn(@RequestBody JSONObject jsonParam) {
        //1.接收预警参数
        logger.info("接收到Task参数：{}", jsonParam);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);
        //当前月是否已经做单
        Integer count = techSchemeService.isHaveDone();
        if (count > 0) {
            logger.error("执行" + TECHSCHEME_WARN_NAME + "完成，未发现有匹配预警规则的单据信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        //3.发送信息
        String warnLevel = defaultWarnInfo.getString("warnLevel");
        EarlyWarnTransVO vo = new EarlyWarnTransVO();
        vo.setBillName("方案图一览表");
        vo.setOrgId(FORMAL_ORG_ID);
        vo.setOrgName("巨力索具股份有限公司");
        vo.setPcTitle("方案图一览表");
        vo.setPcUrl(TECHSCHEME_URL);
        vo.setTenantId(999999L);
        vo.setWarnLevel(warnLevel);
        vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
        vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
        tmpContent = defaultWarnInfo.getString("earlywarnContent");
        vo.setEarlywarnContent(tmpContent.replaceAll("#name#", "方案图一览表"));
        resp.add(vo);
        return sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    /**
     * 工程技术-在执行订单 预警
     *
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "techOrderWarn")
    public CommonResponse<String> techOrderWarn(@RequestBody JSONObject jsonParam) {
        //1.接收预警参数
        logger.info("接收到Task参数：{}", jsonParam);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);
        //当前月是否已经做单
        Integer count = techOrderService.isHaveDone();
        if (count > 0) {
            logger.error("执行" + TECHORDER_WARN_NAME + "完成，未发现有匹配预警规则的单据信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        //3.发送信息
        String warnLevel = defaultWarnInfo.getString("warnLevel");
        EarlyWarnTransVO vo = new EarlyWarnTransVO();
        vo.setBillName("在执行订单");
        vo.setOrgId(FORMAL_ORG_ID);
        vo.setOrgName("巨力索具股份有限公司");
        vo.setPcTitle("在执行订单");
        vo.setPcUrl(TECHORDER_URL);
        vo.setTenantId(999999L);
        vo.setWarnLevel(warnLevel);
        vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
        vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
        tmpContent = defaultWarnInfo.getString("earlywarnContent");
        vo.setEarlywarnContent(tmpContent.replaceAll("#name#", "在执行订单"));
        resp.add(vo);
        return sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }

    /**
     * 项目计划查看-工序延期预警
     * 定时预警
     *
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "execPlanWarn")
    public CommonResponse<String> execPlanWarn(@RequestBody JSONObject jsonParam) {
        //1.接收预警参数
        logger.info("接收到Task参数：{}", jsonParam);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);

        //2.项目计划查看-工序延期
        List<ExecPlanWarnDetailVO> recordVOList = execPlanService.getPostponeList();

        if (CollectionUtils.isEmpty(recordVOList)) {
            logger.error("执行" + EXECPLAN_WARN_NAME + "完成，未发现有匹配预警规则的单据信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        logger.info("项目计划查看-工序延期：{}", JSONObject.toJSONString(recordVOList));

        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;

        //3.筛出符合条件的数据发送信息
        for (ExecPlanWarnDetailVO detailVO : recordVOList) {
            String warnLevel = defaultWarnInfo.getString("warnLevel");
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName(detailVO.getProjectName());
            vo.setPcTitle("项目计划查看");
            vo.setPcUrl(EXECPLAN_URL+"/card?id="+detailVO.getCarId());
            vo.setOrgId(detailVO.getOrgId());
            vo.setOrgName(detailVO.getOrgName());
            vo.setTenantId(999999L);
            vo.setWarnLevel(warnLevel);
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            List<WarningReceiveVO> receiveList = new ArrayList<>();
            WarningReceiveVO receiveVO = new WarningReceiveVO();
            receiveVO.setName(detailVO.getEmployeeName());//负责人名称
            receiveVO.setNameId(Long.valueOf(detailVO.getEmployeeId()));//负责人id
            receiveVO.setType("user"); //类型
            receiveList.add(receiveVO);
            vo.setReceiveList(receiveList);

            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", detailVO.getProjectName()).replaceAll("#component#", detailVO.getComponent()).replaceAll("#name#", detailVO.getName()));
            resp.add(vo);
        }
        return sendWarnToTaskWithReceive(resp, defaultWarnInfo.getLong("warnSetId"));
    }


    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, Long warnId) {
        logger.info("发送任务：{}", JSONObject.toJSONString(warnList));
        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenter(warnList, warnId);
        if (!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }

        return CommonResponse.success("任务接受处理成功！");
    }
    private CommonResponse<String> sendWarnToTaskWithReceive(List<EarlyWarnTransVO> warnList, Long warnId) {
        logger.info("发送任务：{}", JSONObject.toJSONString(warnList));
        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenterWithReceive(warnList, warnId);
        if (!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }

        return CommonResponse.success("任务接受处理成功！");
    }


private BigDecimal getBigDecimal(Object obj) {
        return null == obj ? BigDecimal.ZERO : new BigDecimal(obj.toString());
    }

}
