package com.ejianc.business.jlprogress.progress.bean;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.business.jlprogress.progress.vo.TotalPlanDetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 总计划详情
 *
 * @author generator
 */
@TableName("ejc_zjkjprogress_total_plan_detail")
public class TotalPlanDetailEntity extends ProgressDetailEntity {
    private static final long serialVersionUID = 1L;


    @TableField(value = "task_line")
    private Integer taskLine; // 任务条线(手续线、设计线、建造线、招采线)
    @TableField(value = "node_level")
    private Integer nodeLevel; // 节点级别
    @TableField(value = "employee_id")
    private String employeeId; // 负责人主键
    @TableField(value = "employee_name")
    private String employeeName; // 负责人名称
    @TableField(value = "plan_num")
    private BigDecimal planNum; // 工程量
    @TableField(value = "unit")
    private Integer unit; // 单位(枚举格式， 包含：㎡、m、m3、kg、t、个)
    @TableField(value = "resource_name")
    private String resourceName; // 资源名称
    @TableField(value = "type")
    private Integer type; // 资源类型(劳动力、材料、机械)
    @TableField(value = "type_unit")
    private Integer typeUnit; // 资源单位(㎡、m、m3、kg、t、个、台班、工日)
    @TableField(value = "need_num")
    private BigDecimal needNum; // 需求量

    @TableField(exist=false)
    private Long sourceBid; // 执行计划明细主键

    @TableField(exist=false)
    private List<TotalPlanDetailEntity> children = new ArrayList<>();// 子任务

    public List<TotalPlanDetailEntity> getChildren() {
        return children;
    }

    public void setChildren(List<TotalPlanDetailEntity> children) {
        this.children = children;
    }

    public Long getSourceBid() {
        return sourceBid;
    }

    public void setSourceBid(Long sourceBid) {
        this.sourceBid = sourceBid;
    }

    public Integer getTaskLine() {
        return taskLine;
    }

    public void setTaskLine(Integer taskLine) {
        this.taskLine = taskLine;
    }

    public Integer getNodeLevel() {
        return nodeLevel;
    }

    public void setNodeLevel(Integer nodeLevel) {
        this.nodeLevel = nodeLevel;
    }

    public String getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(String employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public BigDecimal getPlanNum() {
        return planNum;
    }

    public void setPlanNum(BigDecimal planNum) {
        this.planNum = planNum;
    }

    public Integer getUnit() {
        return unit;
    }

    public void setUnit(Integer unit) {
        this.unit = unit;
    }

    public String getResourceName() {
        return resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getTypeUnit() {
        return typeUnit;
    }

    public void setTypeUnit(Integer typeUnit) {
        this.typeUnit = typeUnit;
    }

    public BigDecimal getNeedNum() {
        return needNum;
    }

    public void setNeedNum(BigDecimal needNum) {
        this.needNum = needNum;
    }


    /**
     * entity to vo
     */
    public static TotalPlanDetailVO convertEntityToVo(TotalPlanDetailEntity entity) {
        TotalPlanDetailEntity copy = BeanMapper.map(entity, TotalPlanDetailEntity.class);
        Long id = copy.getId();
        copy.setId(1L);
        String predecessorLink = copy.getPredecessorLink();
        copy.setPredecessorLink(null);
        String assignments = copy.getAssignments();
        copy.setAssignments(null);
        TotalPlanDetailVO vo = BeanMapper.map(copy, TotalPlanDetailVO.class);
        vo.setUid(id.toString());
        vo.setProjectUID(copy.getProjectId());
        vo.setParentTaskUID(copy.getParentId() + "");
        if (StringUtils.isNotBlank(assignments)) {
            vo.setAssignments(JSON.parseArray(assignments));
        }
        vo.setNote(copy.getNotes());
        vo.setId(copy.getTid());
        if(StringUtils.isNotBlank(predecessorLink)) {
            vo.setPredecessorLink(JSON.parseArray(predecessorLink));
        }
        return vo;
    }

    /**
     * vo to entity
     */
    public static TotalPlanDetailEntity convertVoToEntity(TotalPlanDetailVO vo) {
        TotalPlanDetailEntity entity = BeanMapper.map(vo, TotalPlanDetailEntity.class);
        if(StringUtils.isNotBlank(vo.getUid())) {
            entity.setId(Long.parseLong(vo.getUid()));
        }
        entity.setProjectId(vo.getProjectUID());
        if(StringUtils.isNotBlank(vo.getParentTaskUID())) {
            entity.setParentId(Long.parseLong(vo.getParentTaskUID()));
        }
        if(vo.getAssignments() != null && vo.getAssignments().size() > 0) {
            entity.setAssignments(JSON.toJSONString(vo.getAssignments()));
        }
        entity.setNotes(vo.getNote());
        entity.setTid(vo.getId());
        if(vo.getPredecessorLink() != null && vo.getPredecessorLink().size() > 0) {
            entity.setPredecessorLink(JSON.toJSONString(vo.getPredecessorLink()));
        }
        return entity;
    }
}
