package com.ejianc.business.jlprogress.progress.service;

import com.ejianc.business.jlprogress.progress.bean.ExecPlanEntity;
import com.ejianc.business.jlprogress.progress.vo.ExecPlanDetailVO;
import com.ejianc.business.jlprogress.progress.vo.ExecPlanVO;
import com.ejianc.business.jlprogress.progress.vo.ExecPlanWarnDetailVO;
import com.ejianc.business.jlprogress.progress.vo.XmlVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 执行计划
 * 
 * @author generator
 * 
 */
public interface IExecPlanService extends IBaseService<ExecPlanEntity> {

    ExecPlanVO saveOrUpdate(ExecPlanVO saveOrUpdateVO);

    /**
     * 根据主键查询详情
     * @param id
     * @return
     */
    ExecPlanVO queryDetail(Long id);

    /**
     * 根据主键、计划标识
     * @param id
     * @param planState 1-总计划、2-年计划、3-月计划、4-周计划
     * @param startDate 计划开始日期
     * @param endDate 计划结束日期
     * @param asc   true-向上兼容，false-向下兼容
     * @return
     */
    ExecPlanVO queryDetail(Long id, Integer planState, Date startDate, Date endDate, Boolean asc);

    ExecPlanVO queryDetail(Long id, Integer planState, Date startDate, Date endDate, Boolean asc, Boolean changeFlag);

    ExecPlanVO queryDetail(Long id, Integer planState, Date startDate, Date endDate, Boolean asc, Boolean changeFlag, Boolean addFlag);

    /**
     * 根据项目主键，查询对应执行计划，按照开始日期、结束日期截取
     * @param projectId 项目主键
     * @param planState 1-总计划、2-年计划、3-月计划、4-周计划，默认向上兼容，即为3时，查询"1,2,3"
     * @param startDate 到天即可，会处理成当天00:00:00
     * @param endDate   到天即可，会处理成当天23:59:59
     * @return
     */
    ExecPlanVO queryRefDetail(Long projectId, Integer planState, Date startDate, Date endDate);

    ExecPlanVO queryRefDetail(Long projectId, Integer planState, Date startDate, Date endDate, Boolean changeFlag);

    ExecPlanVO queryRefDetail(Long projectId, Integer planState, Date startDate, Date endDate, Boolean changeFlag, Boolean addFlag);

    /**
     * 根据主键，查询对应执行计划，转成map
     * @param vo id
     * @param vo planState 1-总计划、2-年计划、3-月计划、4-周计划，默认向下兼容，即为1时，查询"1,2,3,4"
     * @param vo startDate 计划开始日期
     * @param vo endDate 计划结束日期
     * @return
     */
    Map<String, Object> getDetail(XmlVO vo);

    /**
     * 推送执行计划
     * @param id 来源单据主键
     * @param planState 1-总计划、2-年计划、3-月计划、4-周计划
     * @return
     */
    ExecPlanEntity pushExecPlan(Long id, Integer planState);

    /**
     * 推送执行计划回退
     * @param id 来源单据主键
     * @param planState 1-总计划、2-年计划、3-月计划、4-周计划
     * @return
     */
    ExecPlanEntity pushExecPlanRollBack(Long id, Integer planState);

    /**
     * 更新执行计划
     * @param id 来源单据主键
     * @param planState 1-总计划、2-年计划、3-月计划、4-周计划
     * @return
     */
    ExecPlanEntity updateExecPlan(Long id, Integer planState);

    void exportxml(HttpServletResponse response, XmlVO vo);

    CommonResponse<HashMap> getxml(HttpServletRequest request);

    String validateProject(Long projectId, Long billId);

    String validateProject(Long projectId, Long billId, Long fillUserId);

    Object converMap(Object obj, Date startDate, Date endDate, Long projectId);

    String initTable();

    List<ExecPlanWarnDetailVO> getPostponeList();
}
