package com.ejianc.business.jlprogress.progress.service.impl;

import com.ejianc.business.jlprogress.progress.bean.ExecPlanDetailEntity;
import com.ejianc.business.jlprogress.progress.mapper.ExecPlanDetailMapper;
import com.ejianc.business.jlprogress.progress.service.IExecPlanDetailService;
import com.ejianc.business.jlprogress.progress.utils.NumberUtil;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;

/**
 * 执行计划详情
 * 
 * @author generator
 * 
 */
@Service("execPlanDetailService")
public class ExecPlanDetailServiceImpl extends BaseServiceImpl<ExecPlanDetailMapper, ExecPlanDetailEntity> implements IExecPlanDetailService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Override
    public Boolean writeBackFinishNum(String wbs, BigDecimal num, Boolean flag) {
        QueryParam param = new QueryParam();
        param.getParams().put("wbs", new Parameter(QueryParam.EQ, wbs));
        List<ExecPlanDetailEntity> list = super.queryList(param);
        for(ExecPlanDetailEntity vo : list){
            if(flag){
                vo.setFinishNum(ComputeUtil.safeAdd(vo.getFinishNum(), ComputeUtil.scale(num, 2)));
            } else {
                vo.setFinishNum(ComputeUtil.safeSub(vo.getFinishNum(), ComputeUtil.scale(num, 2)));
            }
            logger.info(vo.getId()+" 计算开始----finishNum："+vo.getFinishNum()+"  planNum:"+vo.getPlanNum());
            vo.setPercentComplete(NumberUtil.bigDecimalPercent(vo.getFinishNum(), vo.getPlanNum(), 0).intValue());
            logger.info(vo.getId()+"计算结束----percentComplete："+vo.getPercentComplete());
            Integer finishState = 0;// 未开始
            if(vo.getPercentComplete() > 0){
                if(vo.getPercentComplete() < 100){
                    finishState = 2;// 进行中
                } else {
                    finishState = 1;// 已完成
                }
            }
            // 根据完成百分比给实际时间赋值，组件默认功能
            if(0 == finishState){
                vo.setActualStart(null);
                vo.setActualFinish(null);
            } else if(2 == finishState){
                vo.setActualStart(null != vo.getActualStart() ? vo.getActualStart() : vo.getStart());
                vo.setActualFinish(null);
            } else if(1 == finishState){
                vo.setActualStart(null != vo.getActualStart() ? vo.getActualStart() : vo.getStart());
                vo.setActualFinish(null != vo.getActualFinish() ? vo.getActualFinish() : vo.getFinish());
            }
            vo.setFinishState(finishState);
        }
        if(CollectionUtil.isNotEmpty(list)){
            super.saveOrUpdateBatch(list);
        }
        return true;
    }
}
