package com.ejianc.business.jlprogress.progress.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jlprogress.progress.bean.DayFillEntity;
import com.ejianc.business.jlprogress.progress.service.IDayFillService;
import com.ejianc.business.jlprogress.progress.bean.*;
import com.ejianc.business.jlprogress.progress.cons.PlanCloumCons;
import com.ejianc.business.jlprogress.progress.cons.PlanConstant;
import com.ejianc.business.jlprogress.progress.handler.DurationUtil;
import com.ejianc.business.jlprogress.progress.handler.IPlanHandler;
import com.ejianc.business.jlprogress.progress.handler.PlanFactory;
import com.ejianc.business.jlprogress.progress.mapper.ExecPlanMapper;
import com.ejianc.business.jlprogress.progress.service.*;
import com.ejianc.business.jlprogress.progress.utils.DateUtil;
import com.ejianc.business.jlprogress.progress.utils.Export;
import com.ejianc.business.jlprogress.progress.utils.OrgUtil;
import com.ejianc.business.jlprogress.progress.vo.ExecPlanDetailVO;
import com.ejianc.business.jlprogress.progress.vo.ExecPlanVO;
import com.ejianc.business.jlprogress.progress.vo.ExecPlanWarnDetailVO;
import com.ejianc.business.jlprogress.progress.vo.XmlVO;
import com.ejianc.business.jlprogress.progress.utils.PlusUtil;
import com.ejianc.business.jlprogress.progress.utils.TreeHelper2;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 执行计划
 * 
 * @author generator
 * 
 */
@Service("execPlanService")
public class ExecPlanServiceImpl extends BaseServiceImpl<ExecPlanMapper, ExecPlanEntity> implements IExecPlanService{

    private static final String BILL_CODE = "ZJKJ_EXEC_PLAN";

    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    @Autowired
    private OrgUtil orgUtil;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IExecPlanDetailService detailService;

    @Autowired
    private PlanFactory factory;

    @Autowired
    private ITotalPlanService totalPlanService;
    @Autowired
    private IYearPlanService yearPlanService;
//    @Autowired
//    private IMonthPlanService monthPlanService;
//    @Autowired
//    private IWeekPlanService weekPlanService;

    @Autowired
    private IDayFillService dayService;

    @Override
    public ExecPlanVO saveOrUpdate(ExecPlanVO saveOrUpdateVO) {
        LambdaQueryWrapper<ExecPlanEntity> ew = new LambdaQueryWrapper<>();
        ew.eq(ExecPlanEntity::getProjectId, saveOrUpdateVO.getProjectId());
        ew.ne(null != saveOrUpdateVO.getId(), ExecPlanEntity::getId, saveOrUpdateVO.getId());
        List<ExecPlanEntity> list = super.list(ew);
        if (CollectionUtils.isNotEmpty(list)) {
            throw new BusinessException("该项目已存在执行计划");
        }
        // 主表新增/修改
        ExecPlanEntity entity = BeanMapper.map(saveOrUpdateVO,ExecPlanEntity.class);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        // 赋值区域公司
        OrgVO org = orgUtil.findById(entity.getOrgId());
        entity.setCorpId(org.getId());
        entity.setCorpCode(org.getCode());
        entity.setCorpName(org.getName());
        super.saveOrUpdate(entity);
        // 子表新增/修改
        List<ExecPlanDetailVO> detailList = saveOrUpdateVO.getTasks();
        if (CollectionUtils.isNotEmpty(detailList)) {
            List<ExecPlanDetailVO> voList = TreeHelper2.tree2List(detailList);
            List<ExecPlanDetailEntity> saveList = new ArrayList<>();
            for (ExecPlanDetailVO vo : voList) {
                if("added".equals(vo.get_state()) || "modified".equals(vo.get_state())){
                    ExecPlanDetailEntity detail = ExecPlanDetailEntity.convertVoToEntity(vo);
                    detail.setProgressId(entity.getId());
                    saveList.add(detail);
                }
            }
            if(CollectionUtils.isNotEmpty(saveList)){
                detailService.saveOrUpdateBatch(saveList);
            }
        }
        //子表删除
        List<ExecPlanDetailVO> delList = saveOrUpdateVO.getRemovedTasks();
        if (CollectionUtils.isNotEmpty(delList)) {
            List<String> delIds = new ArrayList<>();
            for (ExecPlanDetailVO vo : delList) {
                delIds.add(vo.getUid());
            }
            if(CollectionUtils.isNotEmpty(delIds)){
                detailService.removeByIds(delIds);
            }
        }
        return this.queryDetail(entity.getId());
    }

    @Override
    public ExecPlanVO queryDetail(Long id) {
        ExecPlanEntity entity = baseMapper.selectById(id);
        //查询子表
        QueryWrapper<ExecPlanDetailEntity> ew = new QueryWrapper<>();
        ew.eq("progress_id", id);
        ew.orderByAsc("tid");
        List<ExecPlanDetailEntity> detailList = detailService.list(ew);
        ExecPlanVO vo = BeanMapper.map(entity, ExecPlanVO.class);
        if(CollectionUtils.isNotEmpty(detailList)) {
//            JSONObject calender = DurationUtil.getCalender(entity.getCalendars(), entity.getCalendarUid());
            List<ExecPlanDetailVO> detailVOList = new ArrayList<>();
            for(ExecPlanDetailEntity detail : detailList) {
                ExecPlanDetailVO data = ExecPlanDetailEntity.convertEntityToVo(detail);
//                // Start和Finish使用预测时间
//                data.setStart(data.getPredictStart());
//                data.setFinish(data.getPredictFinish());
//                if(data.getPredictDuration() != null){
//                    data.setDuration(data.getPredictDuration());
//                } else if(!DateUtil.isSameDay(detail.getStart(), data.getStart()) || !DateUtil.isSameDay(detail.getFinish(), data.getFinish())){
//                    // 重算工期
//                    data.setDuration(DurationUtil.calculateDuration(data.getStart(), data.getFinish(), calender));
//                }
                // 限制日期默认等于开始日期
                data.setConstraintType(2);
                data.setConstraintDate(data.getStart());
                detailVOList.add(data);
            }
            vo.setProgressDetailList(TreeHelper2.list2Tree(detailVOList));
        }
        return vo;
    }

    /**
     * 根据计划类型查询
     * @param id
     * @param planState 1-总计划、2-年计划、3-月计划、4-周计划
     * @param startDate 计划开始日期
     * @param endDate 计划结束日期
     * @param asc true-向上兼容（参照），false-向下兼容（导出）
     * @return
     */
    @Override
    public ExecPlanVO queryDetail(Long id, Integer planState, Date startDate, Date endDate, Boolean asc) {
        return this.queryDetail(id, planState, startDate, endDate, asc, false);
    }

    @Override
    public ExecPlanVO queryDetail(Long id, Integer planState, Date startDate, Date endDate, Boolean asc, Boolean changeFlag) {
        return this.queryDetail(id, planState, startDate, endDate, asc, changeFlag, false);
    }

    @Override
    public ExecPlanVO queryDetail(Long id, Integer planState, Date startDate, Date endDate, Boolean asc, Boolean changeFlag, Boolean addFlag) {
        ExecPlanEntity entity = baseMapper.selectById(id);
        if(entity == null) {
            throw new BusinessException("未查询到执行计划！");
        }
        //查询子表
        QueryWrapper<ExecPlanDetailEntity> ew = new QueryWrapper<>();
        ew.eq("progress_id", id);
        ew.orderByAsc("tid");
        // 向下兼容查询
        String states = null;
        if(PlanConstant.TOTAL_PLAN.equals(planState)){
            states = !asc ? "1,2,3,4" : "1";
        } else if(PlanConstant.YEAR_PLAN.equals(planState)){
            states = "1,2";
        } else if(PlanConstant.MONTH_PLAN.equals(planState)){
            states = "1,2,3";
        } else if(PlanConstant.WEEK_PLAN.equals(planState)){
            states = "1,2,3,4";
        }
        if(StringUtils.isNotEmpty(states)){
            if(BooleanUtils.isTrue(addFlag)){
                String finalStates = states;
                ew.and(x->x.in("plan_state", Arrays.asList(finalStates.split(","))).or().isNull("actual_finish"));
            } else {
                ew.in("plan_state", Arrays.asList(states.split(",")));
            }
        }
        List<ExecPlanDetailEntity> detailList = detailService.list(ew);
        ExecPlanVO vo = BeanMapper.map(entity, ExecPlanVO.class);
        List<ExecPlanDetailVO> detailVOList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(detailList)) {
            for(ExecPlanDetailEntity detail : detailList) {
                detailVOList.add(ExecPlanDetailEntity.convertEntityToVo(detail));
            }
            // list2Tree在原List里加了children，造成重复
            List<ExecPlanDetailVO> list = Utils.deepCopy(detailVOList);
            List<ExecPlanDetailVO> allList = TreeHelper2.list2Tree(list);
            vo.setAllList(Utils.deepCopy(allList));
            vo.setProgressDetailList(allList);
        }
        // 按开始日期和结束日期截取
        if(startDate == null || endDate == null){
            return vo;
        }
        startDate = DateUtil.addHours(DateUtil.beginOfDate(startDate), 8);// 开始时间加8小时
        endDate = DateUtil.endOfDate(endDate);
        // 日历
        JSONObject calender = DurationUtil.getCalender(entity.getCalendars(), entity.getCalendarUid());
        List<ExecPlanDetailVO> resultList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(detailVOList)) {
            for(ExecPlanDetailVO detail : detailVOList) {
                // 开始日期大于预测结束日期，过滤
                if(DateUtil.compareDate(startDate, detail.getPredictFinish()) > 0){
                    continue;
                }
                // 结束日期小于预测开始日期，过滤
                if(DateUtil.compareDate(endDate, detail.getPredictStart()) < 0){
                    continue;
                }
                if(DateUtil.compareDate(detail.getPredictStart(), startDate) <= 0){
                    detail.setStart(startDate);
                } else {
                    detail.setStart(detail.getPredictStart());
                }
                if(DateUtil.compareDate(detail.getPredictFinish(), endDate) >= 0){
                    detail.setFinish(endDate);
                }
                else {
                    detail.setFinish(detail.getPredictFinish());
                }
                // 限制日期默认等于开始日期
                if(detail.getConstraintDate() != null){
                    detail.setConstraintDate(DurationUtil.getConstraintDate(detail.getStart(), detail.getFinish(), detail.getConstraintType()));
                }
                // 如果限制类型是越早越好的，默认改为限制不得早于...开始
                if(detail.getConstraintType() == 0){
                    detail.setConstraintType(4);
                    detail.setConstraintDate(detail.getStart());
                }
                // 重新计算工期
                Integer duration = DurationUtil.calculateDuration(detail.getStart(), detail.getFinish(), calender);
                detail.setDuration(duration);
                // 预测完成-计划开始
                Integer term = DateUtil.getBetweenDays(detail.getPredictFinish(), detail.getPlanStart());
                term = term != null ? term + 1 : null;// 完成-开始，加一
                // (开始-预测开始)/(预测完成-计划开始)*100
                BigDecimal x = new BigDecimal(detail.getPercentComplete());
                // 完成百分比为0或者变更，需要计算x
                if(ComputeUtil.isEmpty(x) || BooleanUtils.isTrue(changeFlag)){
                    x = ComputeUtil.bigDecimalPercent(DateUtil.getBetweenDays(detail.getStart(), detail.getPredictStart()), term, 0);
                }
                // (完成-预测开始)/(预测完成-计划开始)*100
                Integer fs = DateUtil.getBetweenDays(detail.getFinish(), detail.getPredictStart());
                fs = fs != null ? fs + 1 : null;// 完成-开始，加一
                BigDecimal y = ComputeUtil.bigDecimalPercent(fs, term, 0);
                // y值最大为100
                if(ComputeUtil.isGreaterThan(y, new BigDecimal("100"))){
                    y = new BigDecimal("100");
                }
                // x=0，y=100不显示
                if(!(ComputeUtil.equals(x, BigDecimal.ZERO) && ComputeUtil.equals(y, new BigDecimal("100")))){
                    detail.setPercentTask("(" + x + "%-" + y + "%)");
                }
                // (y-x)/100*总计划中的量
                BigDecimal planNum = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(ComputeUtil.safeSub(y, x), new BigDecimal("100")), detail.getPlanNum());
                detail.setPlanNum(planNum);
                resultList.add(detail);
            }
        }
        vo.setProgressDetailList(TreeHelper2.list2Tree(resultList));
        return vo;
    }

    @Override
    public ExecPlanVO queryRefDetail(Long projectId, Integer planState, Date startDate, Date endDate) {
        return this.queryRefDetail(projectId, planState, startDate, endDate, false);
    }

    @Override
    public ExecPlanVO queryRefDetail(Long projectId, Integer planState, Date startDate, Date endDate, Boolean changeFlag) {
        return this.queryRefDetail(projectId, planState, startDate, endDate, changeFlag, false);
    }

    @Override
    public ExecPlanVO queryRefDetail(Long projectId, Integer planState, Date startDate, Date endDate, Boolean changeFlag, Boolean addFlag) {
        QueryWrapper<ExecPlanEntity> ew = new QueryWrapper<>();
        ew.eq("project_id", projectId);
        ExecPlanEntity entity = baseMapper.selectOne(ew);
        if(entity == null){
            throw new BusinessException("未查询到项目下的总计划！");
        }
        ExecPlanVO vo = this.queryDetail(entity.getId(), planState, startDate, endDate, true, changeFlag, addFlag);
        return vo;
    }

    @Override
    public Map<String, Object> getDetail(XmlVO xml) {
        Long id = xml.getId();
        if(xml.getId() == null && xml.getProjectId() != null){
            QueryWrapper<ExecPlanEntity> ew = new QueryWrapper<>();
            ew.eq("project_id", xml.getProjectId());
            ExecPlanEntity entity = baseMapper.selectOne(ew);
            if(entity == null){
                throw new BusinessException("未查询到项目下的总计划！");
            }
            id = entity.getId();
        }
        ExecPlanVO vo = this.queryDetail(id, xml.getPlanState(), xml.getStartDate(), xml.getEndDate(), false);
        Map<String, Object> map = new HashMap();
        map.put("DefaultStartTime", null);
        map.put("CreationDate", null);
        map.put("DaysPerMonth", null);
        List<ExecPlanDetailVO> detailList = vo.getProgressDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            List<ExecPlanDetailVO> saveVOList = TreeHelper2.tree2List(detailList);
            String jsonString = "";
            try {
                jsonString = new ObjectMapper().writeValueAsString(saveVOList);
            } catch (JsonProcessingException e) {
                e.printStackTrace();
            }
            List<Map> list = JSONObject.parseArray(jsonString, Map.class);
            // 前置任务导出
            for (Map m : list) {
                if (m.get("PredecessorLink") != null) {
                    List<Map> link = JSONObject.parseArray(JSONObject.toJSONString(m.get("PredecessorLink")), Map.class);
                    m.put("PredecessorLink", link);
                }
            }
            // 字段翻译
            TreeHelper2.key2ValueList(list);
            map.put("Tasks", TreeHelper2.listMap2Tree(list));
        } else {
            map.put("Tasks", new ArrayList<>());
        }
        map.put("MinutesPerWeek", null);
        String calendars = vo.getCalendars();
        if (StringUtils.isNotBlank(calendars)) {
            map.put("Calendars", PlusUtil.dealCalendars(calendars));
        } else {
            map.put("Calendars", null);
        }
        map.put("WeekStartDay", null);
        map.put("DefaultFinishTime", null);
        map.put("FinishDate", vo.getPlanEndDate());
        map.put("Name", vo.getProjectName());
        map.put("StartDate", vo.getPlanBeginDate());
        map.put("CalendarUID", vo.getCalendarUid());
        map.put("UID", vo.getId());
        map.put("ExtendedAttributes", null);
        map.put("MinutesPerDay", null);
        map.put("Author", null);
        map.put("Resources", null);
        return map;
    }

    @Override
    public ExecPlanEntity pushExecPlan(Long id, Integer planState) {
        IPlanHandler handler = factory.getHandler(planState);
        ExecPlanEntity entity = handler.handle(id);
        return entity;
    }

    @Override
    public ExecPlanEntity pushExecPlanRollBack(Long id, Integer planState) {
        IPlanHandler handler = factory.getHandler(planState);
        ExecPlanEntity entity = handler.handleRollback(id);
        return entity;
    }

    @Override
    public ExecPlanEntity updateExecPlan(Long id, Integer planState) {
        IPlanHandler handler = factory.getHandler(planState);
        ExecPlanEntity entity = handler.handleUpdate(id);
        return entity;
    }

    @Override
    public CommonResponse<HashMap> getxml(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile file = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            file = entity.getValue();
            String originalFileName = file.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xml".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            HashMap read = PlusUtil.read(file, PlanCloumCons.EXEC_PLAN_CLOUM);
//            Map<String, Map> filed = new HashMap<>();
//            filed.put("taskLine", PlanConstant.TASK_LINE);
//            filed.put("nodeLevel", PlanConstant.NODE_LEVEL);
//            filed.put("unit", PlanConstant.UNIT);
//            filed.put("type", PlanConstant.RESOURCE_TYPE);
//            filed.put("typeUnit", PlanConstant.RESOURCE_UNIT);
            Map<String, Map> filed = PlusUtil.getFieldMap((ArrayList) read.get("ExtendedAttributes"), PlanCloumCons.CUSTOMIZE_CLOMN_MAP);
            return CommonResponse.success("解析数据成功！", PlusUtil.readMain(read, filed));
        }
    }

    @Override
    public String validateProject(Long projectId, Long billId) {
        return this.validateProject(projectId, billId, null);
    }

    @Override
    public String validateProject(Long projectId, Long billId, Long fillUserId) {
        //同一个项目只能存在一个自由态或审批中的单据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));
        if(billId != null){
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, billId));
        }
        if(fillUserId != null){
            queryParam.getParams().put("fillUserId", new Parameter(QueryParam.EQ, fillUserId));
        }
        List<DayFillEntity> dayList = dayService.queryList(queryParam);
//        queryParam.getParams().remove("fillUserId");
        if (CollectionUtils.isNotEmpty(dayList)){
            throw new BusinessException("当前项目下存在非审批通过态的日进度反馈，不允许操作!");
        }
        List<YearPlanEntity> yearList = yearPlanService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(yearList)) {
            throw new BusinessException("当前项目下存在非审批通过态的任务分解，不允许操作!");
        }
        queryParam.getParams().remove("fillUserId");
        ComplexParam c4 = new ComplexParam();
        c4.setLogic(ComplexParam.AND);
        ComplexParam c5 = new ComplexParam();
        c5.setLogic(ComplexParam.OR);
        c5.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        c4.getComplexParams().add(c5);
        ComplexParam c6 = new ComplexParam();
        c6.setLogic(ComplexParam.OR);
        c6.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        c6.getParams().put("change_status", new Parameter(QueryParam.EQ, PlanConstant.CHANGE_ING));
        if(billId != null){
            c6.getParams().put("change_id", new Parameter(QueryParam.NE, billId));
        }
        c4.getComplexParams().add(c6);
        queryParam.getComplexParams().add(c4);

//        ComplexParam c1 = new ComplexParam();
//        c1.setLogic(ComplexParam.OR);
//        c1.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
//        c1.getParams().put("change_status", new Parameter(QueryParam.EQ, PlanConstant.CHANGE_ING));
//        if(billId != null){
//            c1.getParams().put("change_id", new Parameter(QueryParam.NE, billId));
//        }
//        queryParam.getComplexParams().add(c1);
        List<TotalPlanEntity> totalList = totalPlanService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(totalList)) {
            throw new BusinessException("当前项目下存在非审批通过态或变更中的总计划，不允许操作!");
        }
//        List<YearPlanEntity> yearList = yearPlanService.queryList(queryParam, false);
//        if (CollectionUtils.isNotEmpty(yearList)) {
//            throw new BusinessException("当前项目下存在非审批通过态或变更中的年计划，不允许操作!");
//        }
//        List<MonthPlanEntity> monthList = monthPlanService.queryList(queryParam, false);
//        if (CollectionUtils.isNotEmpty(monthList)) {
//            throw new BusinessException("当前项目下存在非审批通过态或变更中的月计划，不允许操作!");
//        }
//        List<WeekPlanEntity> weekList = weekPlanService.queryList(queryParam, false);
//        if (CollectionUtils.isNotEmpty(weekList)) {
//            throw new BusinessException("当前项目下存在非审批通过态或变更中的周计划，不允许操作!");
//        }
        return "校验通过！";
    }

    @Override
    public void exportxml(HttpServletResponse response, XmlVO vo) {
        Map dataProject = this.getDetail(vo);
        Export.exportExtendedAttributes((HashMap) dataProject, PlanCloumCons.CUSTOMIZE_EXEC_CLOMN_MAP);
        PlusUtil.write(response, vo.getFileName(), dataProject, PlanCloumCons.EXEC_PLAN_CLOUM);
    }

    @Override
    public Object converMap(Object obj, Date startDate, Date endDate, Long projectId){
        ExecPlanVO execPlan = this.queryRefDetail(projectId, null , null, null);
        execPlan.setProgressDetailList(TreeHelper2.tree2List(execPlan.getProgressDetailList()));
        Object tranList = converChildren(obj, startDate, endDate, execPlan);
        return tranList;
    }



    private Object converChildren(Object obj, Date startDate, Date endDate, ExecPlanVO execPlan){
        List<ExecPlanDetailVO> detailVOList = execPlan.getProgressDetailList();
        if (null != obj && obj instanceof List){
            List list = new ArrayList();
            for (Object o : (List)obj) {
                Object tranList = null;
                if (o instanceof Map) {
                    Map vo = (Map) o;
                    if(vo.get("ParentTaskUID") == null || "-1".equals(String.valueOf(vo.get("ParentTaskUID"))) && vo.get("structCode") == null){
                        throw new BusinessException("请选择上级计划导出编辑后导入!");
                    }
                    Object children = vo.get("children");
                    if (null != children){
                        tranList = converChildren(children, startDate, endDate, execPlan);
                    }
                    String structCode = String.valueOf(vo.get("structCode"));
                    ExecPlanDetailVO collect = detailVOList.stream().filter(e -> e.getStructCode().equals(structCode)).findAny().orElse(null);
                    // 新增任务
                    if(collect == null){
                        if (this.dealDate(startDate, endDate, execPlan, vo)) continue;
                        vo.put("children", tranList);
                        list.add(vo);
                        continue;
                    }
                    // 参照计划任务
                    try {
                        String jsonString = new ObjectMapper().writeValueAsString(collect);
                        Map<String,Object> map = JSONObject.parseObject(jsonString, Map.class);
                        vo = map;
                    } catch (JsonProcessingException e) {
                        e.printStackTrace();
                    }
                    if (this.dealDate(startDate, endDate, execPlan, vo)) continue;
                    this.dealRef(vo);
                    vo.put("children", tranList);
                    list.add(vo);
                }
            }
            return list;
        }
        return new Object();
    }

    /**
     * 处理x和y
     * @return
     */
    private void dealRef(Map vo) {
        Date start = null;
        Date finish = null;
        Date planStart = null;
        Date predictStart = null;
        Date predictFinish = null;
        try {
            start = sdf.parse(String.valueOf(vo.get("Start")));
            finish = sdf.parse(String.valueOf(vo.get("Finish")));
            planStart = sdf.parse(String.valueOf(vo.get("planStart")));
            predictStart = sdf.parse(String.valueOf(vo.get("predictStart")));
            predictFinish = sdf.parse(String.valueOf(vo.get("predictFinish")));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        BigDecimal planNumDecimal = vo.get("planNum") != null ? new BigDecimal(String.valueOf(vo.get("planNum"))) : null;
        String percentTask = null;
        // 预测完成-计划开始
        Integer term = DateUtil.getBetweenDays(predictFinish, planStart);
        term = term != null ? term + 1 : null;// 完成-开始，加一
        // (开始-预测开始)/(预测完成-计划开始)*100
        BigDecimal x = new BigDecimal(String.valueOf(vo.get("PercentComplete")));
        if(ComputeUtil.isEmpty(x)){
            x = ComputeUtil.bigDecimalPercent(DateUtil.getBetweenDays(start, predictStart), term, 0);
        }
        // (完成-预测开始)/(预测完成-计划开始)*100
        Integer fs = DateUtil.getBetweenDays(finish, predictStart);
        fs = fs != null ? fs + 1 : null;// 完成-开始，加一
        BigDecimal y = ComputeUtil.bigDecimalPercent(fs, term, 0);
        // y值最大为100
        if(ComputeUtil.isGreaterThan(y, new BigDecimal("100"))){
            y = new BigDecimal("100");
        }
        // x=0，y=100不显示
        if(!(ComputeUtil.equals(x, BigDecimal.ZERO) && ComputeUtil.equals(y, new BigDecimal("100")))){
            percentTask = "(" + x + "%-" + y + "%)";
        }
        // (y-x)/100*总计划中的量
        BigDecimal planNum = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(ComputeUtil.safeSub(y, x), new BigDecimal("100")), planNumDecimal);
        vo.put("planNum", planNum);
        if (StringUtils.isNotBlank(percentTask)){
            vo.put("percentTask", percentTask);
            vo.put("Name", String.valueOf(vo.get("Name")) + percentTask);
        }
    }

    /**
     * 截取开始时间，完成时间
     * @return
     */
    private boolean dealDate(Date startDate, Date endDate, ExecPlanVO execPlan, Map vo) {
        JSONObject calender = DurationUtil.getCalender(execPlan.getCalendars(), execPlan.getCalendarUid());
        Date start = null;
        Date finish = null;
        try {
            start = sdf.parse(String.valueOf(vo.get("Start")));
            finish = sdf.parse(String.valueOf(vo.get("Finish")));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        // 开始日期大于预测结束日期，过滤
        if(DateUtil.compareDate(startDate, finish) > 0){
            return true;
        }
        // 结束日期小于预测开始日期，过滤
        if(DateUtil.compareDate(endDate, start) < 0){
            return true;
        }
        if(DateUtil.compareDate(start, startDate) <= 0){
            start = startDate;
        }
        if(DateUtil.compareDate(finish, endDate) >= 0){
            finish = endDate;
        }
        Integer duration = DurationUtil.calculateDuration(start, finish, calender);
        vo.put("sourceId", execPlan.getId());
        vo.put("sourceBid", vo.get("UID"));
        vo.put("Start", sdf.format(start));
        vo.put("Finish", sdf.format(finish));
        vo.put("Duration", duration);
        Integer constraintType = Integer.valueOf(String.valueOf(vo.get("ConstraintType")));
        if(vo.get("ConstraintDate") != null){
            Date constraintDate = DurationUtil.getConstraintDate(start, finish, constraintType);
            vo.put("ConstraintDate", sdf.format(constraintDate));
        }
        // 如果限制类型是越早越好的，默认改为限制不得早于...开始
        if(constraintType == 0){
            vo.put("ConstraintType", 4);
            vo.put("ConstraintDate", sdf.format(start));
        }
        // 固定日期
        vo.put("FixedDate", 1);
        return false;
    }

    public static void main(String[] args) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date start = sdf.parse("2023-01-01");
            Date finish = sdf.parse("2023-01-31");
            Date planStart = sdf.parse("2022-12-01");
            Date predictFinish = sdf.parse("2023-01-31");
            // 预测完成-计划开始
            Integer term = DateUtil.getBetweenDays(predictFinish, planStart) + 1;
            // (开始-计划开始)/(预测完成-计划开始)*100
//            BigDecimal x = ComputeUtil.bigDecimalPercent(DateUtil.getBetweenDays(start, planStart), term, 0);
            BigDecimal x = new BigDecimal(3);
            // (完成-计划开始)/(预测完成-计划开始)*100
            BigDecimal y = ComputeUtil.bigDecimalPercent(DateUtil.getBetweenDays(finish, planStart) + 1, term, 0);
            System.out.println(x + "%-" + y + "%");
        } catch (ParseException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String initTable() {
        execute("10.211.76.201", "bm_prod_user", "17Liancloud123!@#", null, null, null, "31147");
        return "执行成功！";
    }


    @Override
    public List<ExecPlanWarnDetailVO> getPostponeList() {
        return baseMapper.getPostponeList();
    }

    private void execute(String url, String rootName, String rootPwd, String dbName, String userName, String password, String port) {
        String connectUrl = "jdbc:mysql://" + url + ":" + port + "/?useUnicode=true&characterEncoding=UTF-8&useSSL=false&allowMultiQueries=true";
        Connection connection = null;
        try {
            Class.forName("com.mysql.jdbc.Driver");
            connection = DriverManager.getConnection(connectUrl, rootName, rootPwd);
            initTable(connection);
        } catch (SQLException | ClassNotFoundException | IOException e) {
            // 异常处理

        } finally {
            if (connection != null) {
                try {
                    connection.close();
                } catch (SQLException e) {
                    // 异常处理
                }
            }
        }
    }

    private void initTable(Connection connection) throws IOException {
        // sql 脚本
        ClassPathResource classPathResource = new ClassPathResource("sql/initTable.sql");
        InputStream inputStream = classPathResource.getInputStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        ScriptRunner scriptRunner = new ScriptRunner(connection);
        // 必须设置该参数为true，否则无法执行begin……end;
        scriptRunner.setSendFullScript(true);
        scriptRunner.runScript(inputStreamReader);
    }
}