package com.ejianc.business.jlprogress.tech.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.jlprogress.tech.bean.TechCooperationDetailsEntity;
/**
 * 工程技术-工程产业战略技术合作一览表
 *
 * @author generator
 *
 */
@TableName("ejc_tech_cooperation")
public class TechCooperationEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 组织ID(区域)
    @TableField(value="org_code")
    private String orgCode; // 组织code(区域)
    @TableField(value="org_name")
    private String orgName; // 组织名称(区域)
    @TableField(value="unit_id")
    private Long unitId; // 单位名称id(客户)
    @TableField(value="unit_name")
    private String unitName; // 单位名称name
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）


    @TableField(exist=false)
    @SubEntity(serviceName="techCooperationDetailsService", pidName = "cooperationId")
    private List<TechCooperationDetailsEntity> techCooperationDetailsList = new ArrayList<>(); // 工程产业战略技术合作一览表-子表


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }


    public List<TechCooperationDetailsEntity> getTechCooperationDetailsList() {
        return techCooperationDetailsList;
    }

    public void setTechCooperationDetailsList(List<TechCooperationDetailsEntity> techCooperationDetailsList) {
        this.techCooperationDetailsList = techCooperationDetailsList;
    }
}
