package com.ejianc.business.jlprogress.tech.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jlprogress.progress.utils.DateUtil;
import com.ejianc.business.jlprogress.tech.bean.TechOrderDetailEntity;
import com.ejianc.business.jlprogress.tech.bean.TechOrderEntity;
import com.ejianc.business.jlprogress.tech.bean.TechSchemeDetailEntity;
import com.ejianc.business.jlprogress.tech.service.ITechSchemeDetailService;
import com.ejianc.business.jlprogress.tech.vo.EngineeringReportVO;
import com.ejianc.business.jlprogress.tech.vo.TechOrderDetailVO;
import com.ejianc.business.jlprogress.tech.vo.TechSchemeDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jlprogress.tech.bean.TechSchemeEntity;
import com.ejianc.business.jlprogress.tech.service.ITechSchemeService;
import com.ejianc.business.jlprogress.tech.vo.TechSchemeVO;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 工程技术-方案图一览表-主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("techScheme")
public class TechSchemeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "TECH-SCHEME";//此处需要根据实际修改

    @Autowired
    private ITechSchemeService service;
    @Autowired
    private ITechSchemeDetailService techSchemeDetailService;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IDefdocApi defdocApi;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TechSchemeVO> saveOrUpdate(@RequestBody TechSchemeVO saveOrUpdateVO) {
        //一个月只能做一条数据
        QueryWrapper curQuery = new QueryWrapper();
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM");
        String month = sdf1.format(saveOrUpdateVO.getMonth());
        curQuery.eq("DATE_FORMAT(month, '%Y-%m' )",month);
        if(saveOrUpdateVO.getId() != null){
            curQuery.ne("id",saveOrUpdateVO.getId());
        }
        int curCount = service.count(curQuery);
        if (curCount > 0) throw new BusinessException("一个月只能做一条数据！");

    	TechSchemeEntity entity = BeanMapper.map(saveOrUpdateVO, TechSchemeEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //赋值子表月份数据
        List<TechSchemeDetailEntity> techOrderDetailList = entity.getTechSchemeDetailList();
        if (CollectionUtils.isNotEmpty(techOrderDetailList)){
            techOrderDetailList.forEach(s->s.setDetailDate(entity.getMonth()));
        }

    	service.saveOrUpdate(entity, false);
    	TechSchemeVO vo = BeanMapper.map(entity, TechSchemeVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询上一期数据
     */
    @RequestMapping(value = "/selectLastDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<TechSchemeDetailVO>> queryDetail(String month) throws ParseException  {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Date date = format.parse(month);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(calendar.MONTH, -1);
        Date time = calendar.getTime();
        String lastDate = format.format(time);
        QueryWrapper curQuery = new QueryWrapper();
        curQuery.eq("DATE_FORMAT(month, '%Y-%m' )",lastDate);
        curQuery.in("bill_state",1,3);
        TechSchemeEntity techOrderEntity = service.getOne(curQuery);
        List<TechSchemeDetailVO> techOrderDetailEntities = new ArrayList<>();
        if (techOrderEntity != null){
            LambdaQueryWrapper<TechSchemeDetailEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
            lambdaQueryWrapper.eq(TechSchemeDetailEntity::getMid,techOrderEntity.getId());
            lambdaQueryWrapper.eq(TechSchemeDetailEntity::getPropertyCode,"1");
            List<TechSchemeDetailEntity> list = techSchemeDetailService.list(lambdaQueryWrapper);
            techOrderDetailEntities = BeanMapper.mapList(list, TechSchemeDetailVO.class);
            for (TechSchemeDetailVO techOrderDetailVO : techOrderDetailEntities){
                techOrderDetailVO.setId(IdWorker.getId());
                techOrderDetailVO.setMid(null);
            }
        }

        return CommonResponse.success("查询详情数据成功！",techOrderDetailEntities);
    }

    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "tech-scheme-import.xlsx", "在执行订单明细导入模板");
    }

    @PostMapping(value = "/excelImport")
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;

        //查询出图询价
        List<EngineeringReportVO> engineeringReportVOList = service.getReportList();
        Map<String, EngineeringReportVO> reportMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(engineeringReportVOList)){
             reportMap = engineeringReportVOList.stream().collect(Collectors.toMap(EngineeringReportVO::getBillCode, Function.identity(), (key1, key2) -> key2));
        }

        List<TechSchemeDetailVO> successList = new ArrayList<>();
        List<TechSchemeDetailVO> processList = new ArrayList<>();
        List<TechSchemeDetailVO> errorList = new ArrayList<>();

        //获取自定义档案 状态
        CommonResponse<List<DefdocDetailVO>> defDocByDefCodeStatus = defdocApi.getDefDocByDefCode("planListStatus");
        if (!defDocByDefCodeStatus.isSuccess()){
            throw new BusinessException("获取档案信息失败!");
        }

        List<DefdocDetailVO> defDocByDefCodeDataStataus = defDocByDefCodeStatus.getData();
        Map<String, DefdocDetailVO> defdocDetailVOStatusMap = defDocByDefCodeDataStataus.stream().collect(Collectors.toMap(DefdocDetailVO::getName, Function.identity(), (key1, key2) -> key2));

        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }

        List<List<String>> result = ExcelReader.readExcel(mf);
        if(result != null && result.size() > 0) {
            Map<String, TechSchemeDetailVO> codeMapCache = new HashMap<>();
            TechSchemeDetailVO importVo = null;
            for(int i = 1;i < result.size(); i++) {
                List<String> datas = result.get(i);
                importVo = new TechSchemeDetailVO();
                importVo.setId(IdWorker.getId());
                String projectCode = datas.get(0);
                importVo.setProjectCode(datas.get(0));
            /*    if (StringUtils.isBlank(projectCode)){
                    importVo.setErrorMsg("询价单据编号不能为空！");
                    errorList.add(importVo);
                    continue;
                }*/
                if (StringUtils.isNotBlank(projectCode)){
                    if (reportMap.containsKey(projectCode)){
                        EngineeringReportVO engineeringReportVO = reportMap.get(projectCode);
                        importVo.setProjectId(engineeringReportVO.getEmployeeId());
                        importVo.setProjectName(engineeringReportVO.getEngineeringName());
                        importVo.setResponseName(engineeringReportVO.getSaleLeaderName());
                        importVo.setCustomerName(engineeringReportVO.getCustomName());
                    }else{
                        importVo.setErrorMsg("询价单据编号不存在！");
                        errorList.add(importVo);
                        continue;
                    }
                }else {
                    importVo.setCustomerName(datas.get(1));
                    importVo.setProjectName(datas.get(2));
                    importVo.setResponseName(datas.get(3));
                }
                importVo.setProduct(datas.get(4));
                importVo.setSpec(datas.get(5));
                importVo.setProductType(datas.get(6));
                if(StringUtils.isNotBlank(datas.get(7))){
                    if(DateUtil.grepDate(datas.get(7))){
                        importVo.setReceiptDate(DateUtil.Date(datas.get(7)));
                    }else{
                        importVo.setErrorMsg("接收日期格式不正确！");
                        errorList.add(importVo);
                        continue;
                    }
                }
                if(StringUtils.isNotBlank(datas.get(8))){
                    if(DateUtil.grepDate(datas.get(8))){
                        importVo.setOutDate(DateUtil.Date(datas.get(8)));
                    }else{
                        importVo.setErrorMsg("出图日期格式不正确！");
                        errorList.add(importVo);
                        continue;
                    }
                }
                importVo.setDesignName(datas.get(9));
                importVo.setMemo(datas.get(11));

                if(StringUtils.isNotBlank(datas.get(10))){
                    if(defdocDetailVOStatusMap.containsKey(datas.get(10))){
                        DefdocDetailVO defdocDetailVO = defdocDetailVOStatusMap.get(datas.get(10));
                        importVo.setStatusId(defdocDetailVO.getId());
                        importVo.setStatusName(defdocDetailVO.getName());
                        importVo.setPropertyCode(defdocDetailVO.getAttrCode());
                    }else{
                        importVo.setErrorMsg("状态不在自定义档案库！");
                        errorList.add(importVo);
                        continue;
                    }
                }


                successList.add(importVo);
            }
        }

        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success(json);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TechSchemeVO> queryDetail(Long id) {
    	TechSchemeEntity entity = service.selectById(id);
    	TechSchemeVO vo = BeanMapper.map(entity, TechSchemeVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TechSchemeVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (TechSchemeVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(TechSchemeVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TechSchemeVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
//        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
//            /** 要求主表有orgId字段，保存单据所属组织 */
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
//        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
//            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
//        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        if (param.getParams().containsKey("month")){
            String month = param.getParams().get("month").getValue().toString();
            param.getParams().put(" ", new Parameter(QueryParam.SQL, "DATE_FORMAT( month, '%Y-%m' ) = '" +
                    month + "'"));
            param.getParams().remove("month");
        }
        IPage<TechSchemeEntity> page = service.queryPage(param,false);
        IPage<TechSchemeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), TechSchemeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<TechSchemeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("TechScheme-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refTechSchemeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<TechSchemeVO>> refTechSchemeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<TechSchemeEntity> page = service.queryPage(param,false);
        IPage<TechSchemeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), TechSchemeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
