package com.ejianc.business.jlprogress.tech.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jlprogress.tech.bean.*;
import com.ejianc.business.jlprogress.tech.vo.TechTestVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jlprogress.tech.service.ITechSituationService;
import com.ejianc.business.jlprogress.tech.vo.TechSituationVO;

/**
 * 工程技术-工程技术部研发工作情况
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("techSituation")
public class TechSituationController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "TECH-SIT";//此处需要根据实际修改

    @Autowired
    private ITechSituationService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TechSituationVO> saveOrUpdate(@RequestBody TechSituationVO saveOrUpdateVO) {
        //一个月只能做一条数据
        QueryWrapper curQuery = new QueryWrapper();
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM");
        String month = sdf1.format(saveOrUpdateVO.getMonth());
        curQuery.eq("DATE_FORMAT(month, '%Y-%m' )",month);
        if(saveOrUpdateVO.getId() != null){
            curQuery.ne("id",saveOrUpdateVO.getId());
        }
        int curCount = service.count(curQuery);
        if (curCount > 0) throw new BusinessException("一个月只能做一条数据！");

    	TechSituationEntity entity = BeanMapper.map(saveOrUpdateVO, TechSituationEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        //赋值子表月份数据
        List<TechSituationBzbzEntity> techSituationBzbzList = entity.getTechSituationBzbzList();
        List<TechSituationCgjdEntity> techSituationCgjdList = entity.getTechSituationCgjdList();
        List<TechSituationFmzlEntity> techSituationFmzlEntityList = entity.getTechSituationFmzlList();
        List<TechSituationLwfbEntity> techSituationLwfbEntityList = entity.getTechSituationLwfbList();
        List<TechSituationSyzlEntity> techSituationSyzlEntityList = entity.getTechSituationSyzlList();
        List<TechSituationXmlxEntity> techSituationXmlxList = entity.getTechSituationXmlxList();
        if (CollectionUtils.isNotEmpty(techSituationBzbzList)){
            techSituationBzbzList.forEach(s->s.setDetailDate(entity.getMonth()));
        }
        if (CollectionUtils.isNotEmpty(techSituationCgjdList)){
            techSituationCgjdList.forEach(s->s.setDetailDate(entity.getMonth()));
        }
        if (CollectionUtils.isNotEmpty(techSituationFmzlEntityList)){
            techSituationFmzlEntityList.forEach(s->s.setDetailDate(entity.getMonth()));
        }
        if (CollectionUtils.isNotEmpty(techSituationLwfbEntityList)){
            techSituationLwfbEntityList.forEach(s->s.setDetailDate(entity.getMonth()));
        }
        if (CollectionUtils.isNotEmpty(techSituationSyzlEntityList)){
            techSituationSyzlEntityList.forEach(s->s.setDetailDate(entity.getMonth()));
        }
        if (CollectionUtils.isNotEmpty(techSituationXmlxList)){
            techSituationXmlxList.forEach(s->s.setDetailDate(entity.getMonth()));
        }

    	service.saveOrUpdate(entity, false);
    	TechSituationVO vo = BeanMapper.map(entity, TechSituationVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TechSituationVO> queryDetail(Long id) {
    	TechSituationEntity entity = service.selectById(id);
    	TechSituationVO vo = BeanMapper.map(entity, TechSituationVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TechSituationVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (TechSituationVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(TechSituationVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TechSituationVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
//        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
//            /** 要求主表有orgId字段，保存单据所属组织 */
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
//        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
//            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
//            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
//        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        if (param.getParams().containsKey("month")){
            String month = param.getParams().get("month").getValue().toString();
            param.getParams().put(" ", new Parameter(QueryParam.SQL, "DATE_FORMAT( month, '%Y-%m' ) = '" +
                    month + "'"));
            param.getParams().remove("month");
        }
        IPage<TechSituationEntity> page = service.queryPage(param,false);
        IPage<TechSituationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), TechSituationVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * @Description queryDetail 查询上一期数据
     */
    @RequestMapping(value = "/selectLastDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TechSituationVO> queryDetail(String month) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Date date = format.parse(month);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(calendar.MONTH, -1);
        Date time = calendar.getTime();
        String lastDate = format.format(time);
        QueryWrapper curQuery = new QueryWrapper();
        curQuery.eq("DATE_FORMAT(month, '%Y-%m' )",lastDate);
        curQuery.in("bill_state",1,3);

        TechSituationEntity techTestEntity = service.getOne(curQuery);
        TechSituationVO techTestVO = new TechSituationVO();
        if (techTestEntity != null){
            TechSituationEntity techTestEntity1 = service.selectById(techTestEntity.getId());
            techTestVO = BeanMapper.map(techTestEntity1, TechSituationVO.class);
        }

        return CommonResponse.success("查询详情数据成功！",techTestVO);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<TechSituationEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("TechSituation-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refTechSituationData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<TechSituationVO>> refTechSituationData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<TechSituationEntity> page = service.queryPage(param,false);
        IPage<TechSituationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), TechSituationVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
